/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  hobj3d.h       9/19/99                                                 */
/*  Copyright (C) 1996 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_hobj3d_h)
#define _hobj3d_h

#include  "object3d.h"

class THObj3D : public TObject3D {
    Matrix3 wm;
    Vector  wp;
    Vector  velocity;
    Vector  wvelocity;
    Vector  AngleVelocity;
    Vector  accele;
    long    gravity;
    double  sx, sy, sz;
    int     sf;
  public:
    THObj3D *parent;
    THObj3D *brother;
    THObj3D *child;
    THObj3D(int vn, int pn, THObj3D* p);
    ~THObj3D();
    void SetWorld();

    void SetNodeWorldMatrix(long deltax);

    void show(THObj3D *eye);

    void GetWorldPosition(Vector &pos, long &h, long &p, long &b);

    void   SetVelocity(Vector v);
    Vector GetVelocity() { return velocity;};
    void   SetWVelocity(Vector wv);
    Vector GetWVelocity(){ return wvelocity;};
    void   SetAngleVelocity(Vector v){AngleVelocity = v;};
    Vector GetAngleVelocity(){ return AngleVelocity;};
    void   SetGravity(long g) { gravity = g;};
    long   GetGravity() { return gravity;};
    void   SetAccele(Vector v) { accele = v; };
    Vector GetAccele() { return accele;};
    void   SetScale(double x, double y, double z) {
             sx = x; sy = y; sz = z; sf = 1;
           };
    void   GetScale(double &x, double &y, double &z) {
             x = sx; y = sy; z = sz;
           };
    Vector GetDirection_world(const Vector &local) {
             return ConvCoordinate(wm, local);
           };

    Vector GetDirection_eye(const Vector &world) {
             return ConvCoordinate2(wm, world);
           };

    Vector GetDirection_local(const Vector &world) {
             return ConvCoordinate2(wm, world);
           };
    Vector WorldToLocal(Vector w) {
             w = w - wp;
             return ConvCoordinate2(wm, w);
           };

    Vector GetWorldOrigin() {return wp;};

};

#endif
