//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVPOLYATTR_H
#define WSCVPOLYATTR_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvpolyAttr_VER	1000

class WSCvpolyAttr :public WSCnwbase{

  protected:
    WSCushort _lw;
    short   _hatch_color;
    short   _hatch_blink_color;
    short   _back_color;
    short   _back_blink_color;
    unsigned  _hatch_pattern:4;
    unsigned  _lt:4;
    unsigned  _blink_type:2;
    unsigned  _stippled:1;
    unsigned  _back_color_flag:1;

    WSMFpropertyDef(WSNlineWidth, WSCushort, _lw);
    WSMFpropertyDef(WSNlineType,  WSCuchar,      _lt);
    WSMFpropertyDef(WSNstippled,        WSCbool, _stippled         );
    WSMFpropertyDef(WSNhatchPattern,    WSCuchar, _hatch_pattern    );
    WSMFpropertyDef(WSNhatchColor,      short,   _hatch_color      );
    WSMFpropertyDef(WSNhatchBlinkColor, short,   _hatch_blink_color);
    WSMFpropertyDef(WSNbackColorFlag,   WSCbool, _back_color_flag  );
    WSMFpropertyDef(WSNbackColor,       short,   _back_color       );
    WSMFpropertyDef(WSNbackBlinkColor,  short,   _back_blink_color );
    WSMFpropertyDef(WSNblinkType,       WSCuchar,_blink_type       );

  public:
    WSCvpolyAttr(WSCbase* base, char* name);
    virtual ~WSCvpolyAttr();

    WSMFguiClassDef(WSCvpolyAttr, WSCnwbase);
    WSMFversionDef  (WSCvpolyAttr);
};
#endif
