// WideMargin. Simple fast bible software.
// Copyright (C) 2011  Daniel Hughes
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using NUnit.Framework;
using WideMargin.GUI;
using NUnit.Framework.SyntaxHelpers;

namespace WideMargin.GUI.Tests
{
	[TestFixture()]
	public class PageRangerTests
	{
		[Test()]
		public void GetPageRangeInCenter ()
		{
			var ranger = new PageRanger();
			int firstPage;
			int lastPage;
			ranger.GetPageRange(20, 10, out firstPage, out lastPage);
			Assert.That(firstPage, Is.EqualTo(5));
			Assert.That(lastPage, Is.EqualTo(15));
		}
		
		[Test()]
		public void GetPageRangeFirstPage()
		{
			var ranger = new PageRanger();
			int firstPage;
			int lastPage;
			ranger.GetPageRange(20, 0, out firstPage, out lastPage);
			Assert.That(firstPage, Is.EqualTo(0));
			Assert.That(lastPage, Is.EqualTo(9));
		}
		
		[Test()]
		public void GetPageRangeLastPageStartingWith0()
		{
			var ranger = new PageRanger();
			int firstPage;
			int lastPage;
			ranger.GetPageRange(20, 5, out firstPage, out lastPage);
			Assert.That(firstPage, Is.EqualTo(0));
			Assert.That(lastPage, Is.EqualTo(9));
		}
		
		[Test()]
		public void GetPageRangeFirstPageNotStartingWith0()
		{
			var ranger = new PageRanger();
			int firstPage;
			int lastPage;
			ranger.GetPageRange(20, 6, out firstPage, out lastPage);
			Assert.That(firstPage, Is.EqualTo(1));
			Assert.That(lastPage, Is.EqualTo(10));
		}
		
		[Test()]
		public void GetPageRangeLastPage()
		{
			var ranger = new PageRanger();
			int firstPage;
			int lastPage;
			ranger.GetPageRange(20, 19, out firstPage, out lastPage);
			Assert.That(firstPage, Is.EqualTo(10));
			Assert.That(lastPage, Is.EqualTo(19));
		}
	}
}

