(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.
Require Import Omega.

Proof.
unfold sorted_array; intuition.
Save.

Proof.
intuition.
assert (h: k = i).
 omega.
subst result k; omega.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
assert (h: (k < j) \/ k = j).
 omega.
 intuition.
apply Zle_trans with (access t0 min).
subst min0; omega.
auto with *.
subst min0 k; omega.
Save.

Proof.
intuition.
assert (h: (k < j) \/ k = j).
 omega.
 intuition.
subst k; omega.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
Save.

Proof.
intuition.
ArraySubst t1.
Save.

Proof.
intuition.
ArraySubst t2.
ArraySubst t1.
assert (h: i = 0%Z \/ (0 < i)).
 omega.
 intuition.
replace (i0 - 1)%Z with 0%Z.
unfold sorted_array; intros; omega.
omega.
replace (i0 - 1)%Z with (i - 1 + 1)%Z.
apply right_extension.
omega.
ArraySubst t2.
ArraySubst t1.
apply sorted_array_id with t0.
assumption.
unfold array_id; intros.
subst t2; do 2 AccessOther.
replace (i - 1 + 1)%Z with i.
subst t2 t1; do 2 AccessOther.
subst result1.
auto with *.
omega.
omega.
apply permut_trans with t0.
subst t2; subst t1; subst result1 result2.
apply exchange_is_permut with min i; auto with *.
assumption.
assert (h: k = i \/ (k < i)).
 omega.
 intuition.
subst k.
subst t2.
AccessSame.
AccessOther.
subst t1.
assert (h: l = min \/ min <> l).
 omega.
 intuition.
subst l; AccessSame.
subst result1 result2; auto with *.
assert (h: l < array_length (update (update t0 min result2) i result1)).
assumption.
do 2 rewrite array_length_update in h.
AccessOther.
subst.
auto with *.
ArraySubst t1.
assert (h: i < array_length (update t0 min result2)). assumption.
rewrite array_length_update in h.
assert (h': l < array_length (update (update t0 min result2) i result1)). assumption.
do 2 rewrite array_length_update in h'.
omega.
subst.
AccessOther.
AccessOther.
AccessOther.
assert (h: l < array_length (update (update t0 min (access t0 i)) i (access t0 min))). assumption.
do 2 rewrite array_length_update in h.
assert (l = min \/ min <> l).
 omega.
 intuition.
subst l; AccessSame.
auto with *.
AccessOther.
auto with *.
assert (h: l < array_length (update (update t0 min (access t0 i)) i (access t0 min))). assumption.
do 2 rewrite array_length_update in h.
omega.
subst t2 t1; simpl; unfold Zwf; omega.
Save.

Proof.
intuition.
assert (i=0 \/ 0<i). omega. intuition.
unfold sorted_array; intros; omega.
replace (array_length t0 - 1)%Z with (i - 1 + 1)%Z.
apply right_extension; try omega.
 assumption.
auto with *.
omega.
Qed.



(*Why type*) Definition farray: Set ->Set.
Admitted.

(*Why logic*) Definition access : forall (A1:Set), (array A1) -> Z -> A1.
Admitted.
Implicit Arguments access.

(*Why logic*) Definition update :
  forall (A1:Set), (array A1) -> Z -> A1 -> (array A1).
Admitted.
Implicit Arguments update.

(*Why axiom*) Lemma access_update :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z), (forall (v:A1), (access (update a i v) i) = v))).
Admitted.

(*Why axiom*) Lemma access_update_neq :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (j:Z),
     (forall (v:A1), (i <> j -> (access (update a i v) j) = (access a j)))))).
Admitted.

(*Why logic*) Definition array_length : forall (A1:Set), (array A1) -> Z.
Admitted.
Implicit Arguments array_length.

(*Why predicate*) Definition sorted_array  (t:(array Z)) (i:Z) (j:Z)
  := (forall (k1:Z),
      (forall (k2:Z),
       ((i <= k1 /\ k1 <= k2) /\ k2 <= j -> (access t k1) <= (access t k2)))).

(*Why predicate*) Definition exchange (A106:Set) (a1:(array A106)) (a2:(array A106)) (i:Z) (j:Z)
  := (array_length a1) = (array_length a2) /\
     (access a1 i) = (access a2 j) /\ (access a2 i) = (access a1 j) /\
     (forall (k:Z), (k <> i /\ k <> j -> (access a1 k) = (access a2 k))).
Implicit Arguments exchange.

(*Why logic*) Definition permut :
  forall (A1:Set), (array A1) -> (array A1) -> Z -> Z -> Prop.
Admitted.
Implicit Arguments permut.

(*Why axiom*) Lemma permut_refl :
  forall (A1:Set),
  (forall (t:(array A1)), (forall (l:Z), (forall (u:Z), (permut t t l u)))).
Admitted.

(*Why axiom*) Lemma permut_sym :
  forall (A1:Set),
  (forall (t1:(array A1)),
   (forall (t2:(array A1)),
    (forall (l:Z), (forall (u:Z), ((permut t1 t2 l u) -> (permut t2 t1 l u)))))).
Admitted.

(*Why axiom*) Lemma permut_trans :
  forall (A1:Set),
  (forall (t1:(array A1)),
   (forall (t2:(array A1)),
    (forall (t3:(array A1)),
     (forall (l:Z),
      (forall (u:Z),
       ((permut t1 t2 l u) -> ((permut t2 t3 l u) -> (permut t1 t3 l u)))))))).
Admitted.

(*Why axiom*) Lemma permut_exchange :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      (forall (i:Z),
       (forall (j:Z),
        (l <= i /\ i <= u ->
         (l <= j /\ j <= u -> ((exchange a1 a2 i j) -> (permut a1 a2 l u)))))))))).
Admitted.

(*Why axiom*) Lemma exchange_upd :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (j:Z),
     (exchange a (update (update a i (access a j)) j (access a i)) i j)))).
Admitted.

(*Why axiom*) Lemma permut_weakening :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l1:Z),
     (forall (r1:Z),
      (forall (l2:Z),
       (forall (r2:Z),
        ((l1 <= l2 /\ l2 <= r2) /\ r2 <= r1 ->
         ((permut a1 a2 l2 r2) -> (permut a1 a2 l1 r1))))))))).
Admitted.

(*Why axiom*) Lemma permut_eq :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      (l <= u ->
       ((permut a1 a2 l u) ->
        (forall (i:Z), (i < l \/ u < i -> (access a2 i) = (access a1 i))))))))).
Admitted.

(*Why predicate*) Definition permutation (A115:Set) (a1:(array A115)) (a2:(array A115))
  := (permut a1 a2 0 ((array_length a1) - 1)).
Implicit Arguments permutation.

(*Why axiom*) Lemma array_length_update :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (v:A1), (array_length (update a i v)) = (array_length a)))).
Admitted.

(*Why axiom*) Lemma permut_array_length :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      ((permut a1 a2 l u) -> (array_length a1) = (array_length a2)))))).
Admitted.

