import pygame
from pygame.locals import *
import os
import codecs
import datetime

from locals import *

import data

from sound import play_sound

from variables import Variables, error_message, log_message

class Score:
  def __init__(self, score, life = PLAYER_LIFE, time = 0, levels = 0):
    self.score = score
    self.life = life
    self.time = time
    self.levels = levels
    return

class Util:

  pygame.font.init()
  smallfont = pygame.font.Font(data.filepath(os.path.join("misc", "Vera.ttf")), FONT_SIZE)
  cached_text_images = {}
  cached_images = {}
  cached_images["key_z"] = pygame.image.load(data.picpath("key", "z"))
  cached_images["key_p"] = pygame.image.load(data.picpath("key", "p"))
  cached_images["health_bar_fill"] = pygame.image.load(data.picpath("health_bar", "fill"))
  cached_images["health_bar_empty"] = pygame.image.load(data.picpath("health_bar", "empty"))
  fade_state = FADE_STATE_BLACK
  blackscreen = pygame.Surface((SCREEN_WIDTH, SCREEN_HEIGHT))

#This function returns a path for saving config in the user's home directory
def get_config_path():
  path_name = ""
  try:
    path_name = os.path.join(os.environ["HOME"], ".wwisup")
  except:
    try:
      path_name = os.path.join(os.environ["APPDATA"], "Wwisup")
    except:
      error_message("Couldn't get environment variable for home directory, using data directory instead")
      path_name = data.filepath("saves")
  if not os.path.exists(path_name):
    os.mkdir(path_name)
  return path_name

#This parses a config file stored in the location given by the above function
def parse_config():
  for world in WORLDS:
    Variables.vdict["unlocked" + world] = 0
    Variables.vdict["hiscore" + world] = 0
    Variables.vdict["besttime" + world] = 0
  Variables.vdict["sound"] = True
  Variables.vdict["dialogue"] = True
  Variables.vdict["verbose"] = False
  file_path = os.path.join(get_config_path(), "config.txt")
  try:
    conffile = open(file_path)
    for line in conffile.readlines():
      if line.strip() != "":
        values = line.split("\t")

        if values[0] == "unlocked":
          try:
            Variables.vdict["unlocked" + values[1]] = int(values[2])
          except:
            Variables.vdict["unlocked" + WORLDS[0]] = int(values[1])  #Old style config file compatibility

        elif values[0] == "hiscore":
          try:
            Variables.vdict["hiscore" + values[1]] = int(values[2])
          except:
            Variables.vdict["hiscore" + WORLDS[0]] = int(values[1])  #Old style config file compatibility

        elif values[0] == "besttime":
          Variables.vdict["besttime" + values[1]] = int(values[2])

        elif values[0] == "sound":
          Variables.vdict["sound"] = str_to_bool(values[1])

        elif values[0] == "dialogue":
          Variables.vdict["dialogue"] = str_to_bool(values[1])

  except:
    if write_config():
      log_message("Created configuration file to " + file_path)
  return

def write_config():
  file_path = os.path.join(get_config_path(), "config.txt")
  try:
    conffile = codecs.open(file_path, "w", "utf_8")
    for world in WORLDS:
      print >> conffile, "unlocked\t%(world)s\t%(unlocked)s" % {"world": world, "unlocked": Variables.vdict["unlocked" + world]}
      print >> conffile, "hiscore\t%(world)s\t%(hiscore)s" % {"world": world, "hiscore": Variables.vdict["hiscore" + world]}
      print >> conffile, "besttime\t%(world)s\t%(besttime)s" % {"world": world, "besttime": Variables.vdict["besttime" + world]}
    print >> conffile, "sound\t%s" % bool_to_str(Variables.vdict["sound"])
    print >> conffile, "dialogue\t%s" % bool_to_str(Variables.vdict["dialogue"])
  except:
    error_message("Could not write configuration file to " + file_path)
    return False
  return True

def write_log():
  file_path = os.path.join(get_config_path(), "log.txt")
  old_log = ""
  if os.path.exists(file_path):
    conffile = open(file_path)
    count = 0
    for line in conffile.readlines():
      old_log = old_log + line
      count += 1
      if count > MAX_OLD_LOG_LINES:
        break
  if Variables.vdict.has_key("log"):
    try:
      conffile = codecs.open(file_path, "w", "utf_8")
      print >> conffile, "Log updated " + str(datetime.date.today())
      print >> conffile, Variables.vdict["log"]
      print >> conffile, ""
      print >> conffile, old_log
    except:
      error_message("Could not write log file to " + file_path)
      return False
  return True

def str_to_bool(string):
  string = string.strip()
  return (string == "true" or string == "True" or string == "1" or string == "on")

def bool_to_str(bool):
  if bool:
    return "on"
  else:
    return "off"

def render_gui(screen, life, score, topleft):
  score_image = render_text("Score: " + str(score) )
  #life_image = render_text("Life: " + str(life) )
  life_image = render_text("Life:")
  #life_bar_bg_image = Util.cached_images["health_bar_empty"]
  #life_bar_image = Util.cached_images["health_bar_fill"]
  version_image = render_text("0.7.0")

  rect = score_image.get_rect()
  rect.left = topleft[0]
  rect.top = topleft[1]
  screen.blit(score_image, rect)

  rect.left = topleft[0] + 26
  rect.top = topleft[1] + 26
  rect.width = 38
  rect.height = 8
  pygame.draw.rect(screen, COLOR_GUI_BG, rect)
  if life > 0:
    rect.left = topleft[0] + 27
    rect.top = topleft[1] + 27
    rect.width = life
    rect.height = 6
    pygame.draw.rect(screen, COLOR_BLOOD, rect)

  rect = life_image.get_rect()
  rect.left = topleft[0]
  rect.top = topleft[1] + 20
  screen.blit(life_image, rect)

  rect = version_image.get_rect()
  rect.right = SCREEN_WIDTH - 2
  rect.bottom = SCREEN_HEIGHT - 2
  screen.blit(version_image, rect)
  return

#This function renders text on screen and handles caching of text images:
def render_text(string, color = COLOR_GUI, bgcolor = COLOR_GUI_BG):
  if Util.cached_text_images.has_key(string + str(color) + str(bgcolor)):
    final_image = Util.cached_text_images[string + str(color) + str(bgcolor)]
  else:
    text_image_bg = Util.smallfont.render(string, True, bgcolor)
    text_image_fg = Util.smallfont.render(string, True, color)
    rect = text_image_bg.get_rect()
    final_image = pygame.Surface((rect.width + 2, rect.height + 2)).convert_alpha()

    final_image.fill((0,0,0,0))

    final_image.blit(text_image_bg, rect)
    final_image.blit(text_image_bg, (1,0))
    final_image.blit(text_image_bg, (2,0))

    final_image.blit(text_image_bg, (0,2))
    final_image.blit(text_image_bg, (1,2))
    final_image.blit(text_image_bg, (2,2))

    final_image.blit(text_image_fg, (1,1))
    Util.cached_text_images[string + str(color) + str(bgcolor)] = final_image
  return final_image

def render_text_dialogue(screen, string, phase, key = "z"):
  if phase == -1:
    phase = len(string)

  rendered_string = string[0:phase]
  string_image = render_text(rendered_string)
  string_rect = string_image.get_rect()
  string_rect.centerx = SCREEN_WIDTH / 2
  string_rect.centery = SCREEN_HEIGHT / 2

  if key == "p":
    skip_image = Util.cached_images["key_p"]
  else:
    skip_image = Util.cached_images["key_z"]

  skip_rect = skip_image.get_rect()
  skip_rect.centerx = SCREEN_WIDTH / 2
  skip_rect.top = string_rect.bottom + 5

  bg_rect = pygame.Rect(string_rect.left - 10, string_rect.top - 5, string_rect.width + 20, string_rect.height + skip_rect.height + 15)
  bg_image = pygame.Surface((bg_rect.width, bg_rect.height))  
  bg_image.set_alpha(FADE_STATE_HALF)

  screen.blit(bg_image, bg_rect)

  screen.blit(string_image, string_rect)

  screen.blit(skip_image, skip_rect)

  if phase < len(string):
    phase += 1
    play_sound("click")
  else:
    return -1

  return phase

def cycle_clockwise(orientation):
  orientation += 1
  if orientation > 3:
    orientation = 0
  return orientation
  
def cycle_counter_clockwise(orientation):
  orientation -= 1
  if orientation < 0:
    orientation = 3
  return orientation

def get_direction(orientation):
  if orientation == RIGHT:
    return (1, 0)
  if orientation == LEFT:
    return (-1, 0)
  if orientation == UP:
    return (0, -1)
  if orientation == DOWN:
    return (0, 1)
  return (0, 0)

def dir_from_str(string):
  if string == "LEFT":
    return LEFT
  if string == "UP":
    return UP
  if string == "DOWN":
    return DOWN
  return RIGHT

#This function fades the screen to black.
#Both fade-in and fade-out.
#Returns true if the fading has finished.
def fade_to_black(screen, fade_target):
  if Util.fade_state > fade_target:
    Util.fade_state += int(255 / (FPS * FADE_IN))
    if Util.fade_state < fade_target:
      Util.fade_state = fade_target
  if Util.fade_state < fade_target:
    Util.fade_state -= -int(255 / (FPS * FADE_OUT))
    if Util.fade_state > fade_target:
      Util.fade_state = fade_target
  if Util.fade_state > FADE_STATE_NONE:
    Util.blackscreen.set_alpha(Util.fade_state)
    screen.blit(Util.blackscreen, screen.get_rect())
  return (Util.fade_state == fade_target)