# -*- coding: utf-8 -*-

# Copyright(C) 2013      Vincent A
#
# This file is part of weboob.
#
# weboob is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# weboob is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with weboob. If not, see <http://www.gnu.org/licenses/>.


from weboob.tools.test import BackendTest
from uuid import uuid4


class GuerrillamailTest(BackendTest):
    BACKEND = 'guerrillamail'

    def test_guerrillamail(self):
        box = uuid4()
        thread = self.backend.get_thread(box)
        self.assertTrue(thread)
        message = thread.root
        self.assertTrue(message)
        self.assertTrue(message.sender)
        self.assertTrue(message.title)
        self.assertTrue(message.date)
        self.assertTrue(message.receivers)
