# log_parser.pl
# Functions for parsing this module's logs

do 'virtual-server-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p, $long) = @_;
if ($type eq "user") {
	return &text('log_'.$action.'_user', "<tt>$object</tt>",
					     "<tt>$p->{'dom'}</tt>");
	}
elsif ($type eq "alias") {
	return &text('log_'.$action.'_alias', "<tt>$object</tt>");
	}
elsif ($type eq "domain") {
	return &text('log_'.$action.'_domain', "<tt>$object</tt>");
	}
elsif ($action eq "start" || $action eq "stop") {
	return $text{'log_'.$action.'_'.$type};
	}
elsif ($action eq "backup" || $action eq "restore") {
	local @doms = split(/\0/, $p->{'doms'});
	if ($long) {
		return &text('log_'.$action.'_l', join(" ", map { "<tt>$_</tt>" } @doms));
		}
	else {
		return &text('log_'.$action, scalar(@doms));
		}
	}
elsif ($action eq "sched") {
	return $text{'log_sched_'.$type};
	}
else {
	return $text{'log_'.$action};
	}
return undef;
}

