#!/usr/local/bin/perl
# Show a form for backing up a single virtual server, or a bunch
#
# XXX support use by domain owners?
# XXX should restore actually create the virtual server?

require './virtual-server-lib.pl';
&ReadParse();
&master_admin() || &error($text{'backup_ecannot'});
if ($in{'sched'}) {
	&header($text{'backup_title2'}, "");
	print "<hr>\n";
	print "<form action=backup_sched.cgi method=post>\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'backup_header2'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	}
else {
	&header($text{'backup_title'}, "");
	print "<hr>\n";
	print "<form action=backup.cgi method=post>\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'backup_header'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	}

# Show domain selection list
@doms = &list_domains();
%bak = map { $_, 1 } split(/\s+/, $config{'backup_doms'});
print "<tr> <td valign=top><b>$text{'backup_doms'}</td> <td>\n";
printf "<input type=radio name=all value=1 %s> %s\n",
	$config{'backup_all'} ? "checked" : "", $text{'backup_all'};
printf "<input type=radio name=all value=0 %s> %s<br>\n",
	$config{'backup_all'} ? "" : "checked", $text{'backup_sel'};
$sz = scalar(@doms) > 10 ? 10 : scalar(@doms);
print "<select name=doms multiple size=$sz width=400>\n";
foreach $d (sort { $a->{'dom'} cmp $b->{'dom'} } @doms) {
	printf "<option value=%s %s>%s\n",
		$d->{'id'}, $bak{$d->{'id'}} ? "selected" : "", $d->{'dom'};
	}
print "</select></td> </tr>\n";

# Show feature selection boxes
print "<tr> <td valign=top><b>$text{'backup_features'}</td> <td>\n";
foreach $f (@backup_features) {
	local $bfunc = "backup_$f";
	if (defined(&$bfunc) &&
	    ($config{$f} || $f eq "unix" || $f eq "virtualmin")) {
		printf "<input type=checkbox name=feature value=%s %s> %s\n",
			$f, $config{'backup_feature_'.$f} ? "checked" : "",
			$text{'backup_feature_'.$f} || $text{'feature_'.$f};
		local $ofunc = "show_backup_$f";
		if (defined(&$ofunc)) {
			local %opts = map { split(/=/, $_) }
					 split(/,/, $config{'backup_opts_'.$f});
			local $ohtml = &$ofunc(\%opts);
			print $ohtml;
			}
		print "<br>\n";
		}
	}
print "</td> </tr>\n";

# Show destination fields
print "<tr> <td valign=top><b>$text{'backup_dest'}</td>\n";
print "<td>",&show_backup_destination("dest", $config{'backup_dest'}),
      "</td> </tr>\n";

print "<tr> <td></td>\n";
printf "<td><input type=checkbox name=strftime value=1 %s> %s</td> </tr>\n",
	$config{'backup_strftime'} ? "checked" : "", $text{'backup_strftime'};

print "<tr> <td><b>$text{'backup_fmt'}</td> <td>\n";
printf "<input type=radio name=fmt value=0 %s> %s\n",
	$config{'backup_fmt'} == 0 ? "checked" : "", $text{'backup_fmt0'};
printf "<input type=radio name=fmt value=1 %s> %s</td> </tr>\n",
	$config{'backup_fmt'} == 1 ? "checked" : "", $text{'backup_fmt1'};

# Show error mode
print "<tr> <td><b>$text{'backup_errors'}</td> <td>\n";
printf "<input type=radio name=errors value=0 %s> %s\n",
	$config{'backup_errors'} == 0 ? "checked" : "", $text{'backup_errors0'};
printf "<input type=radio name=errors value=1 %s> %s</td> </tr>\n",
	$config{'backup_errors'} == 1 ? "checked" : "", $text{'backup_errors1'};

if ($in{'sched'}) {
	# Show schedule inputs
	&foreign_require("cron", "cron-lib.pl");
	local @jobs = &cron::list_cron_jobs();
	local ($job) = grep { $_->{'user'} eq 'root' &&
			      $_->{'command'} eq $backup_cron_cmd } @jobs;

	# Enabled/disabled input
	print "<tr> <td><b>$text{'backup_enabled'}</b></td>\n";
	printf "<td><input type=radio name=enabled value=0 %s> %s\n",
		$job ? "" : "checked", $text{'no'};
	printf "<input type=radio name=enabled value=1 %s> %s</td> </tr>\n",
		$job ? "checked" : "", $text{'backup_enabledyes'};

	# Email input
	print "<tr> <td><b>$text{'backup_email'}</b></td>\n";
	printf "<td><input name=email size=40 value='%s'></td> </tr>\n",
		$config{'backup_email'};

	# Times input
	print "<tr> <td colspan=2><table border>\n";
	$job ||= { 'special' => 'daily' };
	&cron::show_times_input($job);
	print "</table></td> </tr>\n";

	print "</table></td></tr></table>\n";
	print "<input type=submit value='$text{'backup_save'}'></form>\n";
	}
else {
	print "</table></td></tr></table>\n";
	print "<input type=submit value='$text{'backup_now'}'></form>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

