# virtual-server-lib.pl
# Common functions for Virtualmin
# XXX qmail support
#	XXX importing
#	XXX stop/start server
#	XXX user aliases
#	XXX all use of mail_system
#	XXX test all the alias types
#	XXX qmail not accepting mail! (works for users, not aliases?)
#	XXX 'all mailboxes' support (use default)

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();
$master_admin = !$access{'noconfig'};
$single_domain_mode = $access{'domains'} =~ /^\d+$/ &&
		      !$access{'edit'} && !$access{'create'} &&
		      !$access{'stop'} && !$access{'local'};
if (!$master_admin) {
	# Allowed alias types are set by module config
	%can_alias_types = map { $_, 1 } split(/,/, $config{'alias_types'});
	}
else {
	# All types are allowed
	%can_alias_types = map { $_, 1 } (0 .. 8);
	}

$first_print = \&first_html_print;
$second_print = \&second_html_print;
$indent_print = \&indent_html_print;
$outdent_print = \&outdent_html_print;

@opt_features = ( 'dns', 'mail', 'web', 'webalizer', 'ssl', 'mysql', 'postgres', 'ftp', 'webmin' );
@features = ( 'unix', @opt_features );
@backup_features = ( 'virtualmin', @features );
foreach $fname (@features) {
	require "$module_root_directory/feature-$fname.pl";
	}

$backup_cron_cmd = "$module_config_directory/backup.pl";

sub require_useradmin
{
return if ($require_useradmin++);
&foreign_require("useradmin", "user-lib.pl");
%uconfig = &foreign_config("useradmin");
&foreign_require("quota", "quota-lib.pl");
$home_base = $config{'home_base'} || $uconfig{'home_base'};
}

$domains_dir = "$module_config_directory/domains";

# list_domains()
# Returns a list of structures containing information about hosted domains
sub list_domains
{
local (@rv, $d);
opendir(DIR, $domains_dir);
foreach $d (readdir(DIR)) {
	if ($d !~ /^\./ && $d !~ /\.(lock|bak|rpmsave)$/i) {
		push(@rv, &get_domain($d));
		}
	}
closedir(DIR);
return @rv;
}

# get_domain(id)
sub get_domain
{
local %dom;
&read_file("$domains_dir/$_[0]", \%dom) || return undef;
$dom{'file'} = "$domains_dir/$_[0]";
$dom{'id'} = $_[0];
$dom{'mail'} = 1 if (!defined($dom{'mail'}));	# compat - assume mail is on
$dom{'ugid'} = $dom{'gid'} if (!defined($dom{'ugid'}));	# compat - assume same
if ($dom{'disabled'} eq '1') {
	# compat - assume everything was disabled
	$dom{'disabled'} = "unix,web,dns,mail,mysql,postgres";
	}
elsif ($dom{'disabled'}) {
	# compat - user disabled has changed to unix
	$dom{'disabled'} =~ s/user/unix/g;
	}
if (!defined($dom{'created'})) {
	# compat - creation date can be inferred from ID
        $dom{'id'} =~ /^(\d{10})/;
        $dom{'created'} = $1;
        }
if (!defined($dom{'gid'})) {
	# compat - get GID from group name
	$dom{'gid'} = getgrnam($dom{'group'});
	}
if (!defined($dom{'unix'})) {
	# compat - unix is always on
	$dom{'unix'} = 1;
	}
if (!defined($dom{'virt'})) {
	# compat - assume virtual IP if interface assigned
	$dom{'virt'} = $dom{'iface'} ? 1 : 0;
	}
if (!defined($dom{'web_port'}) && $dom{'web'}) {
	# compat - assume web port is current setting
	$dom{'web_port'} = $web_port;
	}
if (!defined($dom{'web_sslport'}) && $dom{'ssl'}) {
	# compat - assume SSL port is current setting
	$dom{'web_sslport'} = $web_sslport;
	}
return \%dom;
}

# get_domain_by(field, value)
sub get_domain_by
{
local $d;
foreach $d (&list_domains()) {
	if ($d->{$_[0]} eq $_[1]) {
		return $d;
		}
	}
return undef;
}

# domain_id()
# Returns a new unique domain ID
sub domain_id
{
return time().$$;
}

# save_domain(&domain)
sub save_domain
{
mkdir($domains_dir, 0700);
&lock_file("$domains_dir/$_[0]->{'id'}");
$_[0]->{'id'} = &domain_id() if (!$_[0]->{'id'});
$_[0]->{'created'} = time() if (!$_[0]->{'created'});
&write_file("$domains_dir/$_[0]->{'id'}", $_[0]);
&unlock_file("$domains_dir/$_[0]->{'id'}");
return 1;
}

# delete_domain(&domain)
sub delete_domain
{
&lock_file("$domains_dir/$_[0]->{'id'}");
unlink("$domains_dir/$_[0]->{'id'}");
&unlock_file("$domains_dir/$_[0]->{'id'}");
}

# list_domain_users([&domain], [skipunix])
# List all Unix users who are in the domain's primary group, except the owner.
# If domain is omitted, returns local users.
sub list_domain_users
{
# Get all aliases (and maybe generics) to look for those that match users
local (%aliases, %generics);
if ($config{'mail'}) {
	&require_mail();
	if ($config{'mail_system'} == 1) {
		%aliases = map { $_->{'name'}, $_ } grep { $_->{'enabled'} }
			       &sendmail::list_aliases($sendmail_afiles);
		if ($config{'generics'}) {
			%generics = map { $_->{'from'}, $_ }
				      &sendmail::list_generics($sendmail_gfile);
			}
		}
	elsif ($config{'mail_system'} == 0) {
		%aliases = map { $_->{'name'}, $_ }
			       &postfix::list_aliases($postfix_afiles);
		if ($config{'generics'}) {
			local $cans = &postfix::get_maps($canonical_type);
			%generics = map { $_->{'name'}, $_ } @$cans;
			}
		}
	}

# Get all virtusers to look for those for users
local @virts = &list_virtusers();

local @users = &list_all_users_quotas();
if ($_[0]) {
	# Limit to domain users
	@users = grep { $_->{'gid'} == $_[0]->{'gid'} ||
			$_->{'user'} eq $_[0]->{'user'} } @users;
	@users = grep { $_->{'user'} ne $_[0]->{'user'} } @users if ($_[1]);
	}
else {
	# Limit to local users
	local @lg = getgrnam($config{'localgroup'});
	@users = grep { $_->{'gid'} == $lg[2] } @users;
	}
foreach $u (@users) {
	if ($aliases{$u->{'user'}}) {
		$u->{'alias'} = $aliases{$u->{'user'}};
		$u->{'to'} = $u->{'alias'}->{'values'};
		}
	$u->{'generic'} = $generics{$u->{'user'}};
	local $pop3 = $_[0] ? &remove_userdom($u->{'user'}, $_[0])
			    : $u->{'user'};
	local $email = $_[0] ? "$pop3\@$_[0]->{'dom'}" : undef;
	foreach $v (@virts) {
		if (@{$v->{'to'}} == 1 && $v->{'to'}->[0] eq $u->{'user'} &&
		    (!$_[0] || $v->{'from'} ne $_[0]->{'dom'})) {
			if ($v->{'from'} eq $email) {
				$u->{'email'} = $email;
				$u->{'virt'} = $v;
				}
			else {
				push(@{$u->{'extraemail'}}, $v->{'from'});
				push(@{$u->{'extravirt'}}, $v);
				}
			}
		}
	}
return @users;
}

# list_all_users_quotas()
# Returns a list of all Unix users, with quota info
sub list_all_users_quotas
{
# Get quotas for all users
&require_useradmin();
local $qv = $config{'hard_quotas'} ? 'hblocks' : 'sblocks';
if (!defined(%home_quotas) && $config{'home_quotas'}) {
	local $n = &quota::filesystem_users($config{'home_quotas'});
	local $i;
	for($i=0; $i<$n; $i++) {
		$home_quota{$quota::user{$i,'user'}} = $quota::user{$i,$qv};
		$used_home_quota{$quota::user{$i,'user'}} =
			$quota::user{$i,'ublocks'};
		}
	}
if (!defined(%mail_quotas) && $config{'mail_quotas'} &&
    $config{'mail_quotas'} ne $config{'home_quotas'}) {
	local $n = &quota::filesystem_users($config{'mail_quotas'});
	local $i;
	for($i=0; $i<$n; $i++) {
		$mail_quota{$quota::user{$i,'user'}} = $quota::user{$i,$qv};
		$used_mail_quota{$quota::user{$i,'user'}} =
			$quota::user{$i,'ublocks'};
		}
	}

# Get user list and add in quota info
local @users = &useradmin::list_users();
local $u;
foreach $u (@users) {
	$u->{'quota'} = $home_quota{$u->{'user'}};
	$u->{'uquota'} = $used_home_quota{$u->{'user'}};
	$u->{'mquota'} = $mail_quota{$u->{'user'}};
	$u->{'umquota'} = $used_mail_quota{$u->{'user'}};
	}
return @users;
}

# create_user(&user, [&domain])
# Create a mailbox or local user, his virtuser and possibly his alias
sub create_user
{
&require_useradmin();
&require_mail();

# Add the user
&useradmin::set_user_envs($_[0], 'CREATE_USER', $_[0]->{'plainpass'}, [ ]);
&useradmin::making_changes();
&useradmin::lock_user_files();
&useradmin::create_user($_[0]);
&useradmin::unlock_user_files();
&useradmin::made_changes();

# Add his virtusers addresses
local $firstemail;
if ($_[0]->{'email'}) {
	local $virt = { 'from' => $_[0]->{'email'},
			'to' => [ $_[0]->{'user'} ] };
	&create_virtuser($virt);
	$_[0]->{'virt'} = $virt;
	$firstemail ||= $_[0]->{'email'};
	}
local @extravirt;
foreach $e (@{$_[0]->{'extraemail'}}) {
	local $virt = { 'from' => $e,
			'to' => [ $_[0]->{'user'} ] };
	&create_virtuser($virt);
	push(@extravirt, $virt);
	$firstemail ||= $e;
	}
$_[0]->{'extravirt'} = \@extravirt;

# Add his alias, if any
if ($_[0]->{'to'}) {
	local $alias = { 'name' => $_[0]->{'user'},
			 'enabled' => 1,
			 'values' => $_[0]->{'to'} };
	&check_alias_clash($_[0]->{'user'}) &&
		&error(&text('alias_eclash2', $_[0]->{'user'}));
	if ($config{'mail_system'} == 1) {
		&sendmail::lock_alias_files($sendmail_afiles);
		&sendmail::create_alias($alias, $sendmail_afiles);
		&sendmail::unlock_alias_files($sendmail_afiles);
		}
	elsif ($config{'mail_system'} == 0) {
		&postfix::lock_alias_files($postfix_afiles);
		&postfix::create_alias($alias, $postfix_afiles);
		&postfix::unlock_alias_files($postfix_afiles);
		&postfix::regenerate_aliases();
		}
	elsif ($config{'mail_system'} == 2) {
		# Not done for qmail yet
		}
	$_[0]->{'alias'} = $alias;
	}

if ($config{'generics'} && $firstemail) {
	# Add genericstable entry too
	if ($config{'mail_system'} == 1) {
		local $gen = { 'from' => $_[0]->{'user'}, 'to' => $firstemail };
		&lock_file($sendmail_gfile);
		&sendmail::create_generic($gen, $sendmail_gfile,
					  $sendmail_gdbm, $sendmail_gdbmtype);
		&unlock_file($sendmail_gfile);
		}
	elsif ($config{'mail_system'} == 0) {
		local $gen = { 'name' => $_[0]->{'user'},
			       'value' => $firstemail };
		&lock_file($canonical_map_files[0]);
		&postfix::create_mapping($canonical_type, $gen);
		&unlock_file($canonical_map_files[0]);
		}
	elsif ($config{'mail_system'} == 2) {
		# is this even possible for qmail?
		}
	}
}

# modify_user(&user, &old, &domain)
sub modify_user
{
&require_useradmin();
&require_mail();

# Update the unix user
&useradmin::set_user_envs($_[0], 'MODIFY_USER', $_[0]->{'plainpass'});
&useradmin::making_changes();
&useradmin::lock_user_files();
&useradmin::modify_user($_[1], $_[0]);
&useradmin::unlock_user_files();
&useradmin::made_changes();

# Take away all virtusers and add new ones
&delete_virtuser($_[1]->{'virt'}) if ($_[1]->{'virt'});
local $e;
foreach $e (@{$_[1]->{'extravirt'}}) {
	&delete_virtuser($e);
	}
local $firstemail;
if ($_[0]->{'email'}) {
	local $virt = { 'from' => $_[0]->{'email'},
			'to' => [ $_[0]->{'user'} ] };
	&create_virtuser($virt);
	$_[0]->{'virt'} = $virt;
	$firstemail ||= $_[0]->{'email'};
	}
local @extravirt;
foreach $e (@{$_[0]->{'extraemail'}}) {
	local $virt = { 'from' => $e,
			'to' => [ $_[0]->{'user'} ] };
	&create_virtuser($virt);
	push(@extravirt, $virt);
	$firstemail ||= $e;
	}
$_[0]->{'extravirt'} = \@extravirt;

# Update, create or delete alias
if ($_[0]->{'to'} && !$_[1]->{'to'}) {
	# Need to add alias
	local $alias = { 'name' => $_[0]->{'user'},
			 'enabled' => 1,
			 'values' => $_[0]->{'to'} };
	&check_alias_clash($_[0]->{'user'}) &&
		&error(&text('alias_eclash2', $_[0]->{'user'}));
	if ($config{'mail_system'} == 1) {
		&sendmail::lock_alias_files($sendmail_afiles);
		&sendmail::create_alias($alias, $sendmail_afiles);
		&sendmail::unlock_alias_files($sendmail_afiles);
		}
	elsif ($config{'mail_system'} == 0) {
		&postfix::lock_alias_files($postfix_afiles);
		&postfix::create_alias($alias, $postfix_afiles);
		&postfix::unlock_alias_files($postfix_afiles);
		&postfix::regenerate_aliases();
		}
	$_[0]->{'alias'} = $alias;
	}
elsif (!$_[0]->{'to'} && $_[1]->{'to'}) {
	# Need to delete alias
	if ($config{'mail_system'} == 1) {
		&lock_file($_[0]->{'alias'}->{'file'});
		&sendmail::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		}
	elsif ($config{'mail_system'} == 0) {
		&lock_file($_[0]->{'alias'}->{'file'});
		&postfix::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		&postfix::regenerate_aliases();
		}
	}
elsif ($_[0]->{'to'} && $_[1]->{'to'}) {
	# Need to update the alias
	local $alias = { 'name' => $_[0]->{'user'},
			 'enabled' => 1,
			 'values' => $_[0]->{'to'} };
	if ($config{'mail_system'} == 1) {
		&lock_file($_[1]->{'alias'}->{'file'});
		&sendmail::modify_alias($_[1]->{'alias'}, $alias);
		&unlock_file($_[1]->{'alias'}->{'file'});
		}
	elsif ($config{'mail_system'} == 0) {
		&lock_file($_[1]->{'alias'}->{'file'});
		&postfix::modify_alias($_[1]->{'alias'}, $alias);
		&unlock_file($_[1]->{'alias'}->{'file'});
		&postfix::regenerate_aliases();
		}
	$_[0]->{'alias'} = $alias;
	}

if ($config{'generics'} && $_[0]->{'generic'}) {
	# Update genericstable entry too
	if ($config{'mail_system'} == 1) {
		&lock_file($sendmail_gfile);
		&sendmail::delete_generic($_[0]->{'generic'}, $sendmail_gfile,
				$sendmail_gdbm, $sendmail_gdbmtype);
		if ($firstemail) {
			local $gen = { 'from' => $_[0]->{'user'},
				       'to' => $firstemail };
			&sendmail::create_generic($gen, $sendmail_gfile,
					  $sendmail_gdbm, $sendmail_gdbmtype)
			}
		&unlock_file($sendmail_gfile);
		}
	elsif ($config{'mail_system'} == 0) {
		&lock_file($canonical_map_files[0]);
		&postfix::delete_mapping($canonical_type, $_[0]->{'generic'});
		if ($firstemail) {
			local $gen = { 'name' => $_[0]->{'user'},
				       'value' => $firstemail };
			&postfix::create_mapping($canonical_type, $gen);
			}
		&unlock_file($canonical_map_files[0]);
		}
	elsif ($config{'mail_system'} == 2) {
		# is this even possible for qmail?
		}

	}
}

# delete_user(&user, domain)
# Delete a mailbox user and all associated virtusers and aliases
sub delete_user
{
$_[0]->{'user'} eq 'root' && &error("Cannot delete root user!");
$_[0]->{'uid'} == 0 && &error("Cannot delete UID 0 user!");
&require_useradmin();
&require_mail();

# Delete the user
&useradmin::set_user_envs($_[0], 'DELETE_USER')
&useradmin::making_changes();
&useradmin::lock_user_files();
&useradmin::delete_user($_[0]);
&useradmin::unlock_user_files();
&useradmin::made_changes();

# Delete any virtusers
&delete_virtuser($_[0]->{'virt'}) if ($_[0]->{'virt'});
local $e;
foreach $e (@{$_[0]->{'extravirt'}}) {
	&delete_virtuser($e);
	}

# Delete his alias, if any
if ($_[0]->{'alias'}) {
	if ($config{'mail_system'} == 1) {
		&lock_file($_[0]->{'alias'}->{'file'});
		&sendmail::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		}
	elsif ($config{'mail_system'} == 0) {
		&lock_file($_[0]->{'alias'}->{'file'});
		&postfix::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		&postfix::regenerate_aliases();
		}
	}

if ($config{'generics'} && $_[0]->{'generic'}) {
	# Delete genericstable entry too
	if ($config{'mail_system'} == 1) {
		&lock_file($sendmail_gfile);
		&sendmail::delete_generic($_[0]->{'generic'}, $sendmail_gfile,
				$sendmail_gdbm, $sendmail_gdbmtype);
		&unlock_file($sendmail_gfile);
		}
	elsif ($config{'mail_system'} == 0) {
		&lock_file($_[0]->{'generic'}->{'file'});
		&postfix::delete_mapping($canonical_type, $_[0]->{'generic'});
		&unlock_file($_[0]->{'generic'}->{'file'});
		}
	}
}

# domain_title(&domain)
sub domain_title
{
print "<center><font size=+1>",&text('indom', "<tt>$_[0]->{'dom'}</tt>"),
      "</font></center>\n";
}

# copy_skel_files(basedir, &user, [group])
# Copy files to the home directory of some new user
sub copy_skel_files
{
local $uf = $_[0];
return if (!$uf);
&require_useradmin();
local $shell = $_[1]->{'shell'};
$shell =~ s/^(.*)\///g;
local $group = $_[2];
$group = getgrgid($_[1]->{'gid'}) if (!$group);
$uf =~ s/\$group/$group/g;
$uf =~ s/\$gid/$_[1]->{'gid'}/g;
$uf =~ s/\$shell/$shell/g;
&useradmin::copy_skel_files($uf, $_[1]->{'home'},
			    $_[1]->{'uid'}, $_[1]->{'gid'});
}

# can_edit_domain(&domain)
# Returns 1 if the current user can edit some domain
sub can_edit_domain
{
return 1 if ($access{'domains'} eq "*");
local $d;
foreach $d (split(/\s+/, $access{'domains'})) {
	return 1 if ($d eq $_[0]->{'id'});
	}
return 0;
}

# domains_table(&domains)
# Display a list of domains in a table, with links for editing
sub domains_table
{
local @table_features = $config{'show_features'} ?
    (grep { $_ ne 'webmin' && $_ ne 'mail' && $_ ne 'unix' } @features) : ( );
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_domain'}</b></td> ",
      "<td><b>$text{'index_user'}</b></td> ",
      "<td><b>$text{'index_owner'}</b></td> ";
local $f;
foreach $f (@table_features) {
	print "<td><b>",$text{'index_'.$f},"</b></td> " if ($config{$f});
	}
if ($config{'mail'}) {
	print "<td><b>$text{'index_mail'}</b></td> ";
	print "<td><b>$text{'index_alias'}</b></td> ";
	}
if ($config{'home_quotas'}) {
	print "<td><b>$text{'index_quota'}</b></td> ".
	      "<td><b>$text{'index_uquota'}</b></td> ";
	}
print "</tr>\n";
local $d;
foreach $d (sort { $a->{'dom'} cmp $b->{'dom'} } @{$_[0]}) {
	print "<tr $cb>\n";
	local $dn = $d->{'disabled'} ? "<i>$d->{'dom'}</i>" : $d->{'dom'};
	if ($access{'edit'}) {
		print "<td><a href='edit_domain.cgi?dom=$d->{'id'}'>",
		      "$dn</a></td>\n";
		}
	else {
		print "<td>$dn</td>\n";
		}
	print "<td>$d->{'user'}</td>\n";
	print "<td>$d->{'owner'}</td>\n";
	foreach $f (@table_features) {
		print "<td>",$d->{$f} ? $text{'yes'} : $text{'no'},"</td>\n"
			if ($config{$f});
		}
	local @users = &list_domain_users($d);
	local ($duser) = grep { $_->{'user'} eq $d->{'user'} } @users;
	if ($config{'mail'}) {
		if ($d->{'mail'}) {
			local @aliases = &list_domain_aliases($d);
			printf "<td>%d%s&nbsp;(<a href='list_users.cgi?dom=$d->{'id'}'>$text{'index_list'}</a>)</td>\n", scalar(@users), $d->{'mailboxlimit'} ? " of $d->{'mailboxlimit'}" : "";
			printf "<td>%d&nbsp;(<a href='list_aliases.cgi?dom=$d->{'id'}'>$text{'index_list'}</a>)</td>\n", scalar(@aliases);
			}
		else {
			print "<td colspan=2>$text{'index_nomail'}</td>\n";
			}
		}
	if ($config{'home_quotas'}) {
		print "<td>",$d->{'quota'} ?
			&quota_show($d->{'quota'}, $config{'home_quotas'}) :
			$text{'form_unlimit'},"</td>\n";
		local $ut = $duser->{'uquota'} + $duser->{'umquota'};
		foreach $u (@users) {
			$ut += $u->{'uquota'} + $u->{'umquota'}
				if ($u->{'user'} ne $d->{'user'});
			}
		print "<td>",&quota_show($ut, $config{'home_quotas'}),"</td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
}

# userdom_name(name, &domain)
# Returns a username with the domain group appended somehow
sub userdom_name
{
if ($config{'append_style'} == 0) {
	return $_[0].".".$_[1]->{'group'};
	}
elsif ($config{'append_style'} == 1) {
	return $_[0]."-".$_[1]->{'group'};
	}
elsif ($config{'append_style'} == 2) {
	return $_[1]->{'group'}.".".$_[0];
	}
elsif ($config{'append_style'} == 3) {
	return $_[1]->{'group'}."-".$_[0];
	}
elsif ($config{'append_style'} == 4) {
	return $_[0]."_".$_[1]->{'group'};
	}
elsif ($config{'append_style'} == 5) {
	return $_[1]->{'group'}."_".$_[0];
	}
else {
	&error("Unknown append_style $config{'append_style'}!");
	}
}

# remove_userdom(name, &domain)
# Returns a username with the domain group stripped off
sub remove_userdom
{
local $g = $_[1]->{'group'};
local $rv = $_[0];
($rv =~ s/(\.|\-|_)\Q$g\E$//) || ($rv =~ s/^\Q$g\E(\.|\-|_)//);
return $rv;
}

# too_long(name)
# Returns an error message if a username is too long for this Unix variant
sub too_long
{
&require_useradmin();
if ($uconfig{'max_length'} && length($_[0]) > $uconfig{'max_length'}) {
	return &text('user_elong', "<tt>$_[0]</tt>", $uconfig{'max_length'});
	}
else {
	return undef;
	}
}

# get_default_ip()
# Returns this system's primary IP address
sub get_default_ip
{
if ($config{'defip'}) {
	return $config{'defip'};
	}
else {
	&foreign_require("net", "net-lib.pl");
	local ($iface) = grep { $_->{'fullname'} eq $config{'iface'} }
			      &net::active_interfaces();
	return $iface->{'address'};
	}
}

# check_apache_directives()
# Returns an error string if the default Apache directives don't look valid
sub check_apache_directives
{
local ($d, $gotname, $gotdom, $gotdoc, $gotproxy);
local @dirs = split(/\t+/, $config{'apache_config'});
foreach $d (@dirs) {
	$d =~ s/#.*$//;
	if ($d =~ /^\s*ServerName\s+(\S+)$/i) {
		$gotname++;
		$gotdom++ if ($1 eq '$DOM' || $1 eq '${DOM}');
		}
	if ($d =~ /^\s*ServerAlias\s+(.*)$/) {
		$gotdom++ if (&indexof('$DOM', split(/\s+/, $1)) >= 0 ||
			      &indexof('${DOM}', split(/\s+/, $1)) >= 0);
		}
	$gotdoc++ if ($d =~ /^\s*DocumentRoot\s+(.*)$/);
	$gotproxy++ if ($d =~ /^\s*ProxyPass\s+(.*)$/);
	}
$gotname || return $text{'acheck_ename'};
$gotdom || return $text{'acheck_edom'};
$gotdoc || $gotproxy || return $text{'acheck_edoc'};
return undef;
}

# Print functions for HTML output
sub first_html_print { print @_,"<br>\n"; }
sub second_html_print { print @_,"<p>\n"; }
sub indent_html_print { print "<ul>\n"; }
sub outdent_html_print { print "</ul>\n"; }

# Print functions for text output
sub first_text_print { print $indent_text,@_,"\n"; }
sub second_text_print { print $indent_text,@_,"\n\n"; }
sub indent_text_print { $indent_text .= "    "; }
sub outdent_text_print { $indent_text = substr($indent_text, 4); }

sub null_print { }

# send_domain_email(&domain)
# Sends email to a new domain owner. Returns a pair containing a number
# (0=failed, 1=success) and an optional message. Also outputs status messages.
sub send_domain_email
{
&ensure_template("domain-template");
return (1, undef) if ($config{'domain_template'} eq 'none');
&$first_print($text{'setup_email'});
local $tmpl = $config{'domain_template'} eq 'default' ?
	"$module_config_directory/domain-template" : $config{'domain_template'};
local @erv = &send_template_email($tmpl,
				  $_[0]->{'email'} ||
				    $_[0]->{'user'}.'@'.&get_system_hostname(),
			    	  $_[0], $text{'mail_dsubject'});
if ($erv[0]) {
	&$second_print(&text('setup_emailok', $erv[1]));
	}
else {
	&$second_print(&text('setup_emailfailed', $erv[1]));
	}
}

# send_user_email([&domain], &user)
# Sends email to a new mailbox user. Returns a pair containing a number
# (0=failed, 1=success) and an optional message
sub send_user_email
{
local $tmode = $_[0] ? "user" : "local";
&ensure_template($tmode."-template");
return (1, undef) if ($config{$tmode.'_template'} eq 'none');
local $tmpl = $config{$tmode.'_template'} eq 'default' ?
	"$module_config_directory/$tmode-template" :
	$config{$tmode.'_template'};
local %hash;
local $email;
if ($_[0]) {
	%hash = ( %{$_[0]}, %{$_[1]} );
	$hash{'mailbox'} = &remove_userdom($_[1]->{'user'}, $_[0]);
	$email = $hash{'mailbox'}.'@'.$hash{'dom'};
	}
else {
	%hash = ( %{$_[1]} );
	$hash{'mailbox'} = $hash{'user'};
	$email = $hash{'user'}.'@'.&get_system_hostname();
	}
$hash{'ftp'} = $_[1]->{'shell'} eq $config{'ftp_shell'} ? 1 : 0;
return &send_template_email($tmpl, $email, \%hash, $text{'mail_usubject'});
}

# ensure_template(file)
sub ensure_template
{
&system_logged("cp $module_root_directory/$_[0] $module_config_directory/$_[0]")
	if (!-r "$module_config_directory/$_[0]");
}

# send_template_email(file, address, &substitions, subject)
# Sends the given file to the specified address, with the substitions from
# a hash reference. The actual subs in the file must be like $XXX for entries
# in the hash like xxx - ie. $DOM is replaced by the domain name, and $HOME
# by the home directory
sub send_template_email
{
# Read the file
local $tmpl;
open(FILE, $_[0]) || return (0, &text('mail_file', "<tt>$_[0]</tt>", $!));
while(<FILE>) {
	$tmpl .= $_;
	}
close(FILE);
$tmpl = &substitute_template($tmpl, $_[2]);

# Actually send using the mailboxes module
return (0, $text{'mail_system'})
	if (!$config{'mail'} || $config{'mail_system'} == 3);
&require_mail();
&foreign_require("mailboxes", "mailboxes-lib.pl");
local $mail = { 'headers' => [ [ 'From', $config{'from_addr'} ||
					 &mailboxes::get_from_address() ],
			       [ 'To', $_[1] ],
			       [ 'Subject', $_[3] ],
			       [ 'Content-type', 'text/plain' ] ],
		'body' => $tmpl };
&mailboxes::send_mail($mail);
return (1, &text('mail_ok', $_[1]));
}

# substitute_template(text, &hash)
# Given some text and a hash reference, for each ocurrance of $FOO or ${FOO} in
# the text replaces it with the value of the hash key foo
sub substitute_template
{
# Add some extra fixed parameters to the hash
local %hash = %{$_[1]};
$hash{'hostname'} = &get_system_hostname();

# Actually do the substition
local $rv = $_[0];
local $s;
foreach $s (keys %hash) {
	local $us = uc($s);
	local $sv = $hash{$s};
	$rv =~ s/\$\{\Q$us\E\}/$sv/g;
	$rv =~ s/\$\Q$us\E/$sv/g;
	if ($sv) {
		$rv =~ s/\$\{IF-\Q$us\E\}(\n?)([\000-\377]*)\$\{ELSE-\Q$us\E\}(\n?)([\000-\377]*)\$\{ENDIF-\Q$us\E\}(\n?)/\2/g;
		$rv =~ s/\$\{IF-\Q$us\E\}(\n?)([\000-\377]*)\$\{ENDIF-\Q$us\E\}(\n?)/\2/g;

		$rv =~ s/\$IF-\Q$us\E(\n?)([\000-\377]*)\$ELSE-\Q$us\E(\n?)([\000-\377]*)\$ENDIF-\Q$us\E(\n?)/\2/g;
		$rv =~ s/\$IF-\Q$us\E(\n?)([\000-\377]*)\$ENDIF-\Q$us\E(\n?)/\2/g;
		}
	else {
		$rv =~ s/\$\{IF-\Q$us\E\}(\n?)([\000-\377]*)\$\{ELSE-\Q$us\E\}(\n?)([\000-\377]*)\$\{ENDIF-\Q$us\E\}(\n?)/\4/g;
		$rv =~ s/\$\{IF-\Q$us\E\}(\n?)([\000-\377]*)\$\{ENDIF-\Q$us\E\}(\n?)//g;

		$rv =~ s/\$IF-\Q$us\E(\n?)([\000-\377]*)\$ELSE-\Q$us\E(\n?)([\000-\377]*)\$ENDIF-\Q$us\E(\n?)/\4/g;
		$rv =~ s/\$IF-\Q$us\E(\n?)([\000-\377]*)\$ENDIF-\Q$us\E(\n?)//g;
		}
	}
return $rv;
}

# alias_type(string)
# Return the type and destination of some alias string
sub alias_type
{
local @rv;
if ($_[0] =~ /^\|$module_config_directory\/autoreply.pl\s+(\S+)/) {
        @rv = (5, $1);
        }
elsif ($_[0] =~ /^\|$module_config_directory\/filter.pl\s+(\S+)/) {
        @rv = (6, $1);
        }
elsif ($_[0] =~ /^\|(.*)$/) {
        @rv = (4, $1);
        }
elsif ($_[0] =~ /^(\/.*)$/) {
        @rv = (3, $1);
        }
elsif ($_[0] =~ /^:include:(.*)$/) {
        @rv = (2, $1);
        }
elsif ($_[0] =~ /^\\(\S+)$/) {
        @rv = (7, $1);
        }
elsif ($_[0] =~ /^\%1\@(\S+)$/) {
        @rv = (8, $1);
        }
else {
        @rv = (1, $_[0]);
        }
return wantarray ? @rv : $rv[0];
}

# set_domain_envs(&domain, action)
# Sets up VIRTUALSERVER_ environment variables for a domain update or some kind,
# prior to calling making_changes or made_changes. action must be one of
# CREATE_DOMAIN, MODIFY_DOMAIN or DELETE_DOMAIN
sub set_domain_envs
{
local $e;
foreach $e (keys %ENVS) {
	delete($ENV{$e}) if ($e =~ /^VIRTUALSERVER_/);
	}
$ENV{'VIRTUALSERVER_ACTION'} = $_[1];
foreach $e (keys %{$_[0]}) {
	$ENV{'VIRTUALSERVER_'.uc($e)} = $_[0]->{$e};
	}
}

# making_changes()
# Called before a domain is created, modified or deleted to run the
# pre-change command
sub making_changes
{
if ($config{'pre_command'} =~ /\S/) {
	&clean_changes_environment();
	local $out = &backquote_logged("($config{'pre_command'}) 2>&1 </dev/null");
	&reset_changes_environment();
	return $? ? $out : undef;
	}
return undef;
}

# made_changes()
# Called after a domain has been created, modified or deleted to run the
# post-change command
sub made_changes
{
if ($config{'post_command'} =~ /\S/) {
	&clean_changes_environment();
	local $out = &backquote_logged("($config{'post_command'}) 2>&1 </dev/null");
	&reset_changes_environment();
	return $? ? $out : undef;
	}
return undef;
}

sub reset_changes_environment
{
%ENV = %UNCLEAN_ENV;
}

sub clean_changes_environment
{
local $e;
%UNCLEAN_ENV = %ENV;
foreach $e ('SERVER_ROOT', 'SCRIPT_NAME',
	    'FOREIGN_MODULE_NAME', 'FOREIGN_ROOT_DIRECTORY',
	    'SCRIPT_FILENAME') {
	delete($ENV{$e});
	}
}

# switch_to_domain_user(&domain)
# Changes the current UID and GID to that of the domain's unix user
sub switch_to_domain_user
{
($(, $)) = ( $_[0]->{'ugid'},
	     "$_[0]->{'ugid'} ".join(" ", $_[0]->{'ugid'},
					 &other_groups($_[0]->{'user'})) );
($<, $>) = ( $_[0]->{'uid'}, $_[0]->{'uid'} );
$ENV{'USER'} = $ENV{'LOGNAME'} = $_[0]->{'user'};
$ENV{'HOME'} = $_[0]->{'home'};
}

# print_subs_table(sub, ..)
sub print_subs_table
{
print "<table>\n";
foreach $k (@_) {
	print "<tr> <td><tt><b>\${$k}</b></td>\n";
	print "<td>",$text{"sub_".$k},"</td> </tr>\n";
	}
print "</table>\n";
print "$text{'sub_if'}<p>\n";
}

# alias_form(&to, left, &domain, "user"|"alias", user|alias)
sub alias_form
{
local @typenames = map { $text{"alias_type$_"} }
		       (0 .. ($_[3] eq "user" ? 7 : 8));
$typenames[0] = "&lt;$typenames[0]&gt;";

local $left = $_[1];
local @values = @{$_[0]};
local $i;
for($i=0; $i<=@values+2; $i++) {
	print "<tr> <td>$left</td> <td>\n";
	$left = "";
	local ($type, $val) = $values[$i] ? &alias_type($values[$i]) : (0, "");
	print "<select name=type_$i>\n";
	local $j;
	for($j=0; $j<@typenames; $j++) {
		if (!$j || $can_alias_types{$j} ||
		    $type == $j) {
			printf "<option value=$j %s>$typenames[$j]\n",
				$type == $j ? "selected" : "";
			}
		}
	print "</select>\n";
	print "<input name=val_$i size=30 value=\"$val\">\n";
	if ($config{'edit_afiles'} || $master_admin) {
		local $prog = $type == 2 ? "edit_afile.cgi" :
			      $type == 5 ? "edit_rfile.cgi" :
			      $type == 6 ? "edit_ffile.cgi" : undef;
		if ($prog && $_[2]) {
			local $di = $_[2] ? $_[2]->{'id'} : undef;
			print "<a href='$prog?dom=$di&file=$val&$_[3]=$_[4]'>$text{'alias_afile'}</a>\n";
			}
		}
	print "</td> </tr>\n";
	}
}

# parse_alias(catchall)
# Returns a list of values for an alias, taken from the form generated by
# &alias_form
sub parse_alias
{
local (@values, $i, $t, $anysame);
for($i=0; defined($t = $in{"type_$i"}); $i++) {
	!$t || $can_alias_types{$t} ||
		&error($text{'alias_etype'});
	local $v = $in{"val_$i"};
	$v =~ s/^\s+//;
	$v =~ s/\s+$//;
	if ($t == 1 && $v !~ /^(\S+)$/) {
		&error(&text('alias_etype1', $v));
		}
	elsif ($t == 3 && $v !~ /^\/(\S+)$/) {
		&error(&text('alias_etype3', $v));
		}
	elsif ($t == 4) {
		$v =~ /^(\S+)/ || &error($text{'alias_etype4none'});
		(-x $1) && &check_aliasfile($1, 0) ||
			&error(&text('alias_etype4', $1));
		}
	elsif ($t == 7 && !defined(getpwnam($v))) {
		&error(&text('alias_etype7', $v));
		}
	elsif ($t == 8 && $v !~ /^[a-z0-9\.\-\_]+$/) {
		&error(&text('alias_etype8', $v));
		}
	elsif ($t == 8 && !$_[0]) {
		&error(&text('alias_ecatchall', $v));
		}
	if ($t == 1 || $t == 3) { push(@values, $v); }
	elsif ($t == 2) {
		$v = "$d->{'home'}/$v" if ($v !~ /^\//);
		push(@values, ":include:$v");
		}
	elsif ($t == 4) {
		$v = "$d->{'home'}/$v" if ($v !~ /^\//);
		push(@values, "|$v");
		}
	elsif ($t == 5) {
		# Setup autoreply script
		$v = "$d->{'home'}/$v" if ($v !~ /^\//);
		push(@values, "|$module_config_directory/autoreply.pl ".
			      "$v $name");
		&system_logged("cp autoreply.pl $module_config_directory");
		&system_logged("chmod 755 $module_config_directory/config");
		if (-d $sendmail::config{'smrsh_dir'}) {
			&system_logged("ln -s $module_config_directory/autoreply.pl $sendmail::config{'smrsh_dir'}/autoreply.pl");
			}
		}
	elsif ($t == 6) {
		# Setup filter script
		$v = "$d->{'home'}/$v" if ($v !~ /^\//);
		push(@values, "|$module_config_directory/filter.pl ".
			      "$v $name");
		&system_logged("cp filter.pl $module_config_directory");
		&system_logged("chmod 755 $module_config_directory/config");
		if (-d $sendmail::config{'smrsh_dir'}) {
			&system_logged("ln -s $module_config_directory/filter.pl $sendmail::config{'smrsh_dir'}/filter.pl");
			}
		}
	elsif ($t == 7) {
		push(@values, "\\$v");
		}
	elsif ($t == 8) {
		push(@values, "\%1\@$v");
		$anysame++;
		}
	}
if (@values > 1 && $anysame) {
	&error(&text('alias_ecatchall2', $v));
	}
return @values;
}

# set_pass_change(&user)
sub set_pass_change
{
&require_useradmin();
local $pft = &useradmin::passfiles_type();
if ($pft == 2 || $pft == 5) {
	$_[0]->{'change'} = int(time() / (60*60*24));
	}
elsif ($pft == 4) {
	$_[0]->{'change'} = time();
	}
}

# build_taken(&uid-taken, &username-taken, [&users])
# Fills in the the given hashes with used usernames and UIDs
sub build_taken
{
&require_useradmin();
local @users = $_[2] ? @{$_[2]} : &useradmin::list_users();
%{$_[0]} = map { $_->{'uid'}, 1 } @users;
%{$_[1]} = map { $_->{'user'}, 1 } @users;
}

# build_group_taken(&gid-taken, &groupname-taken, [&groups])
# Fills in the the given hashes with used group names and GIDs
sub build_group_taken
{
&require_useradmin();
local @groups = $_[2] ? @{$_[2]} : &useradmin::list_groups();
%{$_[0]} = map { $_->{'gid'}, 1 } @groups;
%{$_[1]} = map { $_->{'group'}, 1 } @groups;
}

# allocate_uid(&uid-taken)
sub allocate_uid
{
local $uid = $uconfig{'base_uid'};
while($_[0]->{$uid}) {
	$uid++;
	}
return $uid;
}

# allocate_gid(&gid-taken)
sub allocate_gid
{
local $gid = $uconfig{'base_gid'};
while($_[0]->{$gid}) {
	$gid++;
	}
return $gid;
}

# server_home_directory(&domain)
# Returns the home directory for a new virtual server user
sub server_home_directory
{
if ($config{'home_format'}) {
	# Use the template from the module config
	local $home = "$home_base/$config{'home_format'}";
	return &substitute_template($home, $_[0]);
	}
else {
	# Just use the Users and Groups module settings
	return &useradmin::auto_home_dir($home_base, $_[0]->{'user'},
						     $_[0]->{'ugroup'});
	}
}

# set_quota(user, filesystem, quota)
sub set_quota
{
&require_useradmin();
if ($config{'hard_quotas'}) {
	&quota::edit_user_quota($_[0], $_[1],
				int($_[2]), int($_[2]), 0, 0);
	}
else {
	&quota::edit_user_quota($_[0], $_[1],
				int($_[2]), 0, 0, 0);
	}
}

# set_server_quotas(&domain)
# Set the user and possibly group quotas for a domain
sub set_server_quotas
{
if ($config{'home_quotas'}) {
	&set_quota($_[0]->{'user'}, $config{'home_quotas'}, $_[0]->{'uquota'});
	}
if ($config{'mail_quotas'} &&
    $config{'mail_quotas'} ne $config{'home_quotas'}) {
	&set_quota($_[0]->{'user'}, $config{'mail_quotas'}, $_[0]->{'uquota'});
	}
if ($config{'group_quotas'}) {
	&require_useradmin();
	if ($config{'hard_quotas'}) {
		&quota::edit_group_quota(
			$_[0]->{'group'}, $config{'home_quotas'},
			int($_[0]->{'quota'}), int($_[0]->{'quota'}), 0, 0);
		}
	else {
		&quota::edit_group_quota(
			$_[0]->{'group'}, $config{'home_quotas'},
			int($_[0]->{'quota'}), 0, 0, 0);
		}
	}
}

# nice_size(bytes)
sub nice_size
{
return $_[0] > 10*1024*1024 ? int($_[0]/1024/1024)." MB" :
       $_[0] > 10*1024 ? int($_[0]/1024)." kB" : $_[0]." b";
}

# users_table(&users, &dom)
# Output a table of mailbox users
sub users_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'users_name'}</b></td> ",
      "<td><b>$text{'users_pop3'}</b></td> ",
      "<td><b>$text{'users_real'}</b></td> ",
      $config{'home_quotas'} || $config{'mail_quotas'} ?
	  "<td><b>$text{'users_quota'}</b></td> " : "",
      "<td><b>$text{'users_size'}</b></td> ",
      "<td><b>$text{'users_ftp'}</b></td> </tr>\n";
local $u;
local $did = $_[1] ? $_[1]->{'id'} : 0;
foreach $u (@{$_[0]}) {
	local $pop3 = $_[1] ? &remove_userdom($u->{'user'}, $_[1])
			    : $u->{'user'};
	local $domuser = $_[1] && $u->{'user'} eq $_[1]->{'user'};
	print "<tr $cb>\n";
	print "<td><a href='edit_user.cgi?dom=$did&",
	      "user=$u->{'user'}'>",
	      ($domuser ? "<b>$pop3</b>" : $pop3),"</a></td>\n";
	print "<td>$u->{'user'}</td>\n";
	print "<td>$u->{'real'}</td>\n";
	local $quota;
	$quota += $u->{'quota'} if ($config{'home_quotas'});
	$quota += $u->{'mquota'} if ($config{'mail_quotas'} &&
		      $config{'home_quotas'} ne $config{'mail_quotas'});
	if (defined($quota)) {
		print "<td>",$quota ? &quota_show($quota,$config{'home_quotas'})
				    : $text{'form_unlimit'},"</td>\n";
		}
	local ($sz) = &mail_file_size($u);
	$sz = $sz ? &nice_size($sz) : $text{'users_empty'};
	local $lnk = &read_mail_link($u);
	if ($lnk) {
		print "<td><a href='$lnk'>$sz</a></td>\n";
		}
	else {
		print "<td>$sz</td>\n";
		}
	printf "<td>%s</td>\n",
		$domuser ? $text{'users_main'} :
		$u->{'shell'} eq $config{'ftp_shell'} ? $text{'yes'} :
		$u->{'shell'} eq $config{'shell'} ? $text{'no'} :
			&text('users_shell', "<tt>$u->{'shell'}</tt>");
	print "</tr>\n";
	}
print "</table>\n";
}

# quota_bsize(filesystem)
sub quota_bsize
{
&require_useradmin();
if (defined(&quota::block_size)) {
	local $bsize;
	if (!exists($bsize_cache{$_[0]})) {
		$bsize_cache{$_[0]} = &quota::block_size($_[0]);
		}
	return $bsize_cache{$_[0]};
	}
return undef;
}

# quota_show(number, filesystem)
# Returns text for the quota on some filesystem, in a human-readable format
sub quota_show
{
local $bsize = &quota_bsize($_[1]);
if ($bsize) {
	return int($_[0]*$bsize/1024)." ".$text{'form_k'};
	}
return $_[0]." ".$text{'form_b'};
}

# quota_input(name, number, filesystem)
# Returns HTML for an input for entering a quota, doing block->kb conversion
sub quota_input
{
local $bsize = &quota_bsize($_[2]);
return sprintf "<input name=%s size=10 value='%s'> %s",
	$_[0], $_[1] eq '' ? '' : $bsize ? int($_[1]*$bsize/1024) : $_[1],
	$bsize ? $text{'form_k'} : $text{'form_b'};
}

# quota_parse(name, filesystem)
# Converts an entered quota into blocks
sub quota_parse
{
local $bsize = &quota_bsize($_[1]);
return $bsize ? int($in{$_[0]}*1024/$bsize) : $in{$_[0]};
}

# setup_virt(&domain)
# Bring up an interface for a domain, if the IP isn't already enabled
sub setup_virt
{
&foreign_require("net", "net-lib.pl");
local @boot = &net::active_interfaces();
&$first_print($text{'setup_virt'});
local ($iface) = grep { $_->{'fullname'} eq $config{'iface'} } @boot;
local $b;
local $vmax = int($net::min_virtual_number);
foreach $b (@boot) {
	$vmax = $b->{'virtual'}
		if ($b->{'name'} eq $iface->{'name'} &&
		    $b->{'virtual'} > $vmax);
	}
local $virt = { 'address' => $_[0]->{'ip'},
		'netmask' => $net::virtual_netmask || $iface->{'netmask'},
		'broadcast' =>
			$net::virtual_netmask eq "255.255.255.255" ?
				$_[0]->{'ip'} : $iface->{'broadcast'},
		'name' => $iface->{'name'},
		'virtual' => $vmax+1,
		'up' => 1 };
$virt->{'fullname'} = $virt->{'name'}.":".$virt->{'virtual'};
&net::save_interface($virt);
&net::activate_interface($virt);
$_[0]->{'iface'} = $virt->{'fullname'};
&$second_print(&text('setup_virtdone', $_[0]->{'iface'}));
}

# delete_virt(&domain)
# Take down the network interface for a domain
sub delete_virt
{
&$first_print($text{'delete_virt'});
&foreign_require("net", "net-lib.pl");
local ($biface) = grep { $_->{'fullname'} eq $_[0]->{'iface'} }
	 	       &net::boot_interfaces();
local ($aiface) = grep { $_->{'fullname'} eq $_[0]->{'iface'} }
	 	       &net::active_interfaces();
if ($biface->{'virtual'} ne '') {
	&net::delete_interface($biface);
	&net::deactivate_interface($aiface) if($aiface);
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print(&text('delete_novirt', $d->{'iface'}));
	}
}

# check_virt_clash(ip)
# Returns the interface if some IP is already in use
sub check_virt_clash
{
&foreign_require("net", "net-lib.pl");
local @boot = &net::boot_interfaces();
local ($boot) = grep { $_->{'address'} eq $_[0] } @boot;
local @active = &net::active_interfaces();
local ($active) = grep { $_->{'address'} eq $_[0] } @active;
return $active || $boot;
}

# backup_domains(file, &domains, &features, dir-format, skip-errors, &options)
# Perform a backup of one or more domains into a single tar.gz file. Returns
# undef on success, or an error message.
sub backup_domains
{
# Create a temp dir for the backup, to be tarred up later
local $backupdir = &tempname();
mkdir($backupdir, 0700);

# Go through all the domains, and for each feature call the backup function
# to add it to the backup directory
local $d;
local $ok = 1;
local @donedoms;
DOMAIN: foreach $d (@{$_[1]}) {
	&$first_print(&text('backup_fordomain', $d->{'dom'}));
	&$second_print();
	&$indent_print();
	local $f;
	foreach $f (@{$_[2]}) {
		local $bfunc = "backup_$f";
		if (defined(&$bfunc) &&
		    ($d->{$f} || $f eq "virtualmin")) {
			local $ffile = "$backupdir/$d->{'dom'}_$f";
			local $fok = &$bfunc($d, $ffile, $_[5]->{$f});
			if (!$fok && !$_[4]) {
				$ok = 0;
				last DOMAIN;
				}
			push(@donedoms, $d);
			}
		}
	&$outdent_print();
	}

# Work out where to write the final tar files to
local ($mode, $user, $pass, $server, $path) = &parse_backup_url($_[0]);
local ($dest, @destfiles);
if ($mode >= 1) {
	# Write archive to temporary file/dir first, for later upload
	$dest = &tempname();
	}
else {
	$dest = $path;
	}

if ($ok) {
	local $out;
	if ($_[3]) {
		# Create one tar file in the destination for each domain
		&$first_print($text{'backup_final2'});
		mkdir($dest, 0755);
		foreach $d (&unique(@donedoms)) {
			if (&has_command("gzip")) {
				$out = `cd $backupdir ; (tar cf - $d->{'dom'}_* | gzip -c) 2>&1 >$dest/$d->{'dom'}.tar.gz`;
				push(@destfiles, "$d->{'dom'}.tar.gz");
				}
			else {
				$out = `cd $backupdir ; tar cf $dest/$d->{'dom'}.tar $d->{'dom'}_* 2>&1`;
				push(@destfiles, "$d->{'dom'}.tar");
				}
			if ($?) {
				&$second_print(&text('backup_finalfailed', "<pre>$out</pre>"));
				$ok = 0;
				last;
				}
			}
		&$second_print($text{'setup_done'}) if ($ok);
		}
	else {
		# Tar up the directory into the final file
		&$first_print($text{'backup_final'});
		if (&has_command("gzip")) {
			$out = `cd $backupdir ; (tar cf - . | gzip -c) 2>&1 >$dest`;
			}
		else {
			$out = `cd $backupdir ; tar cf $dest . 2>&1`;
			}
		if ($?) {
			&$second_print(&text('backup_finalfailed', "<pre>$out</pre>"));
			$ok = 0;
			}
		else {
			&$second_print($text{'setup_done'});
			}
		}
	}

system("rm -rf ".quotemeta($backupdir));
local $sz = $_[3] ? &disk_usage_kb($dest)*1024
		  : (@st=stat($dest))[7];

if ($ok && $mode == 1) {
	# Upload file(s) to FTP server
	&$first_print($text{'backup_upload'});
	local $err;
	if ($_[3]) {
		# Need to upload entire directory .. which has to be created
		local $mkdirerr;
		&ftp_onecommand($server, "MKD $path", \$mkdirerr, $user, $pass);
		foreach $df (@destfiles) {
			&ftp_upload($server, "$path/$df", "$dest/$df", \$err,
				    undef, $user, $pass);
			if ($err) {
				&$second_print(
					&text('backup_uploadfailed', $err));
				$ok = 0;
				last;
				}
			}
		}
	else {
		# Just a single file
		&ftp_upload($server, $path, $dest, \$err, undef, $user, $pass);
		if ($err) {
			&$second_print(&text('backup_uploadfailed', $err));
			$ok = 0;
			}
		}
	&$second_print($text{'setup_done'}) if ($ok);
	}
elsif ($ok && $mode == 2) {
	# Upload to SSH server with scp
	&$first_print($text{'backup_upload2'});
	local $err;
	local $r = ($user ? "$user\@" : "")."$server:$path";
	if ($_[3]) {
		# Need to upload entire directory
		&scp_copy("$dest/*", $r, $pass, \$err);
		if ($err) {
			$err = undef;
			&scp_copy($dest, $r, $pass, \$err);
			}
		}
	else {
		# Just a single file
		&scp_copy($dest, $r, $pass, \$err);
		}
	if ($err) {
		&$second_print(&text('backup_uploadfailed', $err));
		$ok = 0;
		}
	&$second_print($text{'setup_done'}) if ($ok);
	}

if ($mode >= 1) {
	# Always delete the temporary destination
	system("rm -rf ".quotemeta($dest));
	}

return ($ok, $sz);
}

# backup_virtualmin(&domain, file)
# Adds a domain's configuration file to the backup
sub backup_virtualmin
{
&$first_print($text{'backup_virtualmincp'});
system("cp ".quotemeta($_[0]->{'file'})." ".$_[1]);
&$second_print($text{'setup_done'});
return 1;
}

# restore_domains(file, &domains, &features, &options)
# Restore multiple domains from the given file
sub restore_domains
{
# Work out where the backup is located
local $ok = 1;
local $backup;
local ($mode, $user, $pass, $server, $path) = &parse_backup_url($_[0]);
if ($mode > 0) {
	# Need to download to temp file/directory first
	&$first_print($text{'restore_download'});
	$backup = &tempname();
	local $derr = &download_backup($_[0], $backup);
	if ($derr) {
		&$second_print(&text('restore_downloadfailed', $derr));
		$ok = 0;
		}
	else {
		&$second_print($text{'setup_done'});
		}
	}
else {
	$backup = $_[0];
	}

local $restoredir;
if ($ok) {
	# Create a temp dir for the backup archive contents
	$restoredir = &tempname();
	mkdir($restoredir, 0700);

	local @files;
	if (-d $backup) {
		# Extracting a directory of backup files
		&$first_print($text{'restore_first2'});
		opendir(DIR, $backup);
		@files = map { "$backup/$_" }
			     grep { $_ ne "." && $_ ne ".." } readdir(DIR);
		closedir(DIR);
		}
	else {
		# Extracting one backup file
		&$first_print($text{'restore_first'});
		@files = ( $backup );
		}

	# Extract each of the files
	local $f;
	foreach $f (@files) {
		open(BACKUP, $f);
		local $two;
		read(BACKUP, $two, 2);
		close(BACKUP);
		local $out;
		local $q = quotemeta($f);
		if ($two eq "\037\213") {
			# Assume gzipped tar
			$out = `cd '$restoredir' ; (gunzip -c $q | tar xf -) 2>&1`;
			}
		else {
			# Assume normal tar
			$out = `cd '$restoredir' ; tar xf $q 2>&1`;
			}
		if ($?) {
			&$second_print(&text('restore_firstfailed', "<tt>$f</tt>", "<pre>$out</pre>"));
			$ok = 0;
			last;
			}
		}
	&$second_print($text{'setup_done'}) if ($ok);
	}

if ($ok) {
	# Now restore each of the domain/feature files
	local $d;
	$no_restart_webmin = 1;
	DOMAIN: foreach $d (@{$_[1]}) {
		&$first_print(&text('restore_fordomain', $d->{'dom'}));
		#&$second_print();
		&$indent_print();
		local $f;
		foreach $f (@{$_[2]}) {
			# Restore features
			local $rfunc = "restore_$f";
			if (defined(&$rfunc) &&
			    ($d->{$f} || $f eq "virtualmin")) {
				local $ffile = "$restoredir/$d->{'dom'}_$f";
				if (-r $ffile) {
					local $fok = &$rfunc($d, $ffile,
							     $_[3]->{$f});
					if (!$fok) {
						$ok = 0;
						&$outdent_print();
						last DOMAIN;
						}
					}
				}
			}

		# Re-setup Webmin user
		&modify_webmin($d, $d);
		&$outdent_print();
		}
	$no_restart_webmin = 0;
	&restart_webmin();
	}

system("rm -rf ".quotemeta($restoredir));
if ($mode > 0) {
	# Clean up downloaded file
	system("rm -rf ".quotemeta($backup));
	}
return $ok;
}

# backup_contents(file)
# Returns a hash ref of domains and features in a backup file, or an error
# string if it is invalid
sub backup_contents
{
local $backup;
local ($mode, $user, $pass, $server, $path) = &parse_backup_url($_[0]);
if ($mode > 0) {
	# Need to download to temp file first
	$backup = &tempname();
	local $derr = &download_backup($_[0], $backup);
	return $derr if ($derr);
	}
else {
	$backup = $_[0];
	}

if (-d $backup) {
	# A directory of backup files, one per domain
	opendir(DIR, $backup);
	local $f;
	local %rv;
	foreach $f (readdir(DIR)) {
		next if ($f eq "." || $f eq "..");
		local $cont = &backup_contents("$backup/$f");
		if (ref($cont)) {
			local $d;
			foreach $d (keys %$cont) {
				if ($rv{$d}) {
					&clean_contents_temp();
					return &text('restore_edup', $d);
					}
				else {
					$rv{$d} = $cont->{$d};
					}
				}
			}
		else {
			&clean_contents_temp();
			return $backup."/".$f." : ".$cont;
			}
		}
	closedir(DIR);
	&clean_contents_temp();
	return \%rv;
	}
else {
	# A single file
	local $err;
	open(BACKUP, $backup);
	local $two;
	read(BACKUP, $two, 2);
	close(BACKUP);
	local $out;
	local $q = quotemeta($backup);
	if ($two eq "\037\213") {
		# Assume gzipped tar
		$out = `(gunzip -c $q | tar tf -) 2>&1`;
		}
	else {
		# Assume normal tar
		$out = `tar tf $q 2>&1`;
		}
	if ($?) {
		&clean_contents_temp();
		return $text{'restore_etar'};
		}
	local ($l, %rv, %done);
	foreach $l (split(/\n/, $out)) {
		if ($l =~ /^(.\/)?([^_]+)_([a-z0-9]+)$/) {
			push(@{$rv{$2}}, $3) if (!$done{$2,$3}++);
			}
		}
	&clean_contents_temp();
	return \%rv;
	}

	sub clean_contents_temp
	{
	system("rm -rf ".quotemeta($backup)) if ($mode > 0);
	}
}

# download_backup(url, tempfile)
# Downloads a backup file or directory to a local temp file or directory.
# Returns undef on success, or an error message.
sub download_backup
{
local ($mode, $user, $pass, $server, $path) = &parse_backup_url($_[0]);
if ($mode == 1) {
	# Download from FTP server
	local $cwderr;
	local $isdir = &ftp_onecommand($server, "CWD $path", \$cwderr,
				       $user, $pass);
	local $err;
	if ($isdir) {
		# Need to download entire directory
		mkdir($_[1], 0700);
		local $list = &ftp_listdir($server, $path, \$err, $user, $pass);
		return $err if (!$list);
		foreach $f (@$list) {
			$f =~ s/^$path[\\\/]//;
			&ftp_download($server, "$path/$f", "$_[1]/$f", \$err,
				      undef, $user, $pass);
			return $err if ($err);
			}
		return undef;
		}
	else {
		# Can just download a single file
		&ftp_download($server, $path, $_[1], \$err,
			      undef, $user, $pass);
		return $err;
		}
	}
elsif ($mode == 2) {
	# Download from SSH server
	&scp_copy(($user ? "$user\@" : "")."$server:$path",
		  $_[1], $pass, \$err);
	return $err;
	}
}

# restore_virtualmin(&domain, file)
# Restore the settings for a domain, such as quota, password and so on
sub restore_virtualmin
{
&$first_print($text{'restore_virtualmincp'});
local %oldd;
&read_file($_[1], \%oldd);
$_[0]->{'quota'} = $oldd{'quota'};
$_[0]->{'uquota'} = $oldd{'uquota'};
$_[0]->{'pass'} = $oldd{'pass'};
$_[0]->{'email'} = $oldd{'email'};
$_[0]->{'mailboxlimit'} = $oldd{'mailboxlimit'};
$_[0]->{'owner'} = $oldd{'owner'};
&save_domain($_[0]);

&$second_print($text{'setup_done'});
return 1;
}

# backup_strftime(path)
# Replaces stftime-style % codes in a path with the current time
sub backup_strftime
{
eval "use POSIX";
eval "use posix" if ($@);
local @tm = localtime(time());
return strftime($_[0], @tm);
}

sub parse_backup_url
{
if ($_[0] =~ /^ftp:\/\/([^:]*):([^\@]*)\@([^\/]+)(\/.*)$/) {
	return (1, $1, $2, $3, $4);
	}
elsif ($_[0] =~ /^ssh:\/\/([^:]*):([^\@]*)\@([^\/]+)(\/.*)$/) {
	return (2, $1, $2, $3, $4);
	}
else {
	return (0, undef, undef, undef, $_[0]);
	}
}

# show_backup_destination(name, value)
# Returns HTML for a field for selecting a local or FTP file
sub show_backup_destination
{
local ($mode, $user, $pass, $server, $path) = &parse_backup_url($_[1]);
local $rv;

# Local file field
$rv .= "<table cellpadding=1 cellspacing=0>";
$rv .= sprintf "<tr> <td><input type=radio name=$_[0]_mode value=0 %s></td>\n",
	$mode == 0 ? "checked" : "";
$rv .= sprintf "<td colspan=2>%s <input name=$_[0]_file size=40 value='%s'> %s</td> </tr>\n",
	$text{'backup_mode0'}, $mode == 0 ? $path : "",
	&file_chooser_button("$_[0]_file");

# FTP file fields
$rv .= sprintf "<tr> <td><input type=radio name=$_[0]_mode value=1 %s></td>\n",
	$mode == 1 ? "checked" : "";
$rv .= sprintf "<td>%s <input name=$_[0]_server size=20 value='%s'></td>\n",
	$text{'backup_mode1'}, $mode == 1 ? $server : undef;
$rv .= sprintf "<td>%s <input name=$_[0]_path size=20 value='%s'></td> </tr>\n",
	$text{'backup_path'}, $mode == 1 ? $path : undef;
$rv .= "<tr> <td></td>\n";
$rv .= sprintf "<td>%s <input name=$_[0]_user size=15 value='%s'></td>\n",
	$text{'backup_login'}, $mode == 1 ? $user : undef;
$rv .= sprintf "<td>%s <input name=$_[0]_pass size=15 value='%s'></td> </tr>\n",
	$text{'backup_pass'}, $mode == 1 ? $pass : undef;

# SCP file fields
$rv .= sprintf "<tr> <td><input type=radio name=$_[0]_mode value=2 %s></td>\n",
	$mode == 2 ? "checked" : "";
$rv .= sprintf "<td>%s <input name=$_[0]_sserver size=20 value='%s'></td>\n",
	$text{'backup_mode2'}, $mode == 2 ? $server : undef;
$rv .= sprintf "<td>%s <input name=$_[0]_spath size=20 value='%s'></td> </tr>\n",
	$text{'backup_path'}, $mode == 2 ? $path : undef;
$rv .= "<tr> <td></td>\n";
$rv .= sprintf "<td>%s <input name=$_[0]_suser size=15 value='%s'></td>\n",
	$text{'backup_login'}, $mode == 2 ? $user : undef;
$rv .= sprintf "<td>%s <input name=$_[0]_spass size=15 value='%s'></td> </tr>\n",
	$text{'backup_pass'}, $mode == 2 ? $pass : undef;

$rv .= "</table>\n";
return $rv;
}

# parse_backup_destination(name, &in)
# Returns a backup destination string, or calls error
sub parse_backup_destination
{
local %in = %{$_[1]};
local $mode = $in{"$_[0]_mode"};
if ($mode == 0) {
	$in{"$_[0]_file"} =~ /^\/\S/ || &error($text{'backup_edest'});
	return $in{"$_[0]_file"};
	}
elsif ($mode == 1) {
	gethostbyname($in{"$_[0]_server"}) || &error($text{'backup_eserver1'});
	$in{"$_[0]_path"} =~ /^\/\S/ || &error($text{'backup_epath'});
	$in{"$_[0]_user"} =~ /^[^:\@\/]*$/ || &error($text{'backup_euser'});
	$in{"$_[0]_pass"} =~ /^[^:\@\/]*$/ || &error($text{'backup_epass'});
	return "ftp://".$in{"$_[0]_user"}.":".$in{"$_[0]_pass"}."\@".
	       $in{"$_[0]_server"}.$in{"$_[0]_path"};
	}
elsif ($mode == 2) {
	gethostbyname($in{"$_[0]_sserver"}) || &error($text{'backup_eserver2'});
	$in{"$_[0]_spath"} =~ /^\/\S/ || &error($text{'backup_epath'});
	$in{"$_[0]_suser"} =~ /^[^:\@\/]*$/ || &error($text{'backup_euser'});
	$in{"$_[0]_spass"} =~ /^[^:\@\/]*$/ || &error($text{'backup_epass'});
	return "ssh://".$in{"$_[0]_suser"}.":".$in{"$_[0]_spass"}."\@".
	       $in{"$_[0]_sserver"}.$in{"$_[0]_spath"};
	}
}

# ftp_upload(host, file, srcfile, [&error], [&callback], [user, pass])
# Download data from a local file to an FTP site
sub ftp_upload
{
local($buf, @n);
local $cbfunc = $_[4];

$download_timed_out = undef;
local $SIG{ALRM} = "download_timeout";
alarm(60);

# connect to host and login
&open_socket($_[0], 21, "SOCK", $_[3]) || return 0;
alarm(0);
if ($download_timed_out) {
	if ($_[3]) { ${$_[3]} = $download_timed_out; return 0; }
	else { &error($download_timed_out); }
	}
&ftp_command("", 2, $_[3]) || return 0;
if ($_[5]) {
	# Login as supplied user
	local @urv = &ftp_command("USER $_[5]", [ 2, 3 ], $_[3]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS $_[6]", 2, $_[3]) || return 0;
		}
	}
else {
	# Login as anonymous
	local @urv = &ftp_command("USER anonymous", [ 2, 3 ], $_[3]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS root\@".&get_system_hostname(), 2,
			     $_[3]) || return 0;
		}
	}
&$cbfunc(1, 0) if ($cbfunc);

&ftp_command("TYPE I", 2, $_[3]) || return 0;

# get the file size and tell the callback
local @st = stat($_[2]);
if ($cbfunc) {
	&$cbfunc(2, $st[7]);
	}

# send the file
local $pasv = &ftp_command("PASV", 2, $_[3]);
defined($pasv) || return 0;
$pasv =~ /\(([0-9,]+)\)/;
@n = split(/,/ , $1);
&open_socket("$n[0].$n[1].$n[2].$n[3]", $n[4]*256 + $n[5], "CON", $_[3]) || return 0;
&ftp_command("STOR $_[1]", 1, $_[3]) || return 0;

# transfer data
local $got;
open(PFILE, $_[2]);
while(read(PFILE, $buf, 1024) > 0) {
	print CON $buf;
	$got += length($buf);
	&$cbfunc(3, $got) if ($cbfunc);
	}
close(PFILE);
close(CON);
if ($got != $st[7]) {
	if ($_[3]) { ${$_[3]} = "Upload incomplete"; return 0; }
	else { &error("Upload incomplete"); }
	}
&$cbfunc(4) if ($cbfunc);

# finish off..
&ftp_command("", 2, $_[3]) || return 0;
&ftp_command("QUIT", 2, $_[3]) || return 0;
close(SOCK);

return 1;
}

# ftp_onecommand(host, command, [&error], [user, pass])
# Executes one command on an FTP server, after logging in, and returns its
# exit status.
sub ftp_onecommand
{
local($buf, @n);

$download_timed_out = undef;
local $SIG{ALRM} = "download_timeout";
alarm(60);

# connect to host and login
&open_socket($_[0], 21, "SOCK", $_[2]) || return 0;
alarm(0);
if ($download_timed_out) {
	if ($_[2]) { ${$_[2]} = $download_timed_out; return 0; }
	else { &error($download_timed_out); }
	}
&ftp_command("", 2, $_[2]) || return 0;
if ($_[3]) {
	# Login as supplied user
	local @urv = &ftp_command("USER $_[3]", [ 2, 3 ], $_[2]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS $_[4]", 2, $_[2]) || return 0;
		}
	}
else {
	# Login as anonymous
	local @urv = &ftp_command("USER anonymous", [ 2, 3 ], $_[2]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS root\@".&get_system_hostname(), 2,
			     $_[2]) || return 0;
		}
	}

# make the directory
local @rv = &ftp_command($_[1], 2, $_[2]);
@rv || return 0;

# finish off..
&ftp_command("QUIT", 2, $_[3]) || return 0;
close(SOCK);

return $rv[1];
}

# ftp_listdir(host, dir, [&error], [user, pass])
# Returns a reference to a list of filenames in a directory
sub ftp_listdir
{
local($buf, @n);

$download_timed_out = undef;
local $SIG{ALRM} = "download_timeout";
alarm(60);

# connect to host and login
&open_socket($_[0], 21, "SOCK", $_[2]) || return 0;
alarm(0);
if ($download_timed_out) {
	if ($_[2]) { ${$_[2]} = $download_timed_out; return 0; }
	else { &error($download_timed_out); }
	}
&ftp_command("", 2, $_[2]) || return 0;
if ($_[3]) {
	# Login as supplied user
	local @urv = &ftp_command("USER $_[3]", [ 2, 3 ], $_[2]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS $_[4]", 2, $_[2]) || return 0;
		}
	}
else {
	# Login as anonymous
	local @urv = &ftp_command("USER anonymous", [ 2, 3 ], $_[2]);
	@urv || return 0;
	if (int($urv[1]/100) == 3) {
		&ftp_command("PASS root\@".&get_system_hostname(), 2,
			     $_[2]) || return 0;
		}
	}

# request the listing
local $pasv = &ftp_command("PASV", 2, $_[2]);
defined($pasv) || return 0;
$pasv =~ /\(([0-9,]+)\)/;
@n = split(/,/ , $1);
&open_socket("$n[0].$n[1].$n[2].$n[3]", $n[4]*256 + $n[5], "CON", $_[2]) || return 0;
&ftp_command("NLST $_[1]", 1, $_[2]) || return 0;

# transfer listing
local @list;
while(<CON>) {
	s/\r|\n//g;
	push(@list, $_);
	}
close(CON);

# finish off..
&ftp_command("", 2, $_[3]) || return 0;
&ftp_command("QUIT", 2, $_[3]) || return 0;
close(SOCK);

return \@list;
}

# scp_copy(source, dest, password, &error)
# Copies a file from some source to a destination. One or the other can be
# a server, like user@foo:/path/to/bar/
sub scp_copy
{
&foreign_require("proc", "proc-lib.pl");
local $cmd = "scp -r $_[0] $_[1]";
local ($fh, $fpid) = &proc::pty_process_exec($cmd);
local $out;
while(1) {
	local $rv = &wait_for($fh, "password:", "yes\\/no", ".*\n");
	$out .= $wait_for_input;
	if ($rv == 0) {
		syswrite($fh, "$_[2]\n");
		}
	elsif ($rv == 1) {
		syswrite($fh, "yes\n");
		}
	elsif ($rv < 0) {
		last;
		}
	}
close($fh);
local $got = waitpid($fpid, 0);
if ($? || $out =~ /permission\s+denied/i) {
	${$_[3]} = "scp failed : <pre>$out</pre>";
	}
}

1;

