#!/usr/local/bin/perl
# import.cgi
# Work out what will be imported, and either tell the user or actually do it

require './virtual-server-lib.pl';
$access{'create'} && $access{'import'} || &error($text{'import_ecannot'});
&ReadParse();

&header($text{'import_title'}, "");
print "<hr>\n";

# Check for domain clash
@doms = &list_domains();
($clash) = grep { $_->{'dom'} eq $in{'dom'} } @doms;
$clash && &error_exit($text{'import_eexists'});

# Validate username
$in{'user_def'} || $in{'user'} =~ /^[^\t :]+$/ ||
	&error_exit($text{'setup_euser2'});
$in{'group_def'} || $in{'group'} =~ /^[^\t :]+$/ ||
	&error_exit($text{'import_egroup'});

# Validate quota
if ($config{'home_quotas'}) {
        if ($in{'quota'} == -1) { $in{'quota'} = $in{'otherquota'} };
	$in{'quota'} =~ /^\d+$/ ||  &error($text{'setup_equota'});
	}

# Make sure IP is valid
if ($in{'virt'}) {
	&foreign_require("net", "net-lib.pl");
	($iface) = grep { $_->{'address'} eq $in{'ip'} }
				( &net::boot_interfaces(),
				  &net::active_interfaces() );
	$iface || &error_exit($text{'import_enoip'});
	$iface->{'address'} eq &get_default_ip() &&
		&error_exit($text{'import_eipsame'});
	foreach $d (@doms) {
		$d->{'ip'} eq $in{'ip'} &&
			&error_exit(&text('import_eipclash', $d->{'dom'}));
		}
	$iface->{'virtual'} eq '' &&
		&error_exit(&text('import_ereal', $iface->{'fullname'}));
	}

if ($in{'confirm'}) {
	# Go ahead and do it
	print "$text{'import_doing'}<p>\n";
	&require_useradmin();

	# Get existing group and user details
	$crgroup = $in{'crgroup'} || $in{'group'};
	@groups = &useradmin::list_groups();
	($ginfo) = grep { $_->{'group'} eq $crgroup } @groups;
	&build_group_taken(\%gtaken, \%ggtaken, \@groups);
	$gid = $ginfo ? $ginfo->{'gid'} : &allocate_gid(\%gtaken);

	$cruser = $in{'cruser'} || $in{'user'};
	@users = &useradmin::list_users();
	($uinfo) = grep { $_->{'user'} eq $cruser } @users;
	&build_taken(\%taken, \%utaken, \@users);
	$uid = $uinfo ? $uinfo->{'uid'} : &allocate_uid(\%taken);
	$ugid = $uinfo ? $uinfo->{'gid'} : $gid;
	$ugroup = $uinfo ? getgrgid($uinfo->{'gid'}) : $crgroup;
	$owner = $uinfo ? $uinfo->{'real'} : "Imported domain $in{'dom'}";

	# Create domain details
	%found = map { $_, 1 } split(/\0/, $in{'found'});
	%dom = ( 'id', &domain_id(),
		 'dom', $in{'dom'},
		 'user', $cruser,
		 'group', $crgroup,
		 'ugroup', $ugroup,
		 'quota', &quota_parse('quota', $config{'home_quotas'}),
		 'uid', $uid,
		 'gid', $gid,
		 'ugid', $ugid,
		 'owner', $owner,
		 'mail', int($found{'mail'}),
		 'web', int($found{'web'}),
		 'ftp', int($found{'ftp'}),
		 'webalizer', int($found{'webalizer'}),
		 'mysql', int($found{'mysql'}),
		 'postgres', int($found{'postgres'}),
		 'webmin', $in{'webmin'},
		 'name', !$in{'virt'},
		 'ip', $in{'ip'},
		 'iface', $in{'virt'} ? $iface->{'fullname'} : "",
		 'virt', $in{'virt'},
		 'dns', int($found{'dns'}),
		 'pass', $in{'pass'},
		 'db', $in{'db'},
		 'source', 'import.cgi'
		);

	# Work out home directory
	$dom{'home'} = $uinfo ? $uinfo->{'home'}
			      : &server_home_directory(\%dom);

	if (!$ginfo) {
		# Create the unix group
		print &text('setup_group', $crgroup),"<br>\n";
		&useradmin::lock_user_files();
		%ginfo = ( 'group', $crgroup,
			   'gid', $gid );
		&useradmin::set_group_envs(\%ginfo, 'CREATE_GROUP');
		&useradmin::making_changes();
		&useradmin::create_group(\%ginfo);
		&useradmin::unlock_user_files();
		&useradmin::made_changes();
		print $text{'setup_done'},"<p>\n";
		}
	else {
		%ginfo = %$ginfo;
		}

	if (!$uinfo) {
		# Create the Unix user
		# XXX use common function??
		print &text('setup_user', $cruser),"<br>\n";
		&useradmin::lock_user_files();
		%uinfo = ( 'user', $cruser,
			   'uid', $uid,
			   'gid', $gid,
			   'pass', &useradmin::encrypt_password($in{'pass'}),
			   'real', $owner,
			   'home', $dom{'home'},
			   'shell', $config{'unix_shell'} );
		&set_pass_change(\%uinfo);
		&useradmin::set_user_envs(\%uinfo, 'CREATE_USER',
					  $in{'pass'}, [ ]);
		&useradmin::making_changes();
		&useradmin::create_user(\%uinfo);
		&useradmin::unlock_user_files();
		&useradmin::made_changes();
		&useradmin::unlock_user_files();
		print $text{'setup_done'},"<p>\n";

		if (!-d $uinfo{'home'}) {
			# Create his home directory, and copy files into it
			print $text{'setup_home'},"<br>\n";
			&system_logged(
			  "mkdir '$uinfo{'home'}'");
			&system_logged(
			  "chmod '$uconfig{'homedir_perms'}' '$uinfo{'home'}'");
			&system_logged("chown $uid:$gid '$uinfo{'home'}'");
			&copy_skel_files($config{'virtual_skel'},
					 \%uinfo, $cruser);
			print $text{'setup_done'},"<p>\n";
			}
		}
	else {
		%uinfo = %$uinfo;
		}

	# Setup web directories
	print $text{'import_dirs'},"<br>\n";
	foreach $d ( [ $config{'html_dir'} || 'public_html', '755' ],
		     [ 'cgi-bin', '755' ],
		     [ 'logs', '755' ],
		     [ $config{'homes_dir'}, '755' ] ) {
		if (!-d "$uinfo{'home'}/$d->[0]") {
			&system_logged(
				"mkdir '$uinfo{'home'}/$d->[0]' 2>/dev/null");
			&system_logged(
				"chmod $d->[1] '$uinfo{'home'}/$d->[0]'");
			&system_logged(
				"chown $uid:$ugid '$uinfo{'home'}/$d->[0]'");
			}
		}
	print $text{'setup_done'},"<p>\n";

	# Create the domain details
	print $text{'setup_save'},"<br>\n";
	&save_domain(\%dom);
	print $text{'setup_done'},"<p>\n";

	# Create or update webmin user
	if ($in{'webmin'}) {
		&require_acl();
		($wuser) = grep { $_->{'name'} eq $cruser } &acl::list_users();
		if ($wuser) {
			&modify_webmin(\%dom, \%dom);
			}
		else {
			&setup_webmin(\%dom);
			}
		}

	# Add to this user's list of domains if needed
	if (!&can_edit_domain(\%dom)) {
		$access{'domains'} = join(" ", split(/\s+/, $access{'domains'}),
					       $dom{'id'});
		&save_module_acl(\%access);
		}
	&webmin_log("import", "domain", $dom{'dom'});
	}
else {
	# Just work out what can be done
	print "$text{'import_idesc'}<p>\n";

	# Work out the Unix username
	if ($in{'user_def'}) {
		# Creating a new user with a name taken from the domain
		$in{'dom'} =~ /^([^\.]+)/;
		$try1 = $user = $1;
		if (defined(getpwnam($1)) || $config{'longname'}) {
			$user = $in{'dom'};
			$try2 = $user;
			if (defined(getpwnam($user))) {
				&error_exit(&text('setup_eauto', $try1,$try2));
				}
			}
		print "<b>",&text('import_user1',
				  "<tt>$user</tt>"),"</b><p>\n";
		}
	else {
		# Using a specified name, which may or may not exist
		if (defined(getpwnam($in{'user'}))) {
			print "<b>",&text('import_user2',
					  "<tt>$in{'user'}</tt>"),"</b><p>\n";
			}
		else {
			print "<b>",&text('import_user3',
					  "<tt>$in{'user'}</tt>"),"</b><p>\n";
			}
		}

	if ($in{'group_def'}) {
		# Need to create new group with the same name as the user
		$group = $user || $in{'user'};
		print "<b>",&text('import_group1',
				  "<tt>$group</tt>"),"</b><p>\n";
		}
	else {
		# Using a specified group, which may or may not exist
		if (scalar(@ginfo = getgrnam($in{'group'}))) {
			print "<b>",&text('import_group2',
					  "<tt>$in{'group'}</tt>"),"</b><p>\n";

			setpwent();
			while(@muinfo = getpwent()) {
				$mcount++ if ($muinfo[3] == $ginfo[2]);
				}
			endpwent();
			if ($mcount) {
				print "<b>",&text('import_mailboxes', $mcount,
					  "<tt>$in{'group'}</tt>"),"</b><p>\n";
				}
			}
		else {
			print "<b>",&text('import_group3',
					  "<tt>$in{'group'}</tt>"),"</b><p>\n";
			}
		}

	# Check for mail domain
	if ($config{'mail'}) {
		&require_mail();
		$found{'mail'}++ if (&is_local_domain($in{'dom'}));
		if ($found{'mail'}) {
			print "<b>",&text('import_mail',
				"<tt>$in{'dom'}</tt>"),"</b><p>\n";
			}
		else {
			print &text('import_nomail',
				"<tt>$in{'dom'}</tt>"),"<p>\n";
			}
		}

	# Check for an Apache virtualhost
	if ($config{'web'}) {
		&require_apache();
		($virt, $vconf) = &get_apache_virtual($in{'dom'}, $web_port);
		if ($virt) {
			$found{'web'}++;
			$sn = &apache::find_directive(
				"ServerName", $virt->{'members'});
			$dr = &apache::find_directive(
				"DocumentRoot", $virt->{'members'});
			print "<b>",&text('import_web',
				"<tt>$sn</tt>", "<tt>$dr</tt>"),"</b><p>\n";
			}
		else {
			print &text('import_noweb',
				"<tt>$in{'dom'}</tt>"),"<p>\n";
			}
		}

	# Check for Webalizer on the virtual host logs
	if ($found{'web'}) {
		&require_webalizer();
		$log = &get_apache_log($in{'dom'});
		if ($log && -r &webalizer::config_file_name($log)) {
			$found{'webalizer'}++;
			print "<b>",&text('import_webalizer',
				    "<tt>$log</tt>"),"</b><p>\n";
			}
		else {
			print &text('import_nowebalizer',
				    "<tt>$log</tt>"),"<p>\n";
			}
		}

	# Check for a DNS domain
	if ($config{'dns'}) {
		&require_bind();
		$conf = &bind8::get_config();
		@zones = &bind8::find("zone", $conf);
		foreach $v (&bind8::find("view", $conf)) {
			push(@zones, &bind8::find("zone", $v->{'members'}));
			}
		foreach $z (@zones) {
			if ($z->{'value'} eq $in{'dom'}) {
				$found{'dns'}++;
				last;
				}
			}
		if ($found{'dns'}) {
			print "<b>",&text('import_dns',
				"<tt>$in{'dom'}</tt>"),"</b><p>\n";
			}
		else {
			print &text('import_nodns',
				"<tt>$in{'dom'}</tt>"),"<p>\n";
			}
		}

	if ($in{'db'}) {
		# Check for a MySQL database
		if ($config{'mysql'}) {
			&require_mysql();
			@dbs = &mysql::list_databases();
			$found{'mysql'}++ if (&indexof($in{'db'}, @dbs)>=0);
			if ($found{'mysql'}) {
				print "<b>",&text('import_mysql',
					"<tt>$in{'db'}</tt>"),"</b><p>\n";
				}
			else {
				print &text('import_nomysql',
					"<tt>$in{'db'}</tt>"),"<p>\n";
				}
			}

		# Check for a PostgreSQL database
		if ($config{'postgres'}) {
			&require_postgres();
			@dbs = &postgresql::list_databases();
			$found{'postgres'}++ if (&indexof($in{'db'}, @dbs)>=0);
			if ($found{'postgres'}) {
				print "<b>",&text('import_postgres',
					"<tt>$in{'db'}</tt>"),"</b><p>\n";
				}
			else {
				print &text('import_nopostgres',
					"<tt>$in{'db'}</tt>"),"<p>\n";
				}
			}
		}
	else {
		print $text{'import_nodb'},"<p>\n";
		}

	# Check for a ProFTPd virtualhost
	if ($config{'ftp'} && $in{'virt'}) {
		&require_proftpd();
		($virt, $vconf, $anon, $aconf) = &get_proftpd_virtual($in{'ip'});
		if ($virt && $anon) {
			$found{'ftp'}++;
			print "<b>",&text('import_ftp',
				"<tt>$in{'ip'}</tt>",
				"<tt>$anon->{'value'}</tt>"),"</b><p>\n";
			}
		elsif ($virt) {
			$found{'ftp'}++;
			print "<b>",&text('import_ftpnoanon',
				"<tt>$in{'ip'}</tt>"),"</b><p>\n";
			}
		else {
			print &text('import_noftp',
				"<tt>$in{'ip'}</tt>"),"<p>\n";
			}
		}



	# Tell if a Webmin user will be created
	if ($in{'webmin'}) {
		&require_acl();
		($wuser) = grep { $_->{'name'} eq ($user || $in{'user'}) }
				&acl::list_users();
		if ($wuser) {
			print "<b>",&text('import_webmin1',
				  "<tt>$wuser->{'name'}</tt>"),"</b><p>\n";
			}
		else {
			print "<b>",&text('import_webmin2',
				  "<tt>$wuser->{'name'}</tt>"),"</b><p>\n";
			}
		}
	else {
		print "$text{'import_nowebmin'}<p>\n";
		}

	# Work out if IP would be assigned
	if ($in{'virt'}) {
		print "<b>",&text('import_virt',
				  "<tt>$iface->{'fullname'}</tt>"),"</b><p>\n";
		}
	else {
		print "$text{'import_novirt'}<p>\n";
		}

	# Output form with confirm button
	print &check_clicks_function();
	print "<center><form action=import.cgi method=post>\n";
	foreach $i (keys %in) {
		print "<input type=hidden name=$i value='",
			&html_escape($in{$i}),"'>\n";
		}
	foreach $f (keys %found) {
		print "<input type=hidden name=found value='$f'>\n";
		}
	print "<input type=hidden name=cruser value='$user'>\n";
	print "<input type=hidden name=crgroup value='$group'>\n";
	print "<b>$text{'import_rusure'}</b><p>\n";
	print "<input type=submit name=confirm value='$text{'import_ok'}' ",
	      "onClick='check_clicks(form)'>\n";
	print "</form></center>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

sub error_exit
{
print "<b>",$text{'import_err'}," : ",@_,"</b><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});
exit;
}

