#!/usr/local/bin/perl
# domain_setup.cgi
# Create a new virtual domain

require './virtual-server-lib.pl';
$access{'create'} || &error($text{'form_ecannot'});
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&require_mysql() if ($config{'mysql'});
&require_postgres() if ($config{'postgres'});
&require_acl();
&ReadParse();
&error_setup($text{'setup_err'});

# Validate inputs (check domain name to see if in use)
$in{'dom'} =~ /^[A-Za-z0-9\.\-]+$/ || &error($text{'setup_edomain'});
$in{'dom'} = lc($in{'dom'});
foreach $d (&list_domains()) {
	&error($text{'setup_edomain2'}) if (lc($d->{'dom'}) eq lc($in{'dom'}));
	}
$in{'email_def'} || $in{'email'} =~ /\S/ || &error($text{'setup_eemail'});
$in{'pass'} =~ /\S/ || &error($text{'setup_epass'});
if ($in{'user_def'}) {
	$in{'dom'} =~ /^([^\.]+)/;
	$try1 = $user = $1;
	if (defined(getpwnam($1)) || $config{'longname'}) {
		$user = $in{'dom'};
		$try2 = $user;
		if (defined(getpwnam($user))) {
			&error(&text('setup_eauto', $try1, $try2));
			}
		}
	}
else {
	$in{'user'} = lc($in{'user'});
	$user = $in{'user'};
	$user =~ /^[^\t :]+$/ || &error($text{'setup_euser2'});
	defined(getpwnam($user)) && &error($text{'setup_euser'});
	}
if ($in{'mgroup_def'}) {
	$group = $user;
	}
else {
	$in{'mgroup'} = lc($in{'mgroup'});
	$group = $in{'mgroup'};
	$group =~ /^[^\t :]+$/ || &error($text{'setup_egroup2'});
	}
if (!$in{'group_def'}) {
	$in{'group'} = lc($in{'group'});
	$in{'group'} eq $group && &error(&text('setup_egroup3', $group));
	}
$home_base || &error($text{'setup_ehomebase'});
if (defined(&useradmin::check_username_restrictions)) {
	$uerr = &useradmin::check_username_restrictions($user);
	if ($uerr) {
		&error(&text('setup_eusername', $user, $uerr));
		}
	}
$user =~ /^[a-zA-z]/ || &error(&text('setup_eusername2', $user));
if ($config{'home_quotas'}) {
        if ($in{'quota'} == -1) { $in{'quota'} = $in{'otherquota'} };
        if ($in{'uquota'} == -1) { $in{'uquota'} = $in{'otheruquota'} }; 
	$in{'quota'} =~ /^\d+$/ ||  &error($text{'setup_equota'});
	$in{'uquota'} =~ /^\d+$/ ||  &error($text{'setup_euquota'});
	}
($db = $group) =~ s/[\.\-]/_/g;
$in{'mailbox'} && !$in{'mail'} && &error($text{'setup_emailbox'});
if ($config{'proxy_pass'} && $in{'web'} && !$in{'proxy_def'}) {
	($proxy = $in{'proxy'}) =~ /^(http|https):\/\/\S+$/ ||
		&error($text{'setup_eproxy'});
	}
$in{'mailboxlimit_def'} || $in{'mailboxlimit'} =~ /^[1-9]\d*$/ ||
	&error($text{'setup_emailboxlimit'});
$in{'unix'} = 1;	# always on

# Check for feature dependencies
foreach $f (@features) {
	if ($in{$f}) {
		local $fd;
		foreach $fd (@{$feature_depends{$f}}) {
			&error(&text('setup_edep'.$f)) if (!$in{$fd});
			}
		}
	}

$defip = &get_default_ip();
if ($config{'all_namevirtual'}) {
	# Make sure the IP *is* assigned
	&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
	if (!&check_virt_clash($in{'ip'})) {
		&error(&text('setup_evirtclash2'));
		}
	}
elsif ($in{'virt'}) {
	# Make sure the IP isn't assigned yet
	&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
	if (&check_virt_clash($in{'ip'})) {
		&error(&text('setup_evirtclash'));
		}
	}

# Work out user and group IDs
&build_group_taken(\%gtaken, \%ggtaken);
$gid = &allocate_gid(\%gtaken);
$ugid = $in{'group_def'} ? $gid : getgrnam($in{'group'});
$ugroup = $in{'group_def'} ? $group : $in{'group'};
&build_taken(\%taken, \%utaken);
$uid = &allocate_uid(\%taken);

# Build up domain object
%dom = ( 'id', &domain_id(),
	 'dom', $in{'dom'},
	 'user', $user,
	 'group', $group,
	 'ugroup', $ugroup,
	 'quota', &quota_parse('quota', $config{'home_quotas'}),
	 'uquota', &quota_parse('uquota', $config{'home_quotas'}),
	 'uid', $uid,
	 'gid', $gid,
	 'ugid', $ugid,
	 'owner', $in{'owner'},
	 'email', !$in{'email_def'} ? $in{'email'} :
		  $in{'mailbox'} ? $user."\@".$in{'dom'} :
				   undef,
	 'name', $config{'all_namevirtual'} ? 1 : $in{'virt'} ? 0 : 1,
	 'ip', $config{'all_namevirtual'} ? $in{'ip'} :
	       $in{'virt'} ? $in{'ip'} : $defip,
	 'dns_ip', $in{'virt'} || $config{'all_namevirtual'} ? undef :
		$config{'dns_ip'},
	 'virt', $config{'all_namevirtual'} ? 0 : $in{'virt'},
	 'pass', $in{'pass'},
	 'db', $db,
	 'source', 'domain_setup.cgi',
	 'proxy_pass', $proxy,
	 'mailboxlimit', $in{'mailboxlimit_def'} ? undef : $in{'mailboxlimit'}
	);
my $f;
foreach $f (@features) {
	$dom{$f} = $in{$f};
	}
$dom{'home'} = &server_home_directory(\%dom);

# Check for various clashes
my $f;
foreach $f (@features) {
	if ($in{$f}) {
		local $cfunc = "check_${f}_clash";
		if (&$cfunc(\%dom)) {
			&error(&text('setup_e'.$f, $in{'dom'}, $db, $user, $group));
			}
		}
	}

$| = 1;
$theme_no_table++;
&header($text{'setup_title'}, "");
print "<hr>\n";

# Run the before command
&set_domain_envs(\%dom, "CREATE_DOMAIN");
$merr = &making_changes();
&error(&text('setup_emaking', "<tt>$merr</tt>")) if (defined($merr));

# Set up all the selected features
foreach $f (@features) {
	if ($dom{$f}) {
		local $sfunc = "setup_$f";
		&$sfunc(\%dom);
		}
	}

# Add virtual IP address, if needed
if ($in{'virt'}) {
	&setup_virt(\%dom);
	}

# Add a virtuser for the unix user, if requested
if ($in{'mailbox'}) {
	print $text{'setup_mailbox'},"<br>\n";
	local $virt = { 'from' => $user."\@".$in{'dom'},
			'to' => [ $user ] };
	&create_virtuser($virt);
	print $text{'setup_done'},"<p>\n";
	}

# Save domain details
print $text{'setup_save'},"<br>\n";
&save_domain(\%dom);
print $text{'setup_done'},"<p>\n";

# Notify the owner via email
&send_domain_email(\%dom);

# Add to this user's list of domains if needed
if (!&can_edit_domain(\%dom)) {
	$access{'domains'} = join(" ", split(/\s+/, $access{'domains'}),
				       $dom{'id'});
	&save_module_acl(\%access);
	}

# Run the after creation command
&made_changes();
&webmin_log("create", "domain", $dom{'dom'}, \%dom);

print "<hr>\n";
&footer("", $text{'index_return'});


