#!/usr/local/bin/perl
# delete_domain.cgi
# Delete a domain, after asking first

require './virtual-server-lib.pl';
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&ReadParse();
$d = &get_domain($in{'dom'});
$d && $d->{'uid'} && $d->{'gid'} || &error("Domain $in{'dom'} does not exist!");
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});

if ($in{'confirm'}) {
	$| = 1;
	$theme_no_table++;
	}
&header($text{'delete_title'}, "");
print "<hr>\n";

@users = &list_domain_users($d, 1);
@aliases = &list_domain_aliases($d);
if (!$in{'confirm'}) {
	# Ask the user if he is sure
	print &check_clicks_function();
	$sz = &disk_usage_kb($d->{'home'});
	print "<p>",&text('delete_rusure2', "<tt>$d->{'dom'}</tt>",
		  	  &nice_size($sz*1024)),"<p>\n";

	print "<ul>\n";
	foreach $f (@features) {
		if ($d->{$f} && ($config{$f} || $f eq 'unix')) {
			print "<li>",$text{'feature_'.$f}," - ",
				     $text{'losing_'.$f},"<br>\n";
			}
		}
	if (@users || @aliases) {
		print "<li>",&text('delete_mailboxes', scalar(@users), scalar(@aliases)),"<br>\n";
		}
	print "</ul>\n";

	print "<center><form action=delete_domain.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<input type=submit name=confirm ",
	      "value='$text{'delete_ok'}' onClick='check_clicks(form)'>\n";
	print "<p><input type=checkbox name=only value=1> ",
	      "$text{'delete_only'}<br>\n";
	print "</form></center>\n";

	print "<hr>\n";
	&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		"", $text{'index_return'});
	}
else {
	# Go ahead and delete ..

	# Run the before command
	&set_domain_envs($d, "DELETE_DOMAIN");
	$merr = &making_changes();
	&error(&text('delete_emaking', "<tt>$merr</tt>")) if (defined($merr));

	# Delete domain file
	print $text{'delete_domain'},"<br>\n";
	&delete_domain($d);
	print $text{'setup_done'},"<p>\n";

	if (!$in{'only'}) {
		if (@users) {
			# Delete mail users and their mail files
			print $text{'delete_users'},"<br>\n";
			foreach $u (@users) {
				&delete_user($u);
				&delete_mail_file($u);
				&system_logged("rm -rf '$u->{'home'}'")
					if (-d $u->{'home'} &&
					    $u->{'home'} ne "/");
				}
			print $text{'setup_done'},"<p>\n";
			}

		# Delete all virtusers
		if (@users || @aliases) {
			print $text{'delete_aliases'},"<br>\n";
			foreach $v (&list_virtusers()) {
				if ($v->{'from'} =~ /\@(\S+)$/ &&
				    $1 eq $d->{'dom'}) {
					&delete_virtuser($v);
					}
				}
			print $text{'setup_done'},"<p>\n";
			}

		# Take down IP
		if ($d->{'iface'}) {
			&delete_virt($d);
			}
		}

	# Delete all features (or just 'webmin' if un-importing)
	my $f;
	foreach $f ($in{'only'} ? ( "webmin" ) : reverse(@features)) {
		if ($config{$f} && $d->{$f} || $f eq 'unix') {
			local $dfunc = "delete_$f";
			&$dfunc($d);
			}
		}

	# Run the after command
	&made_changes();
	&webmin_log("delete", "domain", $d->{'dom'}, $d);

	print "<hr>\n";
	&footer("", $text{'index_return'});
	}

