#!/usr/local/bin/perl
# Do an immediate virtual server backup

require './virtual-server-lib.pl';
$master_admin || &error($text{'backup_ecannot'});
&ReadParse();

# Validate inputs
&error_setup($text{'backup_err'});
if ($in{'all'}) {
	@doms = &list_domains();
	}
else {
	foreach $d (split(/\0/, $in{'doms'})) {
		push(@doms, &get_domain($d));
		}
	}
@doms || &error($text{'backup_edoms'});
@do_features = split(/\0/, $in{'feature'});
@do_features || &error($text{'backup_efeatures'});
$dest = &parse_backup_destination("dest", \%in);
$dest = &backup_strftime($dest) if ($in{'strftime'});

# Parse option inputs
foreach $f (@do_features) {
	local $ofunc = "parse_backup_$f";
	if (defined(&$ofunc)) {
		$options{$f} = &$ofunc(\%in);
		}
	}

$| = 1;
$theme_no_table++;
&header($text{'backup_title'}, "");
print "<hr>\n";

print "<p>",&text('backup_doing', scalar(@doms),
				  "<tt>$dest</tt>"),"<p>\n";
($ok, $size) = &backup_domains($dest, \@doms, \@do_features,
			       $in{'fmt'}, $in{'errors'}, \%options);
if (!$ok) {
	unlink($dest);
	print "<p>",$text{'backup_failed'},"<p>\n";
	}
else {
	print "<p>",&text('backup_done', &nice_size($size)),"<p>\n";
	&webmin_log("backup", $dest, undef,
		    { 'doms' => [ map { $_->{'dom'} } @doms ] });
	}

print "<hr>\n";
&footer("", $text{'index_return'});


