#!/usr/local/bin/perl
# reconfig_form.cgi
# Displays a list of supported modules, and allows the user to pick which
# ones are installed in apache

require './apache-lib.pl';
&ReadParse();
$access{'global'}==1 || &error($text{'reconfig_ecannot'});
if ($in{'vol'}) {
	&ui_print_header(undef, $text{'reconfig_title'}, "");
	}
else {
	&ui_print_header(undef, $text{'reconfig_title'}, "", undef, 1, 1);
	}

# Is Apache installed OK?
($ver, $mods) = &httpd_info($httpd = &find_httpd());
if (!$ver) {
	print &text('reconfig_ever', "<tt>$httpd</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Work out which modules Apache has
%inst = map { $_, 1 } &configurable_modules();

# Build list of modules know to Webmin
push(@mods, "core");
opendir(DIR, ".");
foreach $f (readdir(DIR)) {
	if ($f =~ /^(mod_\S+|prefork|worker|perchild|mpm_\S+)\.pl$/) { push(@mods, $1); }
	}
closedir(DIR);
@mods = sort { $a cmp $b } @mods;

if (!$in{'vol'}) {
	print "$text{'reconfig_desc1'}<p>\n";
	print "$text{'reconfig_desc3'}\n";
	}
else {
	print "$text{'reconfig_desc2'}\n";;
	}
print "<p> <form action=reconfig.cgi>\n";
print "<input type=hidden name=size value=$in{'size'}>\n";
print "<input type=hidden name=ver value=\"$ver\">\n";
print "<table width=100%>\n";
for($i=0; $i<@mods; $i++) {
	if ($i%4 == 0) { print "<tr>\n"; }
	print "<td><input type=checkbox name=mods value=$mods[$i] ",
	      ($inst{$mods[$i]} ? "checked" : ""),"> $mods[$i]</td>\n";
	if ($i%4 == 3) { print "</tr>\n"; }
	}
print "</table>\n";
print "<input type=submit value=\"$text{'reconfig_ok'}\"></form>\n";

if ($in{'vol'}) { &ui_print_footer("", $text{'index_return'}); }
else { &ui_print_footer("/", $text{'index'}); }

