#!/usr/local/bin/perl
# edit_mon.cgi
# Display a form for editing or creating a monitor

require './status-lib.pl';
$access{'edit'} || &error($text{'mon_ecannot'});
&foreign_require("servers", "servers-lib.pl");
&ReadParse();
if ($in{'type'}) {
	&header($text{'mon_create'}, "");
	$type = $in{'type'};
	}
else {
	&header($text{'mon_edit'}, "");
	$serv = &get_service($in{'id'});
	$type = $serv->{'type'};
	}
print "<center><font size=+1>",$text{"type_$type"},"</font></center><hr>\n";

print "<form action=save_mon.cgi>\n";
print "<input type=hidden name=type value='$in{'type'}'>\n";
print "<input type=hidden name=id value='$in{'id'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'mon_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

if (-d "../$type") {
	local @st = stat("../$type");
	opendir(DIR, "..");
	foreach $m (readdir(DIR)) {
		local @lst = stat("../$m");
		if (-l "../$m" && $st[1] == $lst[1]) {
			# found a clone
			push(@clones, $m);
			}
		}
	}

print "<tr> <td><b>$text{'mon_desc'}</b></td>\n";
printf "<td><input name=desc size=30 value='%s'></td>\n",
	$in{'type'} ? $text{"type_$type"} : $serv->{'desc'};

if (!$in{'type'}) {
	print "<td><b>$text{'mon_status'}</b></td>\n";
	$stat = &service_status($serv);
	print "<td>",($stat->{'desc'} ? $stat->{'desc'} :
		     $stat->{'up'} == 1 ? $text{'mon_up'} :
		     $stat->{'up'} == -1 ? $text{'mon_not'} :
		     $stat->{'up'} == -2 ? $text{'mon_webmin'} :
		     $stat->{'up'} == -3 ? $text{'mon_timeout'} :
		 "<font color=#ff0000>$text{'mon_down'}</font>"),"</td>\n";
	}
print "</tr>\n";

print "<tr> <td><b>$text{'mon_remote'}</b></td>\n";
@servs = grep { $_->{'user'} } &foreign_call("servers", "list_servers");
if (@servs) {
	printf "<td><input type=radio name=remote_def value=1 %s> %s\n",
		$serv->{'remote'} ? '' : 'checked', $text{'mon_local'};
	printf "<input type=radio name=remote_def value=0 %s>\n",
		$serv->{'remote'} ? 'checked' : '';
	print "<select name=remote>\n";
	foreach $s (@servs) {
		printf "<option %s>%s\n",
			$s->{'host'} eq $serv->{'remote'} ? 'selected' : '',
			$s->{'host'};
		}
	print "</select></td>\n";
	}
else {
	print "<td>$text{'mon_local'} ($text{'mon_none'})</td>\n";
	print "<input type=hidden name=remote_def value=1>\n";
	}

print "<td><b>$text{'mon_nosched'}</b></td>\n";
print "<td><select name=nosched>\n";
printf "<option value=1 %s> %s\n",
	$serv->{'nosched'} == 1 ? "selected" : "", $text{'no'};
printf "<option value=0 %s> %s\n",
	$serv->{'nosched'} == 0 ? "selected" : "", $text{'mon_warndef'};
printf "<option value=3 %s> %s\n",
	$serv->{'nosched'} == 3 ? "selected" : "", $text{'mon_warn1'};
printf "<option value=2 %s> %s\n",
	$serv->{'nosched'} == 2 ? "selected" : "", $text{'mon_warn0'};
printf "<option value=4 %s> %s\n",
	$serv->{'nosched'} == 4 ? "selected" : "", $text{'mon_warn2'};
printf "<option value=5 %s> %s\n",
	$serv->{'nosched'} == 5 ? "selected" : "", $text{'mon_warn3'};
print "</select></td> </tr>\n";

print "<tr> <td><b>$text{'mon_ondown'}</b></td>\n";
print "<td><input name=ondown size=30 value='$serv->{'ondown'}'></td>\n";

print "<td><b>$text{'mon_onup'}</b></td>\n";
print "<td><input name=onup size=30 value='$serv->{'onup'}'></td> </tr>\n";

print "<tr> <td><b>$text{'mon_runon'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=runon value=0 %s> %s\n",
	$serv->{'runon'} ? "" : "checked", $text{'mon_runon0'};
printf "<input type=radio name=runon value=1 %s> %s</td> </tr>\n",
	$serv->{'runon'} ? "checked" : "", $text{'mon_runon1'};

if (@clones) {
	print "<tr> <td><b>$text{'mon_clone'}</b></td>\n";
	print "<td><select name=clone>\n";
	local %minfo = &get_module_info($type);
	printf "<option value='' %s> %s\n",
		$serv->{'clone'} ? '' : 'checked', $minfo{'desc'};
	foreach $c (@clones) {
		%minfo = &get_module_info($c);
		printf "<option value=%s %s>%s\n",
			$c, $serv->{'clone'} eq $c ? 'selected' : '',
			$minfo{'desc'};
		}
	print "</select></td> </tr>\n";
	}

do "./${type}-monitor.pl";
$func = "show_${type}_dialog";
if (defined(&$func)) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";
	&$func($serv);
	}

print "</table></td></tr></table>\n";
print "<table width=100%><tr>\n";
if ($in{'type'}) {
	print "<td><input type=submit value='$text{'create'}'></td>\n";
	}
else {
	print "<td><input type=submit value='$text{'save'}'></td>\n";
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'delete'}'></td>\n";
	}
print "</tr></table></form><hr>\n";
&footer("", $text{'index_return'});

