# software-lib.pl
# A generalized system for package management on solaris, linux, etc..

do '../web-lib.pl';
&init_config();

# Use the appropriate function set for whatever package management system
# we are using.
do "$config{package_system}-lib.pl";

# Guess which update system we are using
if (&has_command("apt-get")) {
	do "apt-lib.pl";
	$has_update_system = 1;
	}
elsif (&has_command("yum") && -r "/etc/yum.conf") {
	do "yum-lib.pl";
	$has_update_system = 1;
	}
elsif (&has_command("up2date") && &has_command("rhn_check")) {
	do "rhn-lib.pl";
	$has_update_system = 1;
	}
elsif (&has_command("cupdate")) {
	# not done yet!
	}

# uncompress_if_needed(file, disposable)
# If some file needs to be uncompressed or ungzipped, do it and return the
# new temp file path. Otherwise, return the original path.
sub uncompress_if_needed
{
open(PFILE, $_[0]);
read(PFILE, $two, 2);
close(PFILE);
if ($two eq "\037\235") {
	if (!&has_command("uncompress")) {
		unlink($_[0]) if ($_[1]);
		&error($text{'soft_euncompress'});
		}
	local $temp = $_[0] =~ /\/([^\/]+)\.Z/i ? &tempname("$1")
						: &tempname();
	local $out = `uncompress -c $_[0] 2>&1 >$temp`;
	unlink($_[0]) if ($_[1]);
	if ($?) {
		unlink($temp);
		&error(&text('soft_euncmsg', $out));
		}
	return $temp;
	}
elsif ($two eq "\037\213") {
	if (!&has_command("gunzip")) {
		unlink($_[0]) if ($_[1]);
		&error($text{'soft_egzip'});
		}
	local $temp = $_[0] =~ /\/([^\/]+)\.gz/i ? &tempname("$1")
						 : &tempname();
	local $out = `gunzip -c $_[0] 2>&1 >$temp`;
	unlink($_[0]) if ($_[1]);
	if ($?) {
		unlink($temp);
		&error(&text('soft_egzmsg', $out));
		}
	return $temp;
	}
return $_[0];
}

# check_on_boot(action)
# Returns 1 if some action is run at boot, 0 otherwise
sub check_on_boot
{
&foreign_require("init", "init-lib.pl");
local %iconfig = &foreign_config("init");
local @boot = &foreign_call("init", "get_inittab_runlevel");
local $boot = 0;
foreach $s (&foreign_call("init", "action_levels", "S", $_[0])) {
	local ($l, $p) = split(/\s+/, $s);
	$boot = 1 if (&indexof($l, @boot) >= 0);
	}
local %daemon;
if ($boot && $iconfig{'daemons_dir'} &&
    &read_env_file("$iconfig{'daemons_dir'}/$_[0]", \%daemon)) {
	$boot = lc($daemon{'ONBOOT'}) eq 'yes' ? 1 : 0;
	}
return $boot;
}

# enable_on_boot(action)
# Make some action run at boot time
sub enable_on_boot
{
&foreign_require("init", "init-lib.pl");
local %iconfig = &foreign_config("init");
local @boot = &foreign_call("init", "get_inittab_runlevel");
local $boot = 0;
foreach $s (&foreign_call("init", "action_levels", "S", $_[0])) {
	local ($l, $p) = split(/\s+/, $s);
	$boot = 1 if (&indexof($l, @boot) >= 0);
	}
&foreign_call("init", "add_rl_action", $_[0], $boot[0], "S",
	      "9" x $iconfig{'order_digits'}) if (!$boot);
local %daemon;
if ($iconfig{'daemons_dir'} &&
    &read_env_file("$iconfig{'daemons_dir'}/$_[0]", \%daemon)) {
	$daemon{'ONBOOT'} = 'yes';
	&write_env_file("$iconfig{'daemons_dir'}/$_[0]", \%daemon);
	}
}

# disable_on_boot(action)
# Make some action not run at boot time
sub disable_on_boot
{
&foreign_require("init", "init-lib.pl");
local %iconfig = &foreign_config("init");
if ($iconfig{'daemons_dir'} &&
    &read_env_file("$iconfig{'daemons_dir'}/$_[0]", \%daemon)) {
	$daemon{'ONBOOT'} = 'no';
	&write_env_file("$iconfig{'daemons_dir'}/$_[0]", \%daemon);
	}
else {
	foreach $s (&foreign_call("init", "action_levels", "S", $_[0])) {
		local @s = split(/\s+/, $s);
		&foreign_call("init", "delete_rl_action", $_[0], $s[0], "S");
		}
	}
}

# init_script(action)
# Returns the full path to some init script
sub init_script
{
local %iconfig = &foreign_config("init");
return "$iconfig{'init_dir'}/$_[0]";
}

# show_package_info(package, version)
sub show_package_info
{
@pinfo = &package_info($_[0], $_[1]);
return () if (!@pinfo);
print "<h3>",&text('do_success', $_[0]),"</h3>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'do_details'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
print "<tr> <td valign=top width=20%><b>$text{'do_desc'}</b></td>\n";
print "<td colspan=3><pre>",&html_escape($pinfo[2]),"</pre></td> </tr>\n";

print "<tr> <td width=20%><b>$text{'do_pack'}</b></td> <td>",
	&html_escape($pinfo[0]),"</td>\n";
print "<td width=20%><b>$text{'do_class'}</b></td> <td>",
	$pinfo[1] ? &html_escape($pinfo[1]) : $text{'do_none'},"</td> </tr>\n";

print "<tr> <td width=20%><b>$text{'do_ver'}</b></td> <td>",
	&html_escape($pinfo[4]),"</td>\n";
print "<td width=20%><b>$text{'do_vend'}</b></td> <td>",
	&html_escape($pinfo[5]),"</td> </tr>\n";

print "<tr> <td width=20%><b>$text{'do_arch'}</b></td> <td>",
	&html_escape($pinfo[3]),"</td>\n";
print "<td width=20%><b>$text{'do_inst'}</b></td> <td>",
	&html_escape($pinfo[6]),"</td> </tr>\n";
print "</table></td></tr></table><p>\n";
return @pinfo;
}

@type_map = (	$text{'soft_reg'},	$text{'soft_dir'},	$text{'soft_spec'},
		$text{'soft_sym'},	$text{'soft_hard'},	$text{'soft_edit'} );

