
do 'mailboxes-lib.pl';

# useradmin_create_user(&details)
# Create a new empty mail file
sub useradmin_create_user
{
if ($config{'sync_create'}) {
	local ($dir, $style, $mailbox, $maildir) = &get_mail_style();
	if ($dir && -d $dir) {
		local $mf = &mail_file_style($_[0]->{'user'}, $dir, $style);
		if (!-e $mf) {
			open(TOUCH, ">$mf");
			close(TOUCH);
			if ($config{'sync_perms'}) {
				system("chmod ".
				       quotemeta($config{'sync_perms'})." ".
				       quotemeta($mf));
				}
			chown($_[0]->{'uid'}, $_[0]->{'gid'}, $mf);
			}
		}
	}
}

# useradmin_delete_user(&details)
# Delete the user's mail file
sub useradmin_delete_user
{
if ($config{'sync_delete'}) {
	local ($dir, $style, $mailbox, $maildir) = &get_mail_style();
	if ($dir && -d $dir) {
		local $mf = &mail_file_style($_[0]->{'user'}, $dir, $style);
		unlink($mf);
		unlink($mf.".pop");
		}
	}
}

# useradmin_modify_user(&details)
# Rename the user's mail file if necessary, and change it's UID
sub useradmin_modify_user
{
if ($config{'sync_modify'}) {
	local ($dir, $style, $mailbox, $maildir) = &get_mail_style();
	if ($dir && -d $dir) {
		local $omf = &mail_file_style($_[0]->{'olduser'}, $dir, $style);
		local $nmf = &mail_file_style($_[0]->{'user'}, $dir, $style);
		local @st = stat($omf);
		if ($st[4] != $_[0]->{'uid'}) {
			chown($_[0]->{'uid'}, $st[5], $omf);
			}
		if ($omf ne $nmf && -e $omf) {
			&rename_logged($omf, $nmf);
			}
		}
	}
}

1;

