#!/usr/local/bin/perl
# index.cgi
# Display the icons for various types of proftpd config options

require './proftpd-lib.pl';

# Check if proftpd is installed
@st = stat($config{'proftpd_path'});
if (!@st) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("proftpd", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_eproftpd', "<tt>$config{'proftpd_path'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the config file exists
@conf = &get_config();
if (!@conf) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("proftpd", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_econf', "<tt>$config{'proftpd_conf'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the executable has changed ..
if ($site{'size'} != $st[7]) {
	# Check if it really is proftpd and the right version
	$site{'size'} = $st[7];
	$out = `$config{'proftpd_path'} -v 2>&1`;
	if ($out !~ /ProFTPD\s+Version\s+(\d+)\.([0-9\.]+)/i &&
	    $out !~ /ProFTPD\s+(\d+)\.([0-9\.]+)/i) {
		&header($text{'index_title'}, "", undef, 1, 1, 0,
			&help_search_link("proftpd", "man", "doc", "google"));
		print "<hr>\n";
		print "<p>",&text('index_eproftpd2',
			  "<tt>$config{'proftpd_path'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name",
			  "<tt>$config{'proftpd_path'} -v</tt>",
			  "<pre>$out</pre>"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	local ($v1, $v2) = ($1, $2);
	$v2 =~ s/\.//g;
	$site{'version'} = "$v1.$v2";
	if ($site{'version'} < 0.99) {
		&header($text{'index_title'}, "", undef, 1, 1, 0,
			&help_search_link("proftpd", "man", "doc", "google"));
		print "<hr>\n";
		print "<p>",&text('index_eversion',
				  "<tt>$config{'proftpd_path'}</tt>",
				  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}

	# Get the list of modules
	local @mods;
	open(MODS, "$config{'proftpd_path'} -l |");
	while(<MODS>) {
		s/\r|\n//g;
		if (/^\s*(\S+)\.c$/) {
			push(@mods, $1);
			}
		}
	close(MODS);
	$site{'modules'} = join(" ", @mods);
	&write_file("$module_config_directory/site", \%site);
	}

&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("proftpd", "man", "doc", "google"),
	undef, undef, &text('index_version', $site{'version'}));
print "<hr>\n";
$conf = &get_config();

# Display global category icons
print "<h3>$text{'index_global'}</h3>\n";
$ft_icon = { "icon" => "images/dir.gif",
	     "name" => $text{'ftpaccess_title'},
	     "link" => "ftpaccess.cgi" };
$us_icon = { "icon" => "images/ftpusers.gif",
	     "name" => $text{'ftpusers_title'},
	     "link" => "edit_ftpusers.cgi" };
$ed_icon = { "icon" => "images/edit.gif",
	     "name" => $text{'manual_configs'},
	     "link" => "allmanual_form.cgi" };
&config_icons("root global", "edit_global.cgi?", $ft_icon, $us_icon, $ed_icon);

# Display global per-directory/limit options
$global = &find_directive_struct("Global", $conf);
$gconf = $global->{'members'} if ($global);
@dir = ( &find_directive_struct("Directory", $gconf) ,
	 &find_directive_struct("Limit", $gconf) );
if (@dir) {
	print "<hr>\n";
	print "<h3>$text{'virt_header'}</h3>\n";
	print "<table width=100% cellpadding=5>\n";
	foreach $d (@dir) {
		if ($i%3 == 0) { print "<tr>\n"; }
		print "<td valign=top align=center width=33%>\n";
		if ($d->{'name'} eq 'Limit') {
			&generate_icon("images/limit.gif",
				&text('virt_limit', $d->{'value'}),
				"limit_index.cgi?limit=".&indexof($d, @$gconf).
				"&global=1");
			}
		else {
			&generate_icon("images/dir.gif",
				&text('virt_dir', $d->{'value'}),
				"dir_index.cgi?idx=".&indexof($d, @$gconf).
				"&global=1");
			}
		print "</td>\n";
		if ($i++%3 == 2) { print "</tr>\n"; }
		}
	while($i++%3) { print "<td width=33%></td>\n"; }
	print "</table>\n";
	}

print "<table width=100%><tr><td>\n";

print "<form action=create_dir.cgi>\n";
print "<input type=hidden name=global value=1>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_adddir'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_path'}</b></td>\n";
print "<td><input name=dir size=30>\n";
print "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "</td><td>\n";

print "<form action=create_limit.cgi>\n";
print "<input type=hidden name=global value=1>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_addlimit'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_cmds'}</b></td>\n";
print "<td><input name=cmd size=20>\n";
print "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "</td></tr></table>\n";


# Start virtual server list with default
push(@vname, $text{'index_defserv'});
push(@vlink, "virt_index.cgi");
push(@vdesc, $text{'index_defdesc'});
push(@vaddr, $text{'index_any'});
push(@vserv, &def(&find_directive("ServerName", $conf), $text{'default'}));

# Add other virtual servers
@virt = &find_directive_struct("VirtualHost", $conf);
foreach $v (@virt) {
	$vm = $v->{'members'};
	push(@vname, $text{'index_virt'});
	push(@vlink, "virt_index.cgi?virt=".&indexof($v, @$conf));
	push(@vaddr, $v->{'value'});
	$sname = &find_directive("ServerName", $vm);
	local $ip = &to_ipaddress($v->{'value'});
	push(@vdesc, &text('index_vdesc', $ip ? $ip : $text{'index_eip'}));
	push(@vserv, &def(&find_vdirective("ServerName", $vm, $conf),
			  $text{'index_auto'}));
	}

# Show virtual servers
print "<hr>\n";
print "<h3>$text{'index_virts'}</h3>\n";

if ($config{'show_list'} && scalar(@vname)) {
	# as list for people with lots of servers
	print "<table width=100% border=1>\n";
	print "<tr $tb> <td><b>$text{'index_type'}</b></td> ",
	      "<td><b>$text{'index_addr'}</b></td> ",
	      "<td><b>$text{'index_name'}</b></td> </tr>\n";
	for($i=0; $i<@vname; $i++) {
		print "<tr $cb>\n";
		print "<td><a href=\"$vlink[$i]\">",
		      &html_escape($vname[$i]),"</a></td>\n";
		print "<td>",&html_escape($vaddr[$i]),"</td>\n";
		print "<td>",&html_escape($vserv[$i]),"</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	# as icons for niceness
	print "<table width=100% cellpadding=5>\n";
	for($i=0; $i<@vname; $i++) {
		print "<tr> <td valign=top align=center nowrap>";
		&generate_icon("images/virt.gif", &html_escape($vname[$i]),
			       $vlink[$i]);
		print "</td> <td valign=top>\n";
		print &html_escape($vdesc[$i]),"<br>\n";
		print "<table width=100%><tr>\n";
		print "<td width=30%><b>$text{'index_addr'}</b> ",
		      &html_escape($vaddr[$i]),"</td>\n";
		print "<td width=70%><b>$text{'index_name'}</b> ",
		      &html_escape($vserv[$i]),"</td></tr>\n";
		print "</table></td> </tr>\n";
		}
	print "</table>\n";
	}

print "<form action=create_virt.cgi>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'index_create'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'index_addr'}</b></td>\n";
print "<td><input name=addr size=25></td> </tr>\n";
print "<tr> <td><b>$text{'index_port'}</b></td>\n";
print "<td>",&opt_input(undef, "Port", $text{'default'}, 6),"</td> </tr>\n";
print "<tr> <td><b>$text{'index_name'}</b></td>\n";
print "<td>",&opt_input(undef, "ServerName", $text{'default'}, 25);
print "&nbsp;&nbsp;\n";
print "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table>\n";
print "</form>\n";

if (&foreign_check('inetd')) {
	# Check if proftpd is in inetd
	&foreign_require('inetd', 'inetd-lib.pl');
	foreach $i (&foreign_call('inetd', 'list_inets')) {
		if ($i->[1] && $i->[3] eq 'ftp') {
			$inet = $i;
			last;
			}
		}
	$inet_mod = 'inetd';
	}
elsif (&foreign_check('xinetd')) {
	# Check if proftpd is in xinetd
	&foreign_require('xinetd', 'xinetd-lib.pl');
	foreach $xi (&foreign_call("xinetd", "get_xinetd_config")) {
		if ($xi->{'quick'}->{'disable'}->[0] ne 'yes' &&
		    $xi->{'value'} eq 'ftp') {
			$inet = $xi;
			last;
			}
		}
	$inet_mod = 'xinetd';
	}
else {
	# Not supported on this OS .. assume so
	$inet = 1;
	}

if (!$inet) {
	# Get the FTP server pid
	if (open(PID, $config{'pid_file'})) {
		chop($pid = <PID>);
		close(PID);
		}
	$pid = undef if (!kill(0, $pid));
	}

if (!$inet && $pid) {
	print "<hr>\n";
	print "<form action=apply.cgi>\n";
	print "<input type=hidden name=pid value='$pid'>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'}</td>\n";
	print "</tr></table></form>\n";
	}
elsif (!$inet && !$pid) {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	if ($inet_mod) {
		print "<td>",&text('index_startmsg', "/$inet_mod/"),"</td>\n";
		}
	else {
		print "<td>$text{'index_startmsg2'}</td>\n";
		}
	print "</tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

