# firewall-lib.pl
# Functions for parsing iptables-save format files
# - help pages

do '../web-lib.pl';
&init_config();
if ($config{'save_file'}) {
	# Force use of a different save file, and webmin's functions
	$iptables_save_file = $config{'save_file'};
	}
else {
	if (-r "$module_root_directory/$gconfig{'os_type'}-lib.pl") {
		# Use the operating system's save file and functions
		do "$gconfig{'os_type'}-lib.pl";
		}

	if (!$iptables_save_file) {
		# Use webmin's own save file
		$iptables_save_file = "$module_config_directory/iptables.save";
		}
	}

@known_tables = ( "filter", "mangle", "nat" );
@known_args =   ('-p', '-m', '-s', '-d', '-i', '-o', '-f',
		 '--dport', '--sport', '--tcp-flags', '--tcp-option',
		 '--icmp-type', '--mac-source', '--limit', '--limit-burst',
		 '--ports', '--uid-owner', '--gid-owner',
		 '--pid-owner', '--sid-owner', '--state', '--tos', '-j',
		 '--to-ports', '--to-destination', '--to-source',
		 '--reject-with', '--dports', '--sports');

# get_iptables_save([file])
# Parse the iptables save file into a list of tables 
# format seems to be:
#  *table
#  :chain defaultpolicy
#  -A chain options
#  COMMIT
sub get_iptables_save
{
local (@rv, $table, %got);
local $lnum = 0;
open(FILE, $_[0] || ($config{'direct'} ? "iptables-save |"
				       : $iptables_save_file));
local $cmt;
while(<FILE>) {
        local $read_comment;
	s/\r|\n//g;
	if (s/#\s*(.*)$//) {
		$cmt .= " " if ($cmt);
		$cmt .= $1;
		$read_comment=1;
		}
	if (/^\*(\S+)/) {
		# Start of a new table
		$got{$1}++;
		push(@rv, $table = { 'line' => $lnum,
				     'eline' => $lnum,
				     'name' => $1,
				     'rules' => [ ],
				     'defaults' => { } });
		}
	elsif (/^:(\S+)\s+(\S+)/) {
		# Default policy definition
		$table->{'defaults'}->{$1} = $2;
		}
	elsif (/^(\[[^\]]*\]\s+)?-A\s+(\S+)(.*)/) {
		# Rule definition
		local $rule = { 'line' => $lnum,
				'eline' => $lnum,
				'index' => scalar(@{$table->{'rules'}}),
				'cmt' => $cmt,
				'chain' => $2,
				'args' => $3 };
		push(@{$table->{'rules'}}, $rule);

		# Parse arguments
		foreach $a (@known_args) {
			local @vl;
			while($rule->{'args'} =~ s/\s+(!?)\s*($a)\s+(!?)\s*(([^ \-!]\S*(\s+|$))+)/ / || $rule->{'args'} =~ s/\s+(!?)\s*($a)()(\s+|$)/ /) {
				push(@vl, [ $1 || $3, split(/\s+/, $4) ]);
				}
			local ($aa = $a); $aa =~ s/^-+//;
			if ($a eq '-m') {
				$rule->{$aa} = \@vl if (@vl);
				}
			else {
				$rule->{$aa} = $vl[0];
				}
			}
		}
	elsif (/^COMMIT/) {
		# Marks end of a table
		$table->{'eline'} = $lnum;
		}
	elsif (/\S/) {
		&error(&text('eiptables', "<tt>$_</tt>"));
		}
	$lnum++;
	if (! defined($read_comment)) { $cmt=undef; }
	}
close(FILE);
@rv = sort { $a->{'name'} cmp $b->{'name'} } @rv;
local $i;
map { $_->{'index'} = $i++ } @rv;
return @rv;
}

# save_table(&table)
# Updates an existing IPtable in the save file
sub save_table
{
local $lref;
if ($config{'direct'}) {
	# Read in the current iptables-save output
	$lref = &read_file_lines("iptables-save |");
	}
else {
	# Updating the save file
	$lref = &read_file_lines($iptables_save_file);
	}
local @lines = ( "*$_[0]->{'name'}" );
local ($d, $r);
foreach $d (keys %{$_[0]->{'defaults'}}) {
	push(@lines, ":$d $_[0]->{'defaults'}->{$d} [0:0]");
	}
foreach $r (@{$_[0]->{'rules'}}) {
	local $line;
	$line = "# $r->{'cmt'}\n" if ($r->{'cmt'});
	$line .= "-A $r->{'chain'}";
	foreach $a (@known_args) {
		local ($aa = $a); $aa =~ s/^-+//;
		if ($r->{$aa}) {
			local @al = ref($r->{$aa}->[0]) ?
					@{$r->{$aa}} : ( $r->{$aa} );
			foreach $ag (@al) {
				local $n = shift(@$ag);
				$line .= " ".join(" ", $n ? ( $n ) : (),
						       $a, @$ag);
				}
			}
		}
	$line .= " $r->{'args'}" if ($r->{'args'} =~ /\S/);
	push(@lines, $line);
	}
push(@lines, "COMMIT");
if (defined($_[0]->{'line'})) {
	# Update in file
	splice(@$lref, $_[0]->{'line'}, $_[0]->{'eline'} - $_[0]->{'line'} + 1,
	       @lines);
	}
else {
	# Append new table to file
	push(@$lref, "# Generated by webmin", @lines, "# Completed");
	}
if ($config{'direct'}) {
	# Pass new lines to iptables-restore
	open(SAVE, "| iptables-restore");
	print SAVE map { $_."\n" } @$lref;
	close(SAVE);
	}
else {
	# Just save the file
	&flush_file_lines();
	}
}

# describe_rule(&rule)
sub describe_rule
{
local (@c, $d);
foreach $d ('p', 's', 'd', 'i', 'o', 'f', 'dport',
	    'sport', 'tcp-flags', 'tcp-option',
	    'icmp-type', 'mac-source', 'limit', 'limit-burst',
	    'ports', 'uid-owner', 'gid-owner',
	    'pid-owner', 'sid-owner', 'state', 'tos',
	    'dports', 'sports') {
	if ($_[0]->{$d}) {
		local ($n, @v) = @{$_[0]->{$d}};
		@v = map { uc($_) } @v if ($d eq 'p');
		local $txt = &text("desc_$d$n", map { "<b>$_</b>" } @v);
		push(@c, $txt) if ($txt);
		}
	}
local $rv;
if (@c) {
	$rv = &text('desc_conds', join(" $text{'desc_and'} ", @c));
	}
else {
	$rv = $text{'desc_always'};
	}
return $rv;
}

# create_firewall_init()
# Do whatever is needed to have the firewall started at boot time
sub create_firewall_init
{
if (defined(&enable_at_boot)) {
	# Use distro's function
	&enable_at_boot();
	}
else {
	# May need to create init script
	&create_webmin_init();
	}
}

# create_webmin_init()
# Create (if necessary) the Webmin iptables init script
sub create_webmin_init
{
local $res = &has_command("iptables-restore");
local $ipt = &has_command("iptables");
local $start = "$res <$iptables_save_file";
local $stop = "$ipt -t filter -F\n".
	      "$ipt -t nat -F\n".
	      "$ipt -t mangle -F\n".
	      "$ipt -t filter -P INPUT ACCEPT\n".
	      "$ipt -t filter -P OUTPUT ACCEPT\n".
	      "$ipt -t filter -P FORWARD ACCEPT\n".
	      "$ipt -t nat -P PREROUTING ACCEPT\n".
	      "$ipt -t nat -P POSTROUTING ACCEPT\n".
	      "$ipt -t nat -P OUTPUT ACCEPT\n".
	      "$ipt -t mangle -P PREROUTING ACCEPT\n".
	      "$ipt -t mangle -P OUTPUT ACCEPT";
&foreign_require("init", "init-lib.pl");
&init::enable_at_boot("webmin-iptables", "Load IPtables save file",
		      $start, $stop);
}

# interface_choice(name, value)
sub interface_choice
{
local @ifaces;
if (&foreign_check("net")) {
	&foreign_require("net", "net-lib.pl");
	local $i;
	foreach $i (&net::active_interfaces(), &net::boot_interfaces()) {
		push(@ifaces, $i->{'fullname'});
		}
	@ifaces = &unique(@ifaces);
	}
if (@ifaces) {
	local $rv = "<select name=$_[0]>\n";
	local ($i, $found);
	foreach $i (@ifaces) {
		$rv .= sprintf "<option value=%s %s>%s\n",
			$i, $_[1] eq $i ? "selected" : "", $i;
		$found++ if ($_[1] eq $i);
		}
	#$rv .= "<option value=$_[1] selected>$_[1]\n" if (!$found && $_[1]);
	$rv .= sprintf "<option value='' %s> %s\n",
			!$found && $_[1] ? "selected" : "", $text{'edit_oifc'};
	$rv .= "</select>\n";
	$rv .= sprintf "<input name=$_[0]_other size=6 value='%s'>\n",
			!$found ? $_[1] : "";
	return $rv;
	}
else {
	return "<input name=$_[0] size=6 value='$_[1]'>";
	}
}

sub check_previous
{
	my (@p,$max,$n)=@_;
	for ($i=0;$i<$max;$i++)
	{
		if ($n eq $p[$i]){return 1}
	}
	return -1;
}
 
sub by_string_for_iptables
{
	my @p=("PREROUTING","INPUT","FORWARD","OUTPUT","POSTROUTING");

	for ($i=0;$i<@p;$i++)
	{
		if ($a eq $p[$i]){
			if (&check_previous(@p,$i,$b)){return -1;}
			else{ return 1;}}
		if ($b eq $p[$i]){
			if (&check_previous(@p,$i,$b)){return 1;}
			else{ return -1;}}
	}

	return $a cmp $b;
}

sub missing_firewall_commands
{
local $c;
foreach $c ("iptables", "iptables-restore", "iptables-save") {
	return $c if (!&has_command($c));
	}
return undef;
}

# iptables_restore()
# Activates the current firewall rules, and returns any error
sub iptables_restore
{
local $out = &backquote_logged("cd / ; iptables-restore <$iptables_save_file 2>&1");
return $? ? "<pre>$out</pre>" : undef;
}

# iptables_save()
# Saves the active firewall rules, and returns any error
sub iptables_save
{
local $out = &backquote_logged("iptables-save >$iptables_save_file 2>&1");
return $? ? "<pre>$out</pre>" : undef;
}

1;

