#!/usr/local/bin/perl
# edit_slave.cgi
# Display records and other info for an existing slave or stub zone

require './bind8-lib.pl';
%access = &get_module_acl();
&ReadParse();
$bconf = $conf = &get_config();
if ($in{'view'} ne '') {
	$view = $conf->[$in{'view'}];
	$conf = $view->{'members'};
	}
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $conf->[$in{'index'}], $view) ||
	&error($text{'slave_ecannot'});
if ($0 =~ /edit_slave/) {
	&header($text{'slave_title'}, "");
	}
else {
	&header($text{'stub_title'}, "");
	}
print "<center><font size=+2>", &ip6int_to_net(&arpa_to_ip($dom)),
      "</font></center>\n";

if (&find("file", $zconf)) {
	$file = &find("file", $zconf)->{'value'};
	print "<hr><p>\n";
	@recs = &read_zone_file($file, $dom);
	if ($dom =~ /in-addr\.arpa/i || $dom =~ /\.$ipv6revzone/i) {
		@rcodes = ("PTR", "NS");
		}
	else {
		@rcodes = ("A", "NS", "CNAME", "MX", "HINFO",
			   "TXT", "WKS", "RP");
		if ($config{'support_aaaa'}) {
			push(@rcodes, "AAAA");
			}
		}
	foreach $c (@rcodes) { $rnum{$c} = 0; }
	foreach $r (@recs) {
		$rnum{$r->{'type'}}++;
		if ($r->{'type'} eq "SOA") { $soa = $r; }
		}
	if ($config{'show_list'}) {
		# display as list
		$mid = int((@rcodes+1)/2);
		print "<table width=100%> <tr><td width=50%>\n";
		&types_table(@rcodes[0..$mid-1]);
		print "</td><td width=50%>\n";
		&types_table(@rcodes[$mid..$#rcodes]);
		print "</td></tr> </table>\n";
		}
	else {
		# display as icons
		for($i=0; $i<@rcodes; $i++) {
			push(@rlinks, "edit_recs.cgi?index=$in{'index'}".
				      "&view=$in{'view'}&type=$rcodes[$i]");
			push(@rtitles, $text{"type_$rcodes[$i]"}.
				       " ($rnum{$rcodes[$i]})");
			push(@ricons, "images/$rcodes[$i].gif");
			}
		&icons_table(\@rlinks, \@rtitles, \@ricons);
		}
	}

# Shut buttons for editing, options and whois
if ($access{'file'} && $file) {
	push(@links, "view_text.cgi?index=$in{'index'}&view=$in{'view'}");
	push(@titles, $text{'slave_manual'});
	push(@images, "images/text.gif");
	}
if ($access{'opts'}) {
	push(@links, "edit_soptions.cgi?index=$in{'index'}&view=$in{'view'}");
	push(@titles, $text{'master_options'});
	push(@images, "images/options.gif");
	}
if ($access{'whois'} && &has_command($config{'whois_cmd'}) &&
    $dom !~ /in-addr\.arpa/i) {
	push(@links, "whois.cgi?index=$in{'index'}&view=$in{'view'}");
	push(@titles, $text{'master_whois'});
	push(@images, "images/whois.gif");
	}
if (@links) {
	print "<hr>\n";
	&icons_table(\@links, \@titles, \@images);
	}

$apply = $access{'apply'} && &has_ndc();
if (!$access{'ro'} && ($access{'delete'} || $apply)) {
	print "<hr>\n";
	print "<table width=100%>\n";

	if ($access{'delete'}) {
		print "<form action=delete_zone.cgi>\n";
		print "<input type=hidden name=index value=\"$in{'index'}\">\n";
		print "<input type=hidden name=view value=\"$in{'view'}\">\n";
		print "<tr><td>\n";
		print "<input type=submit value=\"$text{'master_del'}\">\n";
		print "</td> <td>$text{'slave_delmsg'}\n";
		print "</td> </tr></form>\n";
		}

	if ($apply) {
		# Show button to do an NDC reload
		print "<form action=restart_zone.cgi>\n";
		print "<input type=hidden name=index value=\"$in{'index'}\">\n";
		print "<input type=hidden name=view value=\"$in{'view'}\">\n";
		print "<tr><td>\n";
		print "<input type=submit value=\"$text{'slave_apply'}\">\n";
		$args = $view ? "$dom IN $view->{'value'}" : $dom;
		$cmd = &has_ndc() == 2 ? $config{'rndc_cmd'}
				       : $config{'ndc_cmd'};
		print "</td> <td>",&text('slave_applymsg',
			"<tt>$cmd reload $args</tt>");
		print "</td> </tr></form>\n";
		}

	print "</table>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

sub types_table
{
if ($_[0]) {
	local($i);
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'master_type'}</b></td> ",
	      "<td><b>$text{'master_records'}</b></td> </tr>\n";
	for($i=0; $_[$i]; $i++) {
		print "<tr $cb> <td><a href=\"edit_recs.cgi?",
		      "index=$in{'index'}&view=$in{'view'}&type=$_[$i]\">",
		      $text{"type_$_[$i]"},"</a></td>\n";
		print "<td>$rnum{$_[$i]}</td> </tr>\n";
		}
	print "</table>\n";
	}
}

