#!/usr/local/bin/perl
# edit_recs.cgi
# Display records of some type from some domain

require './bind8-lib.pl';
&ReadParse();
$conf = &get_config();
if ($in{'view'} ne '') {
	$view = $conf->[$in{'view'}];
	$conf = $view->{'members'};
	}
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $conf->[$in{'index'}], $view) ||
	&error($text{'recs_ecannot'});
&can_edit_type($in{'type'}, \%access) ||
	&error($text{'recs_ecannottype'});
&header(&text('recs_title', $text{"recs_$in{'type'}"} || $in{'type'}), "");
print "<center><font size=+2>",
      &text('recs_header', &ip6int_to_net(&arpa_to_ip($dom))),
      "</font></center>\n";
print "<hr>\n";

$type = &find("type", $zconf)->{'value'};
$file = &find("file", $zconf)->{'value'};
&record_input($in{'index'}, $in{'view'}, $in{'type'}, $file, $dom)
	if (!$access{'ro'} && $type eq 'master' && $in{'type'} ne 'ALL');
@recs = grep { !$_->{'generate'} && !$_->{'defttl'} }
	     &read_zone_file($file, $dom);
if ($in{'type'} eq "ALL") {
	@recs = grep { $_->{'type'} ne "SOA" } @recs
	}
else {
	@recs = grep { $_->{'type'} eq $in{'type'} } @recs
	}
if (@recs) {
	@recs = &sort_records(@recs);
	foreach $v (keys %text) {
		if ($v =~ /^value_(\S+)(\d+)/) {
			$hmap{$1}->[$2-1] = $text{$v};
			}
		}
	if ($in{'type'} =~ /HINFO|WKS|RP|KEY|LOC/ || $config{'allow_comments'}) {
		&recs_table(@recs);
		}
	else {
		$mid = int((@recs+1)/2);
		print "<table width=100%><tr><td width=50% valign=top>\n";
		&recs_table(@recs[0 .. $mid-1]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @recs) { &recs_table(@recs[$mid .. $#recs]); }
		print "</td></tr></table><p>\n";
		}
	print "<p>\n";
	}
print "<hr>\n";
&footer("", $text{'index_return'},
	"edit_$type.cgi?index=$in{'index'}&view=$in{'view'}",
	$text{'recs_return'});

sub recs_table
{
local($r, $i, $j, $k, $h);
print "<table border width=100%>\n";
print "<tr $tb> <td><b><a href='edit_recs.cgi?index=$in{'index'}&view=$in{'view'}&type=$in{'type'}&sort=1'>",$in{'type'} eq "PTR" ? $text{'recs_addr'} : $text{'recs_name'}, "</b></td> ",$in{'type'} eq "ALL" ? "<td><b>$text{'recs_type'}</b></td>" : "", "<td><b>$text{'recs_ttl'}</b></td>\n";
@hmap = @{$hmap{$in{'type'}}};
foreach $h (@hmap) {
	print "<td><b><a href='edit_recs.cgi?index=$in{'index'}&view=$in{'view'}&type=$in{'type'}&sort=2'>$h</a></b></td>\n";
	}
if ($in{'type'} eq "ALL" || $is_extra{$in{'type'}}) {
	print "<td>$text{'recs_vals'}</td>\n";
	}
if ($config{'allow_comments'} && $in{'type'} ne "WKS") {
	print "<td width=50%><b>$text{'recs_comment'}</b></td>\n";
	}
print "</tr>\n";
for($i=0; $i<@_; $i++) {
	$r = $_[$i];
	if ($in{'type'} eq "PTR") {
		$name = &ip6int_to_net(&arpa_to_ip($r->{'name'}));
		}
	elsif ($in{'type'} eq "SRV") {
		$name = $r->{'name'};
		$name =~ s/^_//;
		$name =~ s/\._/\./;
		}
	else {
		$name = $r->{'name'};
		}
	$name = &html_escape($name);
	if (!$access{'ro'} && $type eq 'master') {
		print "<tr $cb> <td><a href=\"edit_record.cgi?index=",
		      "$in{'index'}&type=$in{'type'}&num=$r->{'num'}&",
		      "sort=$in{'sort'}&view=$in{'view'}\">$name</a></td>\n";
		}
	else {
		print "<tr $cb> <td>$name</td>\n";
		}
	if ($in{'type'} eq 'ALL') {
		print "<td>$r->{'type'}</td>\n";
		}
	if ($r->{'ttl'} =~ /(\d+)([SMHDW]?)/i) {
		$r->{'ttl'} =~ s/S//i;
		if ($r->{'ttl'} =~ s/M//i) { $r->{'ttl'} *= 60; }
		if ($r->{'ttl'} =~ s/H//i) { $r->{'ttl'} *= 3600; }
		if ($r->{'ttl'} =~ s/D//i) { $r->{'ttl'} *= 86400; }
		if ($r->{'ttl'} =~ s/W//i) { $r->{'ttl'} *= 604800; }
		}
	print "<td>",$r->{'ttl'} ? &html_escape($r->{'ttl'}) : $text{'default'},"</td>\n";
	for($j=0; $j<@hmap; $j++) {
		local $v;
		if ($in{'type'} eq "RP" && $j == 0) {
			$v .= &convert_illegal(
				&dotted_to_email($r->{'values'}->[$j]));
			}
		elsif ($in{'type'} eq "WKS" && $j == @hmap-1) {
			print "<td>";
			for($k=$j; $r->{'values'}->[$k]; $k++) {
				$v .= &convert_illegal($r->{'values'}->[$k]);
				$v .= ' ';
				}
			print "</td>\n", 
			}
		elsif ($in{'type'} eq "LOC") {
			$v = &convert_illegal(join(" ", @{$r->{'values'}}));
			}
		elsif ($in{'type'} eq "KEY" && $j == 3) {
			$v = substr($r->{'values'}->[$j], 0, 20)."...";
			}
		else {
			$v = &convert_illegal($r->{'values'}->[$j]);
			}
		print "<td>$v</td>\n";
		}
	if ($in{'type'} eq "ALL" || $is_extra{$in{'type'}}) {
		print "<td>",join(" ", @{$r->{'values'}}),"</td>\n";
		}
	if ($config{'allow_comments'} && $in{'type'} ne "WKS") {
		print "<td>",$r->{'comment'} ? &html_escape($r->{'comment'})
					     : "&nbsp;","</td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
}

