/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef BOOKMARK_H
#define BOOKMARK_H

#include <QString>

/**
* Structure storing information about a bookmark.
*/
class Bookmark
{
public:
    /**
    * Default constructor.
    */
    Bookmark();

    /**
    * Constructor.
    */
    Bookmark( const QString& serverName, const QString& serverUuid, const QString& url,
        const QString& login, const QString& password );

    /**
    * Destructor.
    */
    ~Bookmark();

public:
    /**
    * Return the name of the server.
    */
    const QString& serverName() const { return m_serverName; }

    /**
    * Return the unique identifier of the server.
    */
    const QString& serverUuid() const { return m_serverUuid; }

    /**
    * Return the URL of the server.
    */
    const QString& url() const { return m_url; }

    /**
    * Return the login of the user.
    */
    const QString& login() const { return m_login; }

    /**
    * Return the password of the user.
    */
    const QString& password() const { return m_password; }

private:
    QString m_serverName;
    QString m_serverUuid;

    QString m_url;
    QString m_login;
    QString m_password;
};

#endif
