/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "treeviewhelper.h"

#include <QTreeView>
#include <QHeaderView>

#include "rdb/tableitemmodel.h"

QMap<int, int> TreeViewHelper::readColumnWidths( QTreeView* view )
{
    QMap<int, int> widths;

    int count = view->model()->columnCount();
    if ( view->header()->stretchLastSection() )
        count--;

    for ( int i = 0; i < count; i++ ) {
        int column = view->model()->headerData( i, Qt::Horizontal, RDB::TableItemModel::ColumnRole ).toInt();
        int width = view->columnWidth( i );
        widths.insert( column, width );
    }

    return widths;
}

void TreeViewHelper::applyColumnWidths( QTreeView* view, const QMap<int, int>& widths )
{
    for ( int i = 0; i < view->model()->columnCount(); i++ ) {
        int column = view->model()->headerData( i, Qt::Horizontal, RDB::TableItemModel::ColumnRole ).toInt();
        int width = widths.value( column, 100 );
        view->setColumnWidth( i, width );
    }

    view->header()->setMovable( false );
}

QList<int> TreeViewHelper::readExpandedNodes( QTreeView* view )
{
    QList<int> nodes;

    for ( int i = 0; i < view->model()->rowCount(); i++ ) {
        QModelIndex index = view->model()->index( i, 0 );
        if ( view->isExpanded( index ) )
            nodes.append( view->model()->data( index, RDB::TableItemModel::RowIdRole ).toInt() );
    }

    return nodes;
}

void TreeViewHelper::applyExpandedNodes( QTreeView* view, const QList<int>& nodes )
{
    for ( int i = 0; i < view->model()->rowCount(); i++ ) {
        QModelIndex index = view->model()->index( i, 0 );
        int id = view->model()->data( index, RDB::TableItemModel::RowIdRole ).toInt();
        if ( nodes.contains( id ) )
            view->setExpanded( index, true );
    }
}
