/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef CONNECTIONINFO_H
#define CONNECTIONINFO_H

#include "datarows.h"

/**
* Structure storing information about a connection to the WebIssues server.
*/
class ConnectionInfo
{
public:
    /**
    * Constructor.
    */
    ConnectionInfo( const QString& serverName, const QString& serverUuid, int userId, Access access );

    /**
    * Destructor.
    */
    ~ConnectionInfo();

public:
    /**
    * Return the name of the server.
    */
    const QString& serverName() const { return m_serverName; }

    /**
    * Return the unique identifier of the server.
    */
    const QString& serverUuid() const { return m_serverUuid; }

    /**
    * Return the identifier of the logged in user.
    */
    int userId() const { return m_userId; }

    /**
    * Return the access level of the logged in user.
    */
    Access access() const { return m_access; }

private:
    QString m_serverName;
    QString m_serverUuid;

    int m_userId;
    Access m_access;
};

#endif
