/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "valueeditorfactory.h"

#include "definitioninfo.h"
#include "valueeditors.h"

AbstractValueEditor* ValueEditorFactory::createValueEditor( const DefinitionInfo& info, int projectId,
                                                       QObject* parent, QWidget* parentWidget )
{
    switch ( info.type() ) {
        case DefinitionInfo::Text:
            return new TextValueEditor( info, parent, parentWidget );
        case DefinitionInfo::Enum:
            return new EnumValueEditor( info, parent, parentWidget );
        case DefinitionInfo::Numeric:
            return new NumericValueEditor( info, parent, parentWidget );
        case DefinitionInfo::DateTime:
            return new DateTimeValueEditor( info, parent, parentWidget );
        case DefinitionInfo::User:
            return new UserValueEditor( info, projectId, parent, parentWidget );
        default:
            return NULL;
    }
}
