/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSystemTrayIcon>

#include "xmlui/client.h"
#include "data/bookmark.h"

namespace WebIssues
{

class StartPage;
class ProjectsView;
class LoginBatch;
class StatusBar;

/**
* The main window of the application.
*
* When connected to the server, the window embeds the projects view,
* adds its actions to the menu and toolbar and handles its signals.
*
* If the tray icon is disabled, closing this window quits the application.
* If it's enabled, the window is hidden.
*/
class MainWindow : public QMainWindow, public XmlUi::Client
{
    Q_OBJECT
public:
    /**
    * Constructor.
    */
    MainWindow();

    /**
    * Destructor.
    */
    ~MainWindow();

public:
    /**
    * Restore connection to the last server.
    */
    void reconnect();

public: // overrides
    QMenu* createPopupMenu();

    StatusBar* statusBar() { return (StatusBar*)QMainWindow::statusBar(); }

protected: // overrides
    void closeEvent( QCloseEvent* e );

private slots:
    void quit();
    void newConnection();
    void closeConnection();
    void connectionInfo();

    void configure();
    void settingsChanged();

    void openConnection( const Bookmark& bookmark );
    void editConnection( const Bookmark& bookmark );

    void loginCompleted( bool successful );
    void abortLogin();

    void trayIconActivated( QSystemTrayIcon::ActivationReason reason );

    void captionChanged( const QString& caption );

    void builderReset();

private:
    void showLoginDialog( const Bookmark& bookmark, bool editable );

    void initializeView();
    void closeView();

    void showStartPage();

private:
    XmlUi::Builder* m_builder;

    StartPage* m_startPage;

    ProjectsView* m_view;

    QSystemTrayIcon* m_trayIcon;

    LoginBatch* m_batch;

    Bookmark m_bookmark;
};

}

#endif
