import os
import pygtk
import gtk
import gtk.glade
import gnome
import gnome.ui
import gconf
import gettext
import pwd
from gettext import gettext as _
from os import getenv
from commands import getoutput

name = "webboard"
version = "0.2.2.1"
image_dir = "/usr/share/pixmaps"
data_dir = "/usr/share/" + name
authors = ["Sebastian Heinlein <sebastian.heinlein@web.de>",
            "Olivier Le Thanh Duong <olivier@lethanh.be>"]
documenters = ["Sebastian Heinlein <sebastian.heinlein@web.de>"]

def find_glade_file(glade):
    if os.path.isfile(os.path.join("data/", glade)):
        print "Using glade dev file"
        return os.path.join("data/", glade)
    else:
        return os.path.join(data_dir, glade)

def about_info(self):
    about = gnome.ui.About("WebBoard",version,"GPL",\
                           _("Publish text notes and source code on a"\
                             " pastebin server for collaborative debugging"),
                            authors,
                            documenters,
                             _("translator_credits") ,self.logo_pixbuf)
    about.show()

SERVER_KEY = "/apps/webboard/pastebin"
USER_KEY = "/apps/webboard/user"

class WebBoardConfig:
    def __init__(self):
        # setup the preferences glade interface
        self.glade = gtk.glade.XML(find_glade_file("wbconfig.glade"))
        self.glade.signal_autoconnect(self)
        self.dialog = self.glade.get_widget("dialog_preferences")
        self.entry = self.glade.get_widget("entry_url")
        self.entry.connect('changed', self.entry_changed_callback)
        self.user_entry = self.glade.get_widget("entry_user")
        self.user_entry.connect('changed', self.user_entry_changed_callback)
        self.close_button = self.glade.get_widget("button_close")
        self.close_button.connect("clicked", self.on_button_close_clicked)
        # setup gconf
        self.gconf = gconf.client_get_default()
        self.gconf.add_dir("/apps/webboard", gconf.CLIENT_PRELOAD_NONE)
        self.gconf.notify_add(SERVER_KEY, self.pastebin_changed, self.entry)
        self.gconf.notify_add(USER_KEY, self.user_changed, self.user_entry)

        self.notifiers=[]

        self.pastebin = self.gconf.get_string(SERVER_KEY)
        if not self.pastebin:
            self.set_pastebin("paste.debian.net")

        self.user = self.gconf.get_string(USER_KEY)
        if not self.user:
            # guess a user name
            self.set_user(self.guess_user())

    def set_pastebin(self, value):
            self.pastebin = value
            self.gconf.set_string(SERVER_KEY, value)

    def set_user(self, value):
            self.user = value
            self.gconf.set_string(USER_KEY, value)

    def remove_notifier(self, func):
        self.notifiers.remove(func)

    def add_notifier(self, func):
        self.notifiers.append(func)

    def user_changed(self, client, cnxn_id, entry, widget):
        if entry.value.type == gconf.VALUE_STRING:
            string = entry.value.to_string()
            if widget.get_chars(0,-1) != string:
                widget.set_text(string)
            self.user = string

    def pastebin_changed(self, client, cnxn_id, entry, widget):
        if entry.value.type == gconf.VALUE_STRING:
            string = entry.value.to_string()
            if widget.get_chars(0,-1) != string:
                widget.set_text(string)
            self.pastebin = string
        #print self.notifiers
        for func in self.notifiers:
            if func is not None:
                func()

    def guess_user(self):
        "Guest the user name"
        full = pwd.getpwuid(os.getuid())[4].split(",")[0]
        if len(full) > 0:
            return full
        else:
            return pwd.getpwuid(os.getuid())[0]

    def preferences(self, *args):
        self.entry.set_sensitive(self.gconf.key_is_writable(SERVER_KEY))
        self.entry.set_text(self.gconf.get_string(SERVER_KEY))
        self.user_entry.set_sensitive(self.gconf.key_is_writable(USER_KEY))
        self.user_entry.set_text(self.gconf.get_string(USER_KEY))
        self.dialog.show()

    def user_entry_changed_callback(self, entry, *args):
        s = self.user_entry.get_chars(0, -1)
        if s != self.pastebin:
            self.gconf.set_string(USER_KEY, s)

    def entry_changed_callback(self, entry, *args):
        s = self.entry.get_chars(0, -1)
        if s != self.user:
            self.gconf.set_string(SERVER_KEY, s)

    def on_button_close_clicked(self, widget, *args):
        self.dialog.hide()

    def on_dialog_preferences_delete_event(self, widget, *args):
        self.dialog.hide()
        return True
