#ifndef FLOATOBJ_H
#define FLOATOBJ_H

#include "linkablemapobj.h"

/////////////////////////////////////////////////////////////////////////////
class FloatObj:public LinkableMapObj {
public:
    FloatObj ();
    FloatObj (QCanvas*);
    FloatObj (QCanvas*, LinkableMapObj* parent);
    ~FloatObj ();
    virtual void init ();
    virtual void copy (FloatObj*);
	virtual bool load (const QString&)=0;
	virtual void setRelPos();				// set relPos to current parentPos
	virtual void setRelPos(const QPoint&);	
	virtual void setZ(const int&);		// set zPlane
	virtual int z();
	virtual void setUseOrientation (const bool &);
	virtual void setFloatExport (const bool &);
	virtual bool getFloatExport ();

	virtual void move (double,double);
	virtual void move (QPoint);

	virtual void reposition();
											
	virtual QRect getTotalBBox();			// return BBox including childs			
	virtual QRect getBBoxSizeWithChilds();	// return size of BBox including childs  

	virtual QString saveToDir(const QString &,const QString&)=0;
	virtual void resetSaveCounter()=0;

	virtual void select();
	virtual void unselect();

protected:
	QPoint relPos;
	bool useOrientation;		
	bool floatExport;
	int zPlane;
};

#endif
