#ifndef FLOATIMAGEOBJ_H
#define FLOATIMAGEOBJ_H

#include "floatobj.h"

/////////////////////////////////////////////////////////////////////////////
class FloatImageObj:public FloatObj {
public:
    FloatImageObj ();
    FloatImageObj (QCanvas*);
    FloatImageObj (QCanvas*, LinkableMapObj* parent);
    ~FloatImageObj ();
    virtual void init ();
    virtual void copy (FloatImageObj*);
	virtual void setZ (const int&);
	virtual int z();

	virtual void load (const QPixmap &);
	virtual bool load (const QString &);
	virtual void save (const QString &, const char *);
	virtual void setOriginalFilename(const QString &);
	virtual QString getOriginalFilename();
    virtual void setVisibility(bool);	    // set vis. for w
    virtual void move (double x,double y);
    virtual void move (QPoint);
	virtual void positionBBox();
	virtual void calcBBoxSize();
	virtual QRect getTotalBBox();			// return BBox including childs			
	virtual QRect getBBoxSizeWithChilds();	// return size of BBox including childs  
	virtual void calcBBoxSizeWithChilds();	// calc size of  BBox including childs recursivly
	virtual QString saveToDir(const QString &,const QString&);
	virtual void resetSaveCounter();
	virtual QString getSelectString();


protected:
	ImageObj *icon;
	bool saveInMap;
	static int counter;			// numerate the files during saveToDir
	QString filetype;
	QString filename;
	QString originalFilename;
};

#endif
