#ifndef MAPOBJ_H
#define MAPOBJ_H

#include <QGraphicsScene>
#include <QGraphicsItem>
#include <iostream>

#include "misc.h"

using namespace std;

#define Z_BBOX      0
#define Z_XLINK    10
#define Z_LINK     20
#define Z_FRAME    50
#define Z_SELBOX   60
#define Z_FLOATIMG 65
#define Z_ICON     80
#define Z_TEXT    100

/*! \brief Base class for all objects visible on a map
*/

class MapObj:public xmlObj {
public:
    MapObj ();
    MapObj (QGraphicsScene*);
    MapObj (MapObj*);
    virtual ~MapObj ();
    virtual void init ();
    virtual void copy (MapObj*);
	virtual QGraphicsScene* getScene();
    virtual qreal x();
    virtual qreal y();
	virtual qreal width();
	virtual qreal height();
	virtual QPointF getAbsPos();
	virtual QString getPos();					// Return position as string (x,y)
    virtual void move (double x,double y);      // move to absolute Position
    virtual void move (QPointF p);
    virtual void moveBy (double x,double y);    // move to relative Position
    virtual bool inBox(const QPointF&);			// Check if Point is within clickbox
    virtual QRectF getBBox();					// returns bounding box
    virtual QRectF addBBox(QRectF,QRectF);			// returns bbox which includes both boxes
    virtual QSizeF getSize();					// returns size of bounding box
    virtual bool isVisibleObj();
    virtual void setVisibility(bool);
    virtual void positionBBox()=0;       
	virtual void calcBBoxSize()=0;
	virtual void animate();						// called by timer for animated objects
protected:  
    QGraphicsScene* scene;
    QRectF bbox;									// bounding box of MO itself
	QRectF clickBox;								// area where mouseclicks are found
    QPointF absPos;							    // Position on canvas
    bool visible;
};

#endif
