/*---------------------------------------------------------------------------*\

	FILE....: DIGITS.H
	TYPE....: C++ Module
	AUTHOR..: David Rowe
	DATE....: 29/7/98

	Digit collection module for VPB API.


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VTDIGITS_H__
#define __VTDIGITS_H__

// Initialises the digits module.
void digits_open(unsigned short numch);

// Releases the digits module.
void digits_close();

// Called by the MMQ when DSP detects a digits event.  Places the digit in the
// internal digit buffer, then adds this digit to the user buffer if active.
void digits_new_digit(int h, unsigned short digit);

// Called periodically from MMQ to determine if any time outs have occurred
// while processing the async version of get digits.
void digits_check_timers();

// Translates the terminate code to a string for debug purposes.
const char *digits_term(int data);

#endif	// __VTDIGITS_H__
