/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rfb.Exception;
import rfb.PixelFormat;

public class PixelBuffer {
    public byte[] data;
    protected PixelFormat format;
    protected int width_;
    protected int height_;

    public void setPF(PixelFormat pixelFormat) {
        if (pixelFormat.bpp != 8) {
            throw new Exception("Internal error: bpp must be 8 in PixelBuffer");
        }
        this.format = pixelFormat;
    }

    public PixelFormat getPF() {
        return this.format;
    }

    public final int width() {
        return this.width_;
    }

    public final int height() {
        return this.height_;
    }

    public final int area() {
        return this.width_ * this.height_;
    }

    public int getStride() {
        return this.width_;
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getPF().bpp / 8;
        int n7 = n6 * this.getStride();
        int n8 = n2;
        while (n8 < n2 + n4) {
            int n9 = n;
            while (n9 < n + n3) {
                this.data[n8 * n7 + n9] = (byte)n5;
                ++n9;
            }
            ++n8;
        }
    }

    public void imageRect(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6 = this.getPF().bpp / 8;
        int n7 = n6 * this.getStride();
        int n8 = 0;
        while (n8 < n4) {
            System.arraycopy(byArray, n5 + n8 * n3, this.data, (n2 + n8) * n7 + n, n3);
            ++n8;
        }
    }

    public void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + n2 * this.getStride();
        int n8 = n5 + n6 * this.getStride();
        int n9 = this.getStride();
        if (n2 > n6) {
            n8 += (n4 - 1) * n9;
            n7 += (n4 - 1) * n9;
            n9 = -n9;
        }
        int n10 = n7 + n4 * n9;
        while (n7 != n10) {
            System.arraycopy(this.data, n8, this.data, n7, n3);
            n8 += n9;
            n7 += n9;
        }
    }

    public void maskRect(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = (n3 + 7) / 8;
        int n6 = this.getStride();
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n2 + n7;
            if (n8 >= 0 && n8 < this.height_) {
                int n9 = 0;
                while (n9 < n3) {
                    int n10;
                    int n11;
                    int n12 = n + n9;
                    if (n12 >= 0 && n12 < this.width_ && (byArray2[n11 = n7 * n5 + n9 / 8] & 1 << (n10 = 7 - n9 % 8)) != 0) {
                        this.data[n8 * n6 + n12] = byArray[n7 * n3 + n9];
                    }
                    ++n9;
                }
            }
            ++n7;
        }
    }

    public PixelBuffer() {
        this.setPF(new PixelFormat());
    }
}

