/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/


#include <vector>
#include <iostream>
#include <string>
#include <set>
#include <map>
/* -- */
#include <QObject>
/* -- */
#include "parser/Definition.hpp"
/* -- */
using namespace std;

map<string, map<string, bool > > Definition::_Entity_names_and_Event_names;
map<string, set<string> >        Definition::_Event_names_and_types;

Definition::Definition(){
    _event_name.erase();
}

Definition::Definition(const string& eventname){
    _event_name = eventname;
}

void Definition::store(const string &name, const string &type){
    _fields.push_back(Field(name, type));
}

void Definition::print() const{
    cout << _event_name << endl;

    const unsigned int field_size = _fields.size();
    for(unsigned int i = 0 ; i < field_size ; i ++){
	cout << " " << _fields[i]._name << " " << _fields[i]._type << endl;
    }
    cout << "______" << endl;
}

string Definition::print_string() const{
    string definition = _event_name;

    const unsigned int field_size = _fields.size();
    for(unsigned int i = 0 ; i < field_size ; i ++){
	definition += "\n";
        definition += _fields[i]._name;
        definition += " ";
        definition += _fields[i]._type;
    }
    definition += "\n";
    return definition;
}

const vector<Field> &Definition::get_fields() const{
    return _fields;
}

string Definition::get_event_name() const{
    return _event_name;
}

void Definition::init_definitions(const string &format){
    if(format == "Paje") {
        map<string, bool> map_temp;

        map_temp.insert(pair<string ,bool>("Name", false));
        map_temp.insert(pair<string ,bool>("Alias", false));
        map_temp.insert(pair<string ,bool>("ContainerType", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineContainerType", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineEventType", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineStateType", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineVariableType", map_temp));

        map_temp.erase("ContainerType");
        map_temp.insert(pair<string ,bool>("EntityType", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineEntityValue", map_temp));

        map_temp.erase("EntityType");
        map_temp.insert(pair<string ,bool>("Time", false));
        map_temp.insert(pair<string ,bool>("Type", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDestroyContainer", map_temp));

        map_temp.insert(pair<string ,bool>("Container", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeCreateContainer", map_temp));

        map_temp.erase("Container");
        map_temp.erase("Time");
        map_temp.erase("Type");
        map_temp.insert(pair<string ,bool>("ContainerType", false));
        map_temp.insert(pair<string ,bool>("SourceContainerType", false));
        map_temp.insert(pair<string ,bool>("DestContainerType", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeDefineLinkType", map_temp));

        map_temp.clear();
        map_temp.insert(pair<string ,bool>("Time", false));
        map_temp.insert(pair<string ,bool>("Type", false));
        map_temp.insert(pair<string ,bool>("Container", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajePopState", map_temp));

        map_temp.insert(pair<string ,bool>("Value", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeSetState", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajePushState", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeNewEvent", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeSetVariable", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeSubVariable", map_temp));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeAddVariable", map_temp));

        map_temp.insert(pair<string ,bool>("Key", false));
        map_temp.insert(pair<string ,bool>("SourceContainer", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeStartLink", map_temp));

        map_temp.erase("SourceContainer");
        map_temp.insert(pair<string ,bool>("DestContainer", false));
        _Entity_names_and_Event_names.insert(pair<string ,map<string, bool> >("PajeEndLink", map_temp));

        // Event names and types
        set<string> set_temp;

        set_temp.insert("int");
        set_temp.insert("string");
        _Event_names_and_types.insert(pair<string ,set<string> >("Name", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("Alias", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("ContainerType", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("Type", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("Container", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("SourceContainerType", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("EntityType", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("SourceContainer", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("DestContainer", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("DestContainerType", set_temp));
        _Event_names_and_types.insert(pair<string ,set<string> >("Key", set_temp));
        set_temp.insert("double");
        _Event_names_and_types.insert(pair<string ,set<string> >("Value", set_temp));
        set_temp.clear();
        set_temp.insert("date");
        _Event_names_and_types.insert(pair<string ,set<string> >("Time", set_temp));
    }
    else {
        cout << QObject::tr("The format ").toStdString() << format << QObject::tr(" is unknown").toStdString() << endl;
    }
}


bool Definition::check_definition() const{
const unsigned int number_of_fields = _fields.size();

    if(Definition::_Entity_names_and_Event_names.find(_event_name) == Definition::_Entity_names_and_Event_names.end()) {
        // Unknown event
        return false;
    }
    else {
        map<string, bool> temp = Definition::_Entity_names_and_Event_names[_event_name];

        for(unsigned int i = 0 ; i < number_of_fields ; i ++){
            // We check if we have the fields
            if(temp.find(_fields[i]._name) != temp.end()) {
                // We check the type
                if(Definition::_Event_names_and_types[_fields[i]._name].find(_fields[i]._type) != Definition::_Event_names_and_types[_fields[i]._name].end()) {
                    temp[_fields[i]._name] = true;
                }
                // The both are equals
                if(_fields[i]._name == "Alias"){
                    temp["Name"] = true;
                }
                if(_fields[i]._name == "Name"){
                    temp["Alias"] = true;
                }
            }
        }
        // We check if we have all the required fields
        for(map<string, bool>::const_iterator i = temp.begin();
            i != temp.end();
            i ++){
           if((*i).second == false){
               return false;
            }
        }
        return true;
    }
}
