AC_DEFUN([VV_WITH_NETBEANS_PROFILER_ZIP],
[
  AC_MSG_CHECKING(for a NetBeans profiler zip)
  AC_ARG_WITH([netbeans-profiler-zip],
              [AS_HELP_STRING(--with-netbeans-profiler-zip,specify the location of the NetBeans profiler zip)],
  [
    ALT_NETBEANS_PROFILER_ZIP=${withval}
  ],
  [ 
    ALT_NETBEANS_PROFILER_ZIP="not specified"
  ])
  AC_MSG_RESULT(${ALT_NETBEANS_PROFILER_ZIP})
  AM_CONDITIONAL(USE_ALT_NETBEANS_PROFILER_ZIP, test "x$ALT_NETBEANS_PROFILER_ZIP" != "xnot specified")
  AC_SUBST(ALT_NETBEANS_PROFILER_ZIP)
])

AC_DEFUN([VV_WITH_VISUALVM_ZIP],
[
  AC_MSG_CHECKING(for a VisualVM zip)
  AC_ARG_WITH([visualvm-zip],
              [AS_HELP_STRING(--with-visualvm-zip,specify the location of the VisualVM zip)],
  [
    ALT_VISUALVM_ZIP=${withval}
  ],
  [ 
    ALT_VISUALVM_ZIP="not specified"
  ])
  AC_MSG_RESULT(${ALT_VISUALVM_ZIP})
  AM_CONDITIONAL(USE_ALT_VISUALVM_ZIP, test "x$ALT_VISUALVM_ZIP" != "xnot specified")
  AC_SUBST(ALT_VISUALVM_ZIP)
])

AC_DEFUN([IT_CHECK_FOR_JDK],
[
  AC_MSG_CHECKING([for a JDK home directory])
  AC_ARG_WITH([jdk-home],
	      [AS_HELP_STRING([--with-jdk-home],
                              [jdk home directory \
                               (default is first predefined JDK found)])],
              [
                if test "x${withval}" = xyes
                then
                  SYSTEM_JDK_DIR=
                elif test "x${withval}" = xno
                then
	          SYSTEM_JDK_DIR=
	        else
                  SYSTEM_JDK_DIR=${withval}
                fi
              ],
              [
	        SYSTEM_JDK_DIR=
              ])
  if test -z "${SYSTEM_JDK_DIR}"; then
    for dir in /usr/lib/jvm/java-openjdk /usr/lib/jvm/icedtea6 \
    	       /usr/lib/jvm/java-6-openjdk /usr/lib/jvm/openjdk \
	       /usr/lib/jvm/java-icedtea ; do
       if test -d $dir; then
         SYSTEM_JDK_DIR=$dir
	 break
       fi
    done
  fi
  AC_MSG_RESULT(${SYSTEM_JDK_DIR})
  if ! test -d "${SYSTEM_JDK_DIR}"; then
    AC_MSG_ERROR("A JDK JDK home directory could not be found.")
  fi
  AC_SUBST(SYSTEM_JDK_DIR)
])

AC_DEFUN([IT_FIND_TOOL],
[AC_PATH_TOOL([$1],[$2])
 if test x"$$1" = x ; then
   AC_MSG_ERROR([$2 program not found in PATH])
 fi
 AC_SUBST([$1])
])

AC_DEFUN([VV_SET_ARCH_SETTINGS],
[
  AC_REQUIRE([AC_CANONICAL_HOST])
  case "${host_cpu}" in
    x86_64)
      ARCHFLAG="-m64"
      ;;
    i?86)
      ARCHFLAG="-m32"
      ;;
    powerpc)
      ARCHFLAG="-m32"
       ;;
    powerpc64)
      ARCHFLAG="-m64"
       ;;
    sparc)
      ARCHFLAG="-m32"
       ;;
    sparc64)
      ARCHFLAG="-m64"
       ;;
    s390)
      ARCHFLAG="-m31"
       ;;
    s390x)
      ARCHFLAG="-m64"
       ;;
  esac
  AC_SUBST(ARCHFLAG)
])
