/*
 * Copyright 2007-2008 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */


package net.java.visualvm.modules.glassfish.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class TransactionsPanel extends javax.swing.JPanel implements Observer {
    private final static class SimulationModel extends Model {
        Random rnd = new Random();
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                while(true) {
                    setChanged();
                    notifyObservers();
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {}
                }
            }
        };

        public SimulationModel() {
            new Thread(updater).start();
        }
        
        @Override
        public int getCommitsPercent() {
            return rnd.nextInt(100);
        }

        @Override
        public long getActive() {
            return rnd.nextInt(200);
        }
    }
    
    private Model transactionsStatsModel;
    private Chart chart;
    
    /** Creates new form ConnectionQueuePanel */
    public TransactionsPanel() {
//        transactionsStatsModel = new SimulationModel();
//        setModel(transactionsStatsModel);
        initComponents();
        initComponents2();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelCommits = new javax.swing.JLabel();
        commits = new com.sun.tools.visualvm.core.ui.components.LevelIndicator();
        jSeparator1 = new javax.swing.JSeparator();
        chartLegend = new javax.swing.JPanel();
        chartPanel = new javax.swing.JPanel();
        labelRollbacks = new javax.swing.JLabel();
        rollbacks = new com.sun.tools.visualvm.core.ui.components.LevelIndicator();
        jLabel1 = new javax.swing.JLabel();

        setBackground(java.awt.Color.white);

        labelCommits.setLabelFor(commits);
        labelCommits.setText(org.openide.util.NbBundle.getMessage(TransactionsPanel.class, "TransactionsPanel.labelCommits.text")); // NOI18N

        commits.setAutoRepaint(false);
        commits.setFollowPeak(true);
        commits.setMaximumColor(new java.awt.Color(0, 255, 0));
        commits.setMinimumColor(new java.awt.Color(255, 0, 0));

        javax.swing.GroupLayout commitsLayout = new javax.swing.GroupLayout(commits);
        commits.setLayout(commitsLayout);
        commitsLayout.setHorizontalGroup(
            commitsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 204, Short.MAX_VALUE)
        );
        commitsLayout.setVerticalGroup(
            commitsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );

        chartLegend.setOpaque(false);
        chartLegend.setLayout(new java.awt.BorderLayout());

        chartPanel.setOpaque(false);
        chartPanel.setLayout(new java.awt.BorderLayout());

        labelRollbacks.setLabelFor(commits);
        labelRollbacks.setText(org.openide.util.NbBundle.getMessage(TransactionsPanel.class, "TransactionsPanel.labelRollbacks.text")); // NOI18N

        rollbacks.setAutoRepaint(false);
        rollbacks.setFollowPeak(true);

        javax.swing.GroupLayout rollbacksLayout = new javax.swing.GroupLayout(rollbacks);
        rollbacks.setLayout(rollbacksLayout);
        rollbacksLayout.setHorizontalGroup(
            rollbacksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 204, Short.MAX_VALUE)
        );
        rollbacksLayout.setVerticalGroup(
            rollbacksLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );

        jLabel1.setText(org.openide.util.NbBundle.getMessage(TransactionsPanel.class, "TransactionsPanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chartPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE)
                    .addComponent(chartLegend, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(labelRollbacks)
                            .addComponent(labelCommits))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(commits, javax.swing.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
                            .addComponent(rollbacks, javax.swing.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)))
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(commits, 0, 17, Short.MAX_VALUE)
                    .addComponent(labelCommits))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(rollbacks, 0, 17, Short.MAX_VALUE)
                    .addComponent(labelRollbacks))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 174, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartLegend, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel chartLegend;
    private javax.swing.JPanel chartPanel;
    private com.sun.tools.visualvm.core.ui.components.LevelIndicator commits;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel labelCommits;
    private javax.swing.JLabel labelRollbacks;
    private com.sun.tools.visualvm.core.ui.components.LevelIndicator rollbacks;
    // End of variables declaration//GEN-END:variables

    public Model getModel() {
        return transactionsStatsModel;
    }

    public void setModel(Model model) {
        if (this.transactionsStatsModel != null) {
            this.transactionsStatsModel.deleteObserver(this);
        }
        this.transactionsStatsModel = model;
        model.addObserver(this);
    }
    
    public static abstract class Model extends GenericModel {
        public abstract int getCommitsPercent();
        public abstract long getActive();
    }

    public void update(Observable o, Object arg) {
        int commitsPerCent = transactionsStatsModel.getCommitsPercent();
        commits.setMinimum(0);
        commits.setMaximum(100);
        commits.setValue(commitsPerCent);

        rollbacks.setMinimum(0);
        rollbacks.setMaximum(100);
        rollbacks.setValue(100 - commitsPerCent);
        
        if (chart != null && chart.getChartModel() != null) {
            chart.getChartModel().addItemValues(System.currentTimeMillis(), new long[]{transactionsStatsModel.getActive()});
        }
        
        repaint();
    }
    
    private void initComponents2() {
        chart = new Chart() {

            @Override
            protected void setupModel(DynamicSynchronousXYChartModel xyChartModel) {
                xyChartModel.setupModel(new String[] { "Count" },
                                            new Color[] { Color.BLUE });
            }      
        };
        
        chartPanel.add(chart, BorderLayout.CENTER);
        chartLegend.add(chart.createBigLegend(), BorderLayout.EAST);
    }
}
