/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;


/**
 *
 * @author Jiri Sedlacek
 */
public interface SynchronousXYChartModel {
    //~ Methods ------------------------------------------------------------------------------------------------------------------

    public int getItemCount(); // number of collected items

    public Color getLimitYColor(); // color of limit for y value

    public long getLimitYValue(); // maximum limit for y value

    // TODO: will be moved to chart axis definition
    public long getMaxDisplayYValue(int seriesIndex); // value to be displayed at the top of the chart

    public long getMaxXValue(); // maximum (last) value on the horizontal axis (valid for all series)

    public long getMaxYValue(int seriesIndex); // maximum values on the vertical axis for one series

    // TODO: will be moved to chart axis definition
    public long getMinDisplayYValue(int seriesIndex); // value to be displayed at the bottom of the chart

    public long getMinXValue(); // minimum (first) value on the horizontal axis (valid for all series)

    public long getMinYValue(int seriesIndex); // minimum values on the vertical axis for one series

    public Color getSeriesColor(int seriesIndex); // color of data series

    public int getSeriesCount(); // number of tracked data series

    public String getSeriesName(int seriesIndex); // name of data series

    public long getXValue(int itemIndex); // x value of the item (valid for all series)

    public long getYValue(int itemIndex, int seriesIndex); // y values of the item for one series

    /**
     * Adds new ChartModel listener.
     * @param listener ChartModel listener to add
     */
    public void addChartModelListener(ChartModelListener listener);

    /**
     * Removes ChartModel listener.
     * @param listener ChartModel listener to remove
     */
    public void removeChartModelListener(ChartModelListener listener);
}
