/*
 *  $Id: VirtuosoQueryExecution.java,v 1.13 2009/06/23 09:16:59 source Exp $
 *
 *  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
 *  project.
 *
 *  Copyright (C) 1998-2008 OpenLink Software
 *
 *  This project is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; only version 2 of the License, dated June 1991.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 */

package virtuoso.jena.driver;

import java.util.*;
import java.io.*;
import java.net.*;
import java.sql.*;

import virtuoso.sql.*;

import com.hp.hpl.jena.shared.*;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.*;

import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.query.*;

import virtuoso.jdbc3.VirtuosoConnectionPoolDataSource;

public class VirtuosoQueryExecution  implements QueryExecution
{
    private QueryIterConcat output = null;
    String virt_graph = null;
    private VirtGraph graph;
    private String virt_query;

    int prefetchSize = 200;
    java.sql.Statement stmt = null;



    public VirtuosoQueryExecution (String query, VirtGraph _graph)
    {
	graph = _graph;
	virt_graph = graph.getGraphName ();
	prefetchSize = graph.getFetchSize ();

	StringTokenizer tok = new StringTokenizer(query);
	String s = "";

	while (tok.hasMoreTokens()) {
	  s = tok.nextToken().toLowerCase();
	  if (s.equals("describe") || s.equals("construct") || s.equals("ask"))
              break;
	}

	if (s.equals("describe") || s.equals("construct") || s.equals("ask"))
           virt_query = "sparql\n define output:format '_JAVA_'\n " + query;
        else
      	   virt_query = "sparql\n " + query;
    }


    public ResultSet execSelect()
    {
	ResultSet ret = null;

	try
	{

	    Connection connection = graph.getConnection();

	    stmt = connection.createStatement();
	    stmt.setFetchSize(prefetchSize);
	    java.sql.ResultSet result_set = stmt.executeQuery(virt_query);

	    ret = ViruosoResultBindingsToJenaResults (result_set);

	    stmt.close();
	    stmt = null;
	    return ret;
	}
	catch(Exception e)
	{
            throw new JenaException("Convert results are FAILED.:"+e);
	}
    }


    public com.hp.hpl.jena.query.ResultSet ViruosoResultBindingsToJenaResults (java.sql.ResultSet VirtuosoRes)
    {
	try
	{
	    ResultSetMetaData rsmd = VirtuosoRes.getMetaData();

	    while(VirtuosoRes.next())
	    {
		Binding b = new BindingMap();
		for(int i = 1; i <= rsmd.getColumnCount(); i++)
		{
		    b.add(Var.alloc(rsmd.getColumnLabel(i)), 
		       VirtGraph.Object2Node(VirtuosoRes.getObject(i)));
		}
		if (virt_graph != null && !virt_graph.equals("virt:DEFAULT"))
		    b.add(Var.alloc("graph"), Node.createURI(virt_graph));
		AddToRes (b);
	    }

	}
	catch(Exception e)
	{
            throw new JenaException("ViruosoResultBindingsToJenaResults is FAILED.:"+e);
	}

	return new ResultSetStream(null, null, output);
    }


    private void AddToRes (Binding b)
    {
	QueryIterator qIter = new QueryIterSingleton(b, null);

	if (output == null)
	  output = new QueryIterConcat(null);

	output.add(qIter);
    }


    public void setFileManager(FileManager arg)
    {
      throw new JenaException("UnsupportedMethodException");
    }


    public void setInitialBinding(QuerySolution arg)
    {
      throw new JenaException("UnsupportedMethodException");
    }

    public Dataset getDataset()
    {
      return null;
    }


    public Context getContext()
    {
      return null;
    }


    public Model execConstruct() 
    {
	return execConstruct(ModelFactory.createDefaultModel());
    }


    public Model execConstruct(Model model)
    {
	try {

	    Connection connection = graph.getConnection();

	    stmt = connection.createStatement();
	    stmt.setFetchSize(prefetchSize);
	    java.sql.ResultSet rs = stmt.executeQuery(virt_query);
	    ResultSetMetaData rsmd = rs.getMetaData();

	    while(rs.next())
	    {
	      Node s = VirtGraph.Object2Node(rs.getObject(1));
	      Node p = VirtGraph.Object2Node(rs.getObject(2));
	      Node o = VirtGraph.Object2Node(rs.getObject(3));
	      com.hp.hpl.jena.rdf.model.Statement st = ModelUtils.tripleToStatement(model, new Triple(s, p, o));
	      if (st != null)
	        model.add(st);
	    }	

	    stmt.close();
	    stmt = null;

	} catch (Exception e) {
            throw new JenaException("Convert results are FAILED.:"+e);
	}
	return model;
    }


	
    public Model execDescribe() {
	return execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model)
    {
	try {
	    Connection connection = graph.getConnection();

	    stmt = connection.createStatement();
	    stmt.setFetchSize(prefetchSize);
	    java.sql.ResultSet rs = stmt.executeQuery(virt_query);
	    ResultSetMetaData rsmd = rs.getMetaData();
	    while(rs.next())
	    {
	      Node s = VirtGraph.Object2Node(rs.getObject(1));
	      Node p = VirtGraph.Object2Node(rs.getObject(2));
	      Node o = VirtGraph.Object2Node(rs.getObject(3));

	      com.hp.hpl.jena.rdf.model.Statement st = ModelUtils.tripleToStatement(model, new Triple(s, p, o));
	      if (st != null)
	        model.add(st);
	    }	

	    stmt.close();
	    stmt = null;

	} catch (Exception e) {
            throw new JenaException("Convert results are FAILED.:"+e);
	}
	return model;
    }


    public boolean execAsk() {
        boolean ret = false;

	try {
	    Connection connection = graph.getConnection();

	    stmt = connection.createStatement();
	    java.sql.ResultSet rs = stmt.executeQuery(virt_query);
	    ResultSetMetaData rsmd = rs.getMetaData();

	    while(rs.next())
	    {
	      if (rs.getInt(1) == 1)
	        ret = true;
	    }	

	    stmt.close();
	    stmt = null;

	} catch (Exception e) {
            throw new JenaException("Convert results are FAILED.:"+e);
	}
	return ret;
    }


    public void abort() 
    {
	if (stmt != null)
	  try {
	      stmt.cancel();
	  } catch (Exception e) {}
    }


    public void close() 
    {
	if (stmt != null)
	  try {
	      stmt.cancel();
	  } catch (Exception e) {}
    }

}
