/*
   Copyright (c) 2010 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "nepomukstuff.h"

#include <KStandardDirs>
#include <KProcess>
#include <KDebug>

#include <QtCore/QByteArray>
#include <QtCore/QFile>
#include <QtCore/QChar>
#include <QtCore/QRegExp>


QString Nepomuk::storagePath()
{
    return KStandardDirs::locateLocal( "data", "nepomuk/repository/main/data/virtuosobackend" );
}


int Nepomuk::usedVirtuosoVersion()
{
    QString trx = KStandardDirs::locateLocal( "data", "nepomuk/repository/main/data/virtuosobackend/soprano-virtuoso.trx" );
    if ( trx.isEmpty() ||
         !QFile::exists( trx ) ) {
        return 0;
    }

    //
    // look for "#server_version_check ('06.00.3125')"
    // (this is just a version check I made up and could probably be improved)
    //
    QFile trxFile( trx );
    trxFile.open( QIODevice::ReadOnly );
    QByteArray buf = trxFile.read( 1000 );
    int pos = buf.indexOf( "server_version_check" );
    if ( pos >= 0 ) {
        pos += 23;
        if ( buf.count() > pos+1 &&
             QChar( buf[pos] ).isDigit() &&
             QChar( buf[pos+1] ).isDigit() ) {
            return buf.mid( pos, 2 ).toInt();
        }
    }

    return -1;
}


int Nepomuk::virtuosoBinVersion( const QString& path )
{
    static const int EXECUTE_TIMEOUT = 5000; // in seconds

    KProcess p;
    p.setOutputChannelMode( KProcess::MergedChannels );
    p << path << "--version";
    if( p.execute( EXECUTE_TIMEOUT ) < 0 )
        return -1;

    QString s = QString::fromLocal8Bit( p.readAll() );
    int pos = s.indexOf( "Version" );
    if ( pos > 0 ) {
        pos+=8;
        kDebug() << pos;
        int pos2 = s.indexOf( ".", pos );
        if ( pos2 > 0 ) {
            kDebug() << s.mid( pos, pos2-pos );
            return s.mid( pos, pos2-pos ).toInt();
        }
    }

    return -1;
}
