#!/bin/sh
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this package; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

BASEPATH=$(dirname $0)
echo $BASEPATH

# copy custom upstart X startup script
cp -v $BASEPATH/upstart-session root/etc/event.d/session

# copy sources.list specified
while read sl; do
    [ -z "$sl" ] && continue
    cp -v $sl root/etc/apt/sources.list.d
done < "$BASEPATH/SOURCES"

# mount /proc and /sys
chroot root mount -t proc  none /proc
chroot root mount -t sysfs none /sys

# run apt-get update and dist-upgrade
chroot root apt-get update
chroot root apt-get dist-upgrade -y --force-yes

# install packages
chroot root apt-get install -y --force-yes $(cat $BASEPATH/PKGS)

# copy custom xorg.conf
cp -v $BASEPATH/xorg.conf root/etc/X11/

# umount /proc and /sys
chroot root umount /sys
chroot root umount /proc

