%define name vips
%define version 7.10.4
%define release 1beta
%define default_install_prefix /usr/local

Summary: an image processing library
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: LGPL
Group: Development/Libraries
Source: http://www.vips.ecs.soton.ac.uk/vips-7.9/%{name}-%{version}.tar.gz
URL: http://www.vips.ecs.soton.ac.uk/
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{default_install_prefix}

# hmmm. fixed it into a more generic form. not sure if 
# this will break other distro's - wyu 
AutoReq: no
Provides: vips 
Requires: XFree86 ImageMagick freetype libjpeg libpng libtiff zlib 

%description
VIPS is an image processing library. It is good for very large images (ie.
larger than the amount of RAM in your machine), and for working with colour.
It includes a C++ API, complete man pages, a command-line interface, automatic
threading and an operation database. There are several user interfaces
built on top of VIPS: for example "nip".

%prep
rm -rf $RPM_BUILD_ROOT
%setup 

%build
# grr ... why do we have to set prefix by hand? if you don't do this, you get
# /usr, despite the "Prefix:" tag above
%define _prefix %{default_install_prefix}
%configure

%install
%makeinstall

# paste in the non-GPL stuff as a binary plugin
# comment this out if you don't have it :-(
# let's comment this out by default ;-) - wyu
#cp ~john/develop/transform-7.8/transform-nip/resample.plg ${RPM_BUILD_ROOT}%{_libdir}

# copy the formatted PS and HTML docs into the install area
# creating the directories are not necessary since they are 
# already created by the build process - wyu
#mkdir ${RPM_BUILD_ROOT}%{_datadir}/doc
#mkdir ${RPM_BUILD_ROOT}%{_datadir}/doc/vips
cp -r doc/html doc/ps ${RPM_BUILD_ROOT}%{_datadir}/doc/vips

%clean
rm -rf $RPM_BUILD_ROOT

%post
ldconfig

%files
%attr(-, root, root)
%doc AUTHORS THANKS README TODO COPYING ChangeLog
%{_includedir}/vips
%{_bindir}/batch_image_convert
%{_bindir}/batch_crop
%{_bindir}/batch_rubber_sheet
%{_bindir}/binfile
%{_bindir}/cooc
%{_bindir}/cooc_features
%{_bindir}/debugim
%{_bindir}/edvips
%{_bindir}/find_mosaic
%{_bindir}/glds
%{_bindir}/glds_features
%{_bindir}/header
%{_bindir}/im_LCh2Lab
%{_bindir}/im_LCh2UCS
%{_bindir}/im_Lab2LCh
%{_bindir}/im_Lab2LabQ
%{_bindir}/im_Lab2LabS
%{_bindir}/im_Lab2UCS
%{_bindir}/im_Lab2XYZ
%{_bindir}/im_Lab2XYZ_temp
%{_bindir}/im_Lab2disp
%{_bindir}/im_LabQ2Lab
%{_bindir}/im_LabQ2LabS
%{_bindir}/im_LabQ2XYZ
%{_bindir}/im_LabQ2disp
%{_bindir}/im_LabS2Lab
%{_bindir}/im_LabS2LabQ
%{_bindir}/im_UCS2LCh
%{_bindir}/im_UCS2Lab
%{_bindir}/im_UCS2XYZ
%{_bindir}/im_XYZ2Lab
%{_bindir}/im_XYZ2Lab_temp
%{_bindir}/im_XYZ2UCS
%{_bindir}/im_XYZ2Yxy
%{_bindir}/im_XYZ2disp
%{_bindir}/im_XYZ2sRGB
%{_bindir}/im_Yxy2XYZ
%{_bindir}/im_abs
%{_bindir}/im_acostra
%{_bindir}/im_add
%{_bindir}/im_addgnoise
%{_bindir}/im_affine
%{_bindir}/im_and_vec
%{_bindir}/im_andconst
%{_bindir}/im_andimage
%{_bindir}/im_asintra
%{_bindir}/im_atantra
%{_bindir}/im_avg
%{_bindir}/im_bandjoin
%{_bindir}/im_bernd
%{_bindir}/im_black
%{_bindir}/im_blend
%{_bindir}/im_c2amph
%{_bindir}/im_c2imag
%{_bindir}/im_c2ps
%{_bindir}/im_c2real
%{_bindir}/im_c2rect
%{_bindir}/im_ceil
%{_bindir}/im_circle
%{_bindir}/im_clip
%{_bindir}/im_clip2c
%{_bindir}/im_clip2cm
%{_bindir}/im_clip2d
%{_bindir}/im_clip2dcm
%{_bindir}/im_clip2f
%{_bindir}/im_clip2fmt
%{_bindir}/im_clip2i
%{_bindir}/im_clip2s
%{_bindir}/im_clip2ui
%{_bindir}/im_clip2us
%{_bindir}/im_cmulnorm
%{_bindir}/im_cntlines
%{_bindir}/im_compass
%{_bindir}/im_conv
%{_bindir}/im_conv_raw
%{_bindir}/im_convf
%{_bindir}/im_convf_raw
%{_bindir}/im_convsep
%{_bindir}/im_convsep_raw
%{_bindir}/im_convsepf
%{_bindir}/im_convsepf_raw
%{_bindir}/im_convsub
%{_bindir}/im_copy
%{_bindir}/im_copy_set
%{_bindir}/im_correl
%{_bindir}/im_costra
%{_bindir}/im_create_fmask
%{_bindir}/im_dE00_fromLab
%{_bindir}/im_dECMC_fromLab
%{_bindir}/im_dECMC_fromdisp
%{_bindir}/im_dE_fromLab
%{_bindir}/im_dE_fromXYZ
%{_bindir}/im_dE_fromdisp
%{_bindir}/im_deviate
%{_bindir}/im_dilate
%{_bindir}/im_dilate_raw
%{_bindir}/im_disp2Lab
%{_bindir}/im_disp2XYZ
%{_bindir}/im_disp_ps
%{_bindir}/im_divide
%{_bindir}/im_embed
%{_bindir}/im_eor_vec
%{_bindir}/im_eorconst
%{_bindir}/im_eorimage
%{_bindir}/im_equal
%{_bindir}/im_equal_vec
%{_bindir}/im_equalconst
%{_bindir}/im_erode
%{_bindir}/im_erode_raw
%{_bindir}/im_exp10tra
%{_bindir}/im_expntra
%{_bindir}/im_expntra_vec
%{_bindir}/im_exptra
%{_bindir}/im_extract
%{_bindir}/im_extract_area
%{_bindir}/im_extract_band
%{_bindir}/im_eye
%{_bindir}/im_falsecolour
%{_bindir}/im_fastcor
%{_bindir}/im_fav4
%{_bindir}/im_feye
%{_bindir}/im_fgrey
%{_bindir}/im_fliphor
%{_bindir}/im_flipver
%{_bindir}/im_floor
%{_bindir}/im_flt_image_freq
%{_bindir}/im_fractsurf
%{_bindir}/im_freqflt
%{_bindir}/im_fwfft
%{_bindir}/im_fzone
%{_bindir}/im_gadd
%{_bindir}/im_gammacorrect
%{_bindir}/im_gauss_dmask
%{_bindir}/im_gauss_imask
%{_bindir}/im_gaussnoise
%{_bindir}/im_gbandjoin
%{_bindir}/im_global_balance
%{_bindir}/im_global_balancef
%{_bindir}/im_gradient
%{_bindir}/im_grey
%{_bindir}/im_guess_prefix
%{_bindir}/im_header_double
%{_bindir}/im_header_int
%{_bindir}/im_header_string
%{_bindir}/im_heq
%{_bindir}/im_hist
%{_bindir}/im_histcum
%{_bindir}/im_histeq
%{_bindir}/im_histgr
%{_bindir}/im_histnD
%{_bindir}/im_histnorm
%{_bindir}/im_histplot
%{_bindir}/im_histspec
%{_bindir}/im_hsp
%{_bindir}/im_icc_ac2rc
%{_bindir}/im_icc_export
%{_bindir}/im_icc_export_depth
%{_bindir}/im_icc_import
%{_bindir}/im_icc_present
%{_bindir}/im_icc_transform
%{_bindir}/im_identity
%{_bindir}/im_identity_ushort
%{_bindir}/im_ifthenelse
%{_bindir}/im_insert
%{_bindir}/im_insert_noexpand
%{_bindir}/im_insertplace
%{_bindir}/im_invert
%{_bindir}/im_invertlut
%{_bindir}/im_invfft
%{_bindir}/im_invfftr
%{_bindir}/im_ismonotonic
%{_bindir}/im_jpeg2vips
%{_bindir}/im_lab_morph
%{_bindir}/im_less
%{_bindir}/im_less_vec
%{_bindir}/im_lessconst
%{_bindir}/im_lesseq
%{_bindir}/im_lesseq_vec
%{_bindir}/im_lesseqconst
%{_bindir}/im_lhisteq
%{_bindir}/im_lhisteq_raw
%{_bindir}/im_lindetect
%{_bindir}/im_line
%{_bindir}/im_lintra
%{_bindir}/im_lintra_vec
%{_bindir}/im_litecor
%{_bindir}/im_log10tra
%{_bindir}/im_log_dmask
%{_bindir}/im_log_imask
%{_bindir}/im_logtra
%{_bindir}/im_lrjoin
%{_bindir}/im_lrmerge
%{_bindir}/im_lrmerge1
%{_bindir}/im_lrmosaic
%{_bindir}/im_lrmosaic1
%{_bindir}/im_magick2vips
%{_bindir}/im_maplut
%{_bindir}/im_mask2vips
%{_bindir}/im_matcat
%{_bindir}/im_match_linear
%{_bindir}/im_match_linear_search
%{_bindir}/im_matinv
%{_bindir}/im_matmul
%{_bindir}/im_mattrn
%{_bindir}/im_max
%{_bindir}/im_maxpos
%{_bindir}/im_maxvalue
%{_bindir}/im_measure
%{_bindir}/im_min
%{_bindir}/im_minpos
%{_bindir}/im_more
%{_bindir}/im_more_vec
%{_bindir}/im_moreconst
%{_bindir}/im_moreeq
%{_bindir}/im_moreeq_vec
%{_bindir}/im_moreeqconst
%{_bindir}/im_mpercent
%{_bindir}/im_multiply
%{_bindir}/im_notequal
%{_bindir}/im_notequal_vec
%{_bindir}/im_notequalconst
%{_bindir}/im_or_vec
%{_bindir}/im_orconst
%{_bindir}/im_orimage
%{_bindir}/im_png2vips
%{_bindir}/im_powtra
%{_bindir}/im_powtra_vec
%{_bindir}/im_ppm2vips
%{_bindir}/im_print
%{_bindir}/im_profile
%{_bindir}/im_rank
%{_bindir}/im_rank_raw
%{_bindir}/im_read_dmask
%{_bindir}/im_recomb
%{_bindir}/im_remainder
%{_bindir}/im_remainderconst
%{_bindir}/im_remainderconst_vec
%{_bindir}/im_remosaic
%{_bindir}/im_resize_linear
%{_bindir}/im_ri2c
%{_bindir}/im_rot180
%{_bindir}/im_rot270
%{_bindir}/im_rot90
%{_bindir}/im_rotate_dmask45
%{_bindir}/im_rotate_dmask90
%{_bindir}/im_rotate_imask45
%{_bindir}/im_rotate_imask90
%{_bindir}/im_rotquad
%{_bindir}/im_sRGB2XYZ
%{_bindir}/im_scale
%{_bindir}/im_scaleps
%{_bindir}/im_sharpen
%{_bindir}/im_shiftleft
%{_bindir}/im_shiftright
%{_bindir}/im_shrink
%{_bindir}/im_sign
%{_bindir}/im_similarity
%{_bindir}/im_similarity_area
%{_bindir}/im_sintra
%{_bindir}/im_slice
%{_bindir}/im_spcor
%{_bindir}/im_stats
%{_bindir}/im_stdif
%{_bindir}/im_stdif_raw
%{_bindir}/im_stretch3
%{_bindir}/im_subsample
%{_bindir}/im_subtract
%{_bindir}/im_system
%{_bindir}/im_tantra
%{_bindir}/im_tbjoin
%{_bindir}/im_tbmerge
%{_bindir}/im_tbmerge1
%{_bindir}/im_tbmosaic
%{_bindir}/im_tbmosaic1
%{_bindir}/im_thresh
%{_bindir}/im_tiff2vips
%{_bindir}/im_tone_analyse
%{_bindir}/im_tone_build
%{_bindir}/im_tone_map
%{_bindir}/im_version
%{_bindir}/im_version_string
%{_bindir}/im_video_v4l1
%{_bindir}/im_vips2jpeg
%{_bindir}/im_vips2mask
%{_bindir}/im_vips2mimejpeg
%{_bindir}/im_vips2png
%{_bindir}/im_vips2ppm
%{_bindir}/im_vips2tiff
%{_bindir}/im_zerox
%{_bindir}/im_zone
%{_bindir}/im_zoom
%{_bindir}/light_correct
%{_bindir}/mergeup
%{_bindir}/mitsub
%{_bindir}/printlines
%{_bindir}/shrink_width
%{_bindir}/simcontr
%{_bindir}/sines
%{_bindir}/spatres
%{_bindir}/squares
%{_bindir}/vdump
%{_bindir}/vips
#%{_bindir}/vips-7.8
%{_bindir}/vips-7.10
# use pkgconfig instead
#%{_bindir}/vips-config
%{_bindir}/vips2dj
%{_libdir}/libvips.a
%{_libdir}/libvips.la
%{_libdir}/libvips.so
#%{_libdir}/libvips.so.0
#%{_libdir}/libvips.so.0.0.0
%{_libdir}/libvips.so.10
%{_libdir}/libvips.so.10.0.0
%{_libdir}/libvipsCC.a
%{_libdir}/libvipsCC.la
%{_libdir}/libvipsCC.so
#%{_libdir}/libvipsCC.so.0
#%{_libdir}/libvipsCC.so.0.0.0
%{_libdir}/libvipsCC.so.10
%{_libdir}/libvipsCC.so.10.0.0
%{_libdir}/pkgconfig/vips-7.10.pc
%{_libdir}/pkgconfig/vipsCC-7.10.pc
# commented out by default
#%{_libdir}/resample.plg
%{_mandir}/man1/batch_image_convert.1*
%{_mandir}/man1/batch_rubber_sheet.1*
%{_mandir}/man1/binfile.1*
%{_mandir}/man1/cooc.1*
%{_mandir}/man1/cooc_features.1*
%{_mandir}/man1/debugim.1*
%{_mandir}/man1/edvips.1*
%{_mandir}/man1/glds.1*
%{_mandir}/man1/glds_features.1*
%{_mandir}/man1/header.1*
%{_mandir}/man1/light_correct.1*
%{_mandir}/man1/printlines.1*
%{_mandir}/man1/simcontr.1*
%{_mandir}/man1/sines.1*
%{_mandir}/man1/squares.1*
%{_mandir}/man1/vdump.1*
%{_mandir}/man1/vips.1*
%{_mandir}/man3/IM_ARRAY.3*
%{_mandir}/man3/IM_IMAGE_ADDR.3*
%{_mandir}/man3/IM_IMAGE_N_ELEMENTS.3*
%{_mandir}/man3/IM_IMAGE_SIZEOF_ELEMENT.3*
%{_mandir}/man3/IM_IMAGE_SIZEOF_LINE.3*
%{_mandir}/man3/IM_IMAGE_SIZEOF_PEL.3*
%{_mandir}/man3/IM_MAX.3*
%{_mandir}/man3/IM_MIN.3*
%{_mandir}/man3/IM_NEW.3*
%{_mandir}/man3/IM_NUMBER.3*
%{_mandir}/man3/IM_REGION_ADDR.3*
%{_mandir}/man3/IM_REGION_LSKIP.3*
%{_mandir}/man3/IM_REGION_N_ELEMENTS.3*
%{_mandir}/man3/IM_REGION_SIZEOF_LINE.3*
%{_mandir}/man3/IM_RINT.3*
%{_mandir}/man3/error_exit.3*
%{_mandir}/man3/im_BandFmt2char.3*
%{_mandir}/man3/im_Coding2char.3*
%{_mandir}/man3/im_Compression2char.3*
%{_mandir}/man3/im_LCh2Lab.3*
%{_mandir}/man3/im_LCh2UCS.3*
%{_mandir}/man3/im_Lab2LCh.3*
%{_mandir}/man3/im_Lab2LabQ.3*
%{_mandir}/man3/im_Lab2LabS.3*
%{_mandir}/man3/im_Lab2UCS.3*
%{_mandir}/man3/im_Lab2XYZ.3*
%{_mandir}/man3/im_Lab2disp.3*
%{_mandir}/man3/im_LabQ2Lab.3*
%{_mandir}/man3/im_LabQ2LabS.3*
%{_mandir}/man3/im_LabQ2XYZ.3*
%{_mandir}/man3/im_LabQ2disp.3*
%{_mandir}/man3/im_LabQ2disp_build_table.3*
%{_mandir}/man3/im_LabQ2disp_table.3*
%{_mandir}/man3/im_LabS2Lab.3*
%{_mandir}/man3/im_LabS2LabQ.3*
%{_mandir}/man3/im_Type2char.3*
%{_mandir}/man3/im_UCS2LCh.3*
%{_mandir}/man3/im_UCS2Lab.3*
%{_mandir}/man3/im_UCS2XYZ.3*
%{_mandir}/man3/im_XYZ2Lab.3*
%{_mandir}/man3/im_XYZ2UCS.3*
%{_mandir}/man3/im_XYZ2Yxy.3*
%{_mandir}/man3/im_XYZ2disp.3*
%{_mandir}/man3/im_XYZ2sRGB.3*
%{_mandir}/man3/im_Yxy2XYZ.3*
%{_mandir}/man3/im_abs.3*
%{_mandir}/man3/im_acostra.3*
%{_mandir}/man3/im_add.3*
%{_mandir}/man3/im_add_close_callback.3*
%{_mandir}/man3/im_add_eval_callback.3*
%{_mandir}/man3/im_add_evalend_callback.3*
%{_mandir}/man3/im_addgnoise.3*
%{_mandir}/man3/im_affine.3*
%{_mandir}/man3/im_allocate_input_array.3*
%{_mandir}/man3/im_amiMSBfirst.3*
%{_mandir}/man3/im_and_vec.3*
%{_mandir}/man3/im_andconst.3*
%{_mandir}/man3/im_andimage.3*
%{_mandir}/man3/im_append_Hist.3*
%{_mandir}/man3/im_asintra.3*
%{_mandir}/man3/im_atantra.3*
%{_mandir}/man3/im_avg.3*
%{_mandir}/man3/im_bandjoin.3*
%{_mandir}/man3/im_binfile.3*
%{_mandir}/man3/im_black.3*
%{_mandir}/man3/im_blend.3*
%{_mandir}/man3/im_c2amph.3*
%{_mandir}/man3/im_c2imag.3*
%{_mandir}/man3/im_c2ps.3*
%{_mandir}/man3/im_c2real.3*
%{_mandir}/man3/im_c2rect.3*
%{_mandir}/man3/im_ceil.3*
%{_mandir}/man3/im_char2BandFmt.3*
%{_mandir}/man3/im_char2Coding.3*
%{_mandir}/man3/im_char2Compression.3*
%{_mandir}/man3/im_char2Type.3*
%{_mandir}/man3/im_circle.3*
#%{_mandir}/man3/im_clear_error_string.3*
%{_mandir}/man3/im_clip.3*
%{_mandir}/man3/im_clip2c.3*
%{_mandir}/man3/im_clip2cm.3*
%{_mandir}/man3/im_clip2d.3*
%{_mandir}/man3/im_clip2dcm.3*
%{_mandir}/man3/im_clip2f.3*
%{_mandir}/man3/im_clip2fmt.3*
%{_mandir}/man3/im_clip2i.3*
%{_mandir}/man3/im_clip2s.3*
%{_mandir}/man3/im_clip2ui.3*
%{_mandir}/man3/im_clip2us.3*
%{_mandir}/man3/im_close.3*
%{_mandir}/man3/im_cmulnorm.3*
%{_mandir}/man3/im_cntlines.3*
%{_mandir}/man3/im_col_C2Cucs.3*
%{_mandir}/man3/im_col_Ch2ab.3*
%{_mandir}/man3/im_col_Ch2hucs.3*
%{_mandir}/man3/im_col_Chucs2h.3*
%{_mandir}/man3/im_col_Cucs2C.3*
%{_mandir}/man3/im_col_L2Lucs.3*
%{_mandir}/man3/im_col_Lab2XYZ.3*
%{_mandir}/man3/im_col_Lucs2L.3*
%{_mandir}/man3/im_col_XYZ2Lab.3*
%{_mandir}/man3/im_col_XYZ2rgb.3*
%{_mandir}/man3/im_col_ab2Ch.3*
%{_mandir}/man3/im_col_dECMC.3*
%{_mandir}/man3/im_col_display.3*
%{_mandir}/man3/im_col_make_tables_RGB.3*
%{_mandir}/man3/im_col_make_tables_UCS.3*
%{_mandir}/man3/im_col_pythagoras.3*
%{_mandir}/man3/im_col_rgb2XYZ.3*
%{_mandir}/man3/im_compass.3*
%{_mandir}/man3/im_conv.3*
%{_mandir}/man3/im_conv_raw.3*
%{_mandir}/man3/im_convf.3*
%{_mandir}/man3/im_convf_raw.3*
%{_mandir}/man3/im_convsep.3*
%{_mandir}/man3/im_convsep_raw.3*
%{_mandir}/man3/im_convsepf.3*
%{_mandir}/man3/im_convsepf_raw.3*
%{_mandir}/man3/im_convsub.3*
%{_mandir}/man3/im_cooc_asm.3*
%{_mandir}/man3/im_cooc_contrast.3*
%{_mandir}/man3/im_cooc_correlation.3*
%{_mandir}/man3/im_cooc_entropy.3*
%{_mandir}/man3/im_cooc_matrix.3*
%{_mandir}/man3/im_copy.3*
%{_mandir}/man3/im_copy_set.3*
%{_mandir}/man3/im_correl.3*
%{_mandir}/man3/im_costra.3*
%{_mandir}/man3/im_cp_desc.3*
%{_mandir}/man3/im_create_dmask.3*
%{_mandir}/man3/im_create_fmask.3*
%{_mandir}/man3/im_create_imask.3*
%{_mandir}/man3/im_dE00_fromLab.3*
%{_mandir}/man3/im_dECMC_fromLab.3*
%{_mandir}/man3/im_dECMC_fromdisp.3*
%{_mandir}/man3/im_dE_fromLab.3*
%{_mandir}/man3/im_dE_fromXYZ.3*
%{_mandir}/man3/im_dE_fromdisp.3*
%{_mandir}/man3/im_debugim.3*
%{_mandir}/man3/im_demand_hint.3*
%{_mandir}/man3/im_demand_hint_array.3*
%{_mandir}/man3/im_deviate.3*
#%{_mandir}/man3/im_diagnostics.3*
%{_mandir}/man3/im_dif_std.3*
%{_mandir}/man3/im_dilate.3*
%{_mandir}/man3/im_dilate_raw.3*
%{_mandir}/man3/im_disp2Lab.3*
%{_mandir}/man3/im_disp2XYZ.3*
%{_mandir}/man3/im_disp_ps.3*
%{_mandir}/man3/im_divide.3*
%{_mandir}/man3/im_dup_dmask.3*
%{_mandir}/man3/im_dup_imask.3*
%{_mandir}/man3/im_embed.3*
%{_mandir}/man3/im_eor_vec.3*
%{_mandir}/man3/im_eorconst.3*
%{_mandir}/man3/im_eorimage.3*
%{_mandir}/man3/im_equal.3*
%{_mandir}/man3/im_equal_vec.3*
%{_mandir}/man3/im_equalconst.3*
%{_mandir}/man3/im_erode.3*
%{_mandir}/man3/im_erode_raw.3*
#%{_mandir}/man3/im_errormsg.3*
%{_mandir}/man3/im_exp10tra.3*
%{_mandir}/man3/im_expntra.3*
%{_mandir}/man3/im_expntra_vec.3*
%{_mandir}/man3/im_exptra.3*
%{_mandir}/man3/im_extract.3*
%{_mandir}/man3/im_extract_area.3*
%{_mandir}/man3/im_extract_band.3*
%{_mandir}/man3/im_eye.3*
%{_mandir}/man3/im_falsecolour.3*
%{_mandir}/man3/im_fastcor.3*
%{_mandir}/man3/im_fastline.3*
%{_mandir}/man3/im_fastlineuser.3*
%{_mandir}/man3/im_fav4.3*
%{_mandir}/man3/im_feye.3*
%{_mandir}/man3/im_fgrey.3*
%{_mandir}/man3/im_fliphor.3*
%{_mandir}/man3/im_flipver.3*
%{_mandir}/man3/im_flood.3*
%{_mandir}/man3/im_flood_blob.3*
%{_mandir}/man3/im_floor.3*
%{_mandir}/man3/im_flt_imag_freq.3*
%{_mandir}/man3/im_fractsurf.3*
%{_mandir}/man3/im_free_dmask.3*
%{_mandir}/man3/im_free_imask.3*
%{_mandir}/man3/im_freqflt.3*
%{_mandir}/man3/im_fwfft.3*
%{_mandir}/man3/im_fzone.3*
%{_mandir}/man3/im_gadd.3*
%{_mandir}/man3/im_gaddim.3*
%{_mandir}/man3/im_gammacorrect.3*
%{_mandir}/man3/im_gauss_dmask.3*
%{_mandir}/man3/im_gauss_imask.3*
%{_mandir}/man3/im_gaussnoise.3*
%{_mandir}/man3/im_gbandjoin.3*
%{_mandir}/man3/im_generate.3*
%{_mandir}/man3/im_gfadd.3*
%{_mandir}/man3/im_glds_asm.3*
%{_mandir}/man3/im_glds_contrast.3*
%{_mandir}/man3/im_glds_entropy.3*
%{_mandir}/man3/im_glds_matrix.3*
%{_mandir}/man3/im_glds_mean.3*
%{_mandir}/man3/im_global_balance.3*
%{_mandir}/man3/im_global_balance_float.3*
%{_mandir}/man3/im_gradient.3*
%{_mandir}/man3/im_grey.3*
%{_mandir}/man3/im_guess_prefix.3*
%{_mandir}/man3/im_header.3*
%{_mandir}/man3/im_header_double.3*
%{_mandir}/man3/im_header_int.3*
%{_mandir}/man3/im_header_string.3*
%{_mandir}/man3/im_heq.3*
%{_mandir}/man3/im_hist.3*
%{_mandir}/man3/im_histcum.3*
%{_mandir}/man3/im_histeq.3*
%{_mandir}/man3/im_histgr.3*
%{_mandir}/man3/im_histlin.3*
%{_mandir}/man3/im_histnD.3*
%{_mandir}/man3/im_histnorm.3*
%{_mandir}/man3/im_histplot.3*
%{_mandir}/man3/im_histspec.3*
%{_mandir}/man3/im_hsp.3*
%{_mandir}/man3/im_icc_ac2rc.3*
%{_mandir}/man3/im_icc_export.3*
%{_mandir}/man3/im_icc_export_depth.3*
%{_mandir}/man3/im_icc_import.3*
%{_mandir}/man3/im_icc_present.3*
%{_mandir}/man3/im_icc_transform.3*
%{_mandir}/man3/im_identity.3*
%{_mandir}/man3/im_identity_ushort.3*
%{_mandir}/man3/im_ifthenelse.3*
%{_mandir}/man3/im_image.3*
%{_mandir}/man3/im_image_sanity.3*
%{_mandir}/man3/im_incheck.3*
%{_mandir}/man3/im_init.3*
%{_mandir}/man3/im_initdesc.3*
%{_mandir}/man3/im_insert.3*
%{_mandir}/man3/im_insertplace.3*
%{_mandir}/man3/im_invert.3*
%{_mandir}/man3/im_invertlut.3*
%{_mandir}/man3/im_invfft.3*
%{_mandir}/man3/im_invfftr.3*
%{_mandir}/man3/im_iocheck.3*
%{_mandir}/man3/im_isMSBfirst.3*
%{_mandir}/man3/im_iscomplex.3*
%{_mandir}/man3/im_isfile.3*
%{_mandir}/man3/im_isfloat.3*
%{_mandir}/man3/im_isint.3*
%{_mandir}/man3/im_isjpeg.3*
%{_mandir}/man3/im_ispartial.3*
%{_mandir}/man3/im_ispng.3*
%{_mandir}/man3/im_isppm.3*
%{_mandir}/man3/im_istiff.3*
%{_mandir}/man3/im_istifftiled.3*
%{_mandir}/man3/im_isuint.3*
%{_mandir}/man3/im_isvips.3*
%{_mandir}/man3/im_iterate.3*
%{_mandir}/man3/im_jpeg2vips.3*
%{_mandir}/man3/im_jpeg2vips_header.3*
%{_mandir}/man3/im_lab_morph.3*
%{_mandir}/man3/im_less.3*
%{_mandir}/man3/im_less_vec.3*
%{_mandir}/man3/im_lessconst.3*
%{_mandir}/man3/im_lesseq.3*
%{_mandir}/man3/im_lesseq_vec.3*
%{_mandir}/man3/im_lesseqconst.3*
%{_mandir}/man3/im_lhisteq.3*
%{_mandir}/man3/im_lhisteq_raw.3*
%{_mandir}/man3/im_lindetect.3*
%{_mandir}/man3/im_line.3*
%{_mandir}/man3/im_lintra.3*
%{_mandir}/man3/im_list_add.3*
%{_mandir}/man3/im_list_append.3*
%{_mandir}/man3/im_list_eq.3*
%{_mandir}/man3/im_list_fix.3*
%{_mandir}/man3/im_list_fold.3*
%{_mandir}/man3/im_list_free.3*
%{_mandir}/man3/im_list_index.3*
%{_mandir}/man3/im_list_insert.3*
%{_mandir}/man3/im_list_len.3*
%{_mandir}/man3/im_list_map.3*
%{_mandir}/man3/im_list_map_rev.3*
%{_mandir}/man3/im_list_member.3*
%{_mandir}/man3/im_list_pos.3*
%{_mandir}/man3/im_list_remove.3*
%{_mandir}/man3/im_litecor.3*
%{_mandir}/man3/im_log10tra.3*
%{_mandir}/man3/im_log_dmask.3*
%{_mandir}/man3/im_log_imask.3*
%{_mandir}/man3/im_logtra.3*
%{_mandir}/man3/im_lowpass.3*
%{_mandir}/man3/im_lrjoin.3*
%{_mandir}/man3/im_lrmerge.3*
%{_mandir}/man3/im_lrmosaic.3*
%{_mandir}/man3/im_magick2vips.3*
%{_mandir}/man3/im_magick2vips_header.3*
%{_mandir}/man3/im_makerw.3*
%{_mandir}/man3/im_malloc.3*
%{_mandir}/man3/im_maplut.3*
%{_mandir}/man3/im_mask2vips.3*
%{_mandir}/man3/im_matcat.3*
%{_mandir}/man3/im_match_linear.3*
%{_mandir}/man3/im_match_linear_search.3*
%{_mandir}/man3/im_matinv.3*
%{_mandir}/man3/im_matmul.3*
%{_mandir}/man3/im_mattrn.3*
%{_mandir}/man3/im_max.3*
%{_mandir}/man3/im_maxpos.3*
%{_mandir}/man3/im_maxvalue.3*
%{_mandir}/man3/im_mean_std_double_buffer.3*
%{_mandir}/man3/im_mean_std_int_buffer.3*
%{_mandir}/man3/im_measure.3*
%{_mandir}/man3/im_min.3*
%{_mandir}/man3/im_minpos.3*
%{_mandir}/man3/im_mmapin.3*
%{_mandir}/man3/im_mmapinrw.3*
%{_mandir}/man3/im_more.3*
%{_mandir}/man3/im_more_vec.3*
%{_mandir}/man3/im_moreconst.3*
%{_mandir}/man3/im_moreeq.3*
%{_mandir}/man3/im_moreeq_vec.3*
%{_mandir}/man3/im_moreeqconst.3*
%{_mandir}/man3/im_mpercent.3*
%{_mandir}/man3/im_multiply.3*
%{_mandir}/man3/im_notequal.3*
%{_mandir}/man3/im_notequal_vec.3*
%{_mandir}/man3/im_notequalconst.3*
%{_mandir}/man3/im_offsets45.3*
%{_mandir}/man3/im_offsets90.3*
%{_mandir}/man3/im_open.3*
%{_mandir}/man3/im_open_header.3*
%{_mandir}/man3/im_open_local.3*
%{_mandir}/man3/im_open_local_array.3*
%{_mandir}/man3/im_openout.3*
%{_mandir}/man3/im_or_vec.3*
%{_mandir}/man3/im_orconst.3*
%{_mandir}/man3/im_orimage.3*
%{_mandir}/man3/im_outcheck.3*
%{_mandir}/man3/im_paintrect.3*
%{_mandir}/man3/im_partial.3*
%{_mandir}/man3/im_pincheck.3*
%{_mandir}/man3/im_piocheck.3*
%{_mandir}/man3/im_plotmask.3*
%{_mandir}/man3/im_plotpoint.3*
%{_mandir}/man3/im_png2vips.3*
%{_mandir}/man3/im_png2vips_header.3*
%{_mandir}/man3/im_poutcheck.3*
%{_mandir}/man3/im_powtra.3*
%{_mandir}/man3/im_powtra_vec.3*
%{_mandir}/man3/im_ppm2vips.3*
%{_mandir}/man3/im_ppm2vips_header.3*
%{_mandir}/man3/im_prepare.3*
%{_mandir}/man3/im_prepare_to.3*
%{_mandir}/man3/im_print.3*
%{_mandir}/man3/im_print_dmask.3*
%{_mandir}/man3/im_print_imask.3*
%{_mandir}/man3/im_printdesc.3*
%{_mandir}/man3/im_printhd.3*
%{_mandir}/man3/im_printlines.3*
%{_mandir}/man3/im_profile.3*
%{_mandir}/man3/im_quantim.3*
%{_mandir}/man3/im_quantlut.3*
%{_mandir}/man3/im_rank.3*
%{_mandir}/man3/im_read_dmask.3*
%{_mandir}/man3/im_read_imask.3*
%{_mandir}/man3/im_readpoint.3*
%{_mandir}/man3/im_recomb.3*
%{_mandir}/man3/im_rect_dup.3*
%{_mandir}/man3/im_rect_equalsrect.3*
%{_mandir}/man3/im_rect_includespoint.3*
%{_mandir}/man3/im_rect_includesrect.3*
%{_mandir}/man3/im_rect_intersectrect.3*
%{_mandir}/man3/im_rect_isempty.3*
%{_mandir}/man3/im_rect_marginadjust.3*
%{_mandir}/man3/im_rect_normalise.3*
%{_mandir}/man3/im_rect_unionrect.3*
%{_mandir}/man3/im_region_create.3*
%{_mandir}/man3/im_region_free.3*
%{_mandir}/man3/im_region_image.3*
%{_mandir}/man3/im_region_local.3*
%{_mandir}/man3/im_region_position.3*
%{_mandir}/man3/im_region_region.3*
%{_mandir}/man3/im_remainder.3*
%{_mandir}/man3/im_remainderconst.3*
%{_mandir}/man3/im_remosaic.3*
%{_mandir}/man3/im_ri2c.3*
%{_mandir}/man3/im_rot180.3*
%{_mandir}/man3/im_rot270.3*
%{_mandir}/man3/im_rot90.3*
%{_mandir}/man3/im_rotate_dmask45.3*
%{_mandir}/man3/im_rotate_dmask90.3*
%{_mandir}/man3/im_rotate_imask45.3*
%{_mandir}/man3/im_rotate_imask90.3*
%{_mandir}/man3/im_rotquad.3*
%{_mandir}/man3/im_sRGB2XYZ.3*
%{_mandir}/man3/im_scale.3*
%{_mandir}/man3/im_scale_dmask.3*
%{_mandir}/man3/im_scaleps.3*
%{_mandir}/man3/im_setbuf.3*
%{_mandir}/man3/im_setupout.3*
%{_mandir}/man3/im_sharpen.3*
%{_mandir}/man3/im_shiftleft.3*
%{_mandir}/man3/im_shiftright.3*
%{_mandir}/man3/im_shrink.3*
%{_mandir}/man3/im_sign.3*
%{_mandir}/man3/im_simcontr.3*
%{_mandir}/man3/im_similarity.3*
%{_mandir}/man3/im_similarity_area.3*
%{_mandir}/man3/im_sines.3*
%{_mandir}/man3/im_sintra.3*
%{_mandir}/man3/im_slice.3*
%{_mandir}/man3/im_smear.3*
%{_mandir}/man3/im_smudge.3*
%{_mandir}/man3/im_spatres.3*
%{_mandir}/man3/im_spcor.3*
%{_mandir}/man3/im_start_many.3*
%{_mandir}/man3/im_start_one.3*
%{_mandir}/man3/im_stats.3*
%{_mandir}/man3/im_stdif.3*
%{_mandir}/man3/im_stop_many.3*
%{_mandir}/man3/im_stop_one.3*
%{_mandir}/man3/im_stretch3.3*
%{_mandir}/man3/im_subsample.3*
%{_mandir}/man3/im_subtract.3*
%{_mandir}/man3/im_system.3*
%{_mandir}/man3/im_tantra.3*
%{_mandir}/man3/im_tbjoin.3*
%{_mandir}/man3/im_tbmerge.3*
%{_mandir}/man3/im_tbmosaic.3*
%{_mandir}/man3/im_thresh.3*
%{_mandir}/man3/im_tiff2vips.3*
%{_mandir}/man3/im_tiff2vips_header.3*
%{_mandir}/man3/im_tone_analyse.3*
%{_mandir}/man3/im_tone_build.3*
%{_mandir}/man3/im_tone_map.3*
%{_mandir}/man3/im_updatehist.3*
%{_mandir}/man3/im_version.3*
%{_mandir}/man3/im_version_string.3*
%{_mandir}/man3/im_video_v4l1.3*
%{_mandir}/man3/im_vips2bufjpeg.3*
%{_mandir}/man3/im_vips2jpeg.3*
%{_mandir}/man3/im_vips2mask.3*
%{_mandir}/man3/im_vips2mimejpeg.3*
%{_mandir}/man3/im_vips2png.3*
%{_mandir}/man3/im_vips2ppm.3*
%{_mandir}/man3/im_vips2tiff.3*
#%{_mandir}/man3/im_warning.3*
%{_mandir}/man3/im_wrapmany.3*
%{_mandir}/man3/im_wrapone.3*
%{_mandir}/man3/im_write_dmask.3*
%{_mandir}/man3/im_write_dmask_name.3*
%{_mandir}/man3/im_write_imask.3*
%{_mandir}/man3/im_write_imask_name.3*
%{_mandir}/man3/im_writeline.3*
%{_mandir}/man3/im_zerox.3*
%{_mandir}/man3/im_zone.3*
%{_mandir}/man3/im_zoom.3*
%{_mandir}/man1/batch_crop.1
%{_mandir}/man3/IM_RECT_BOTTOM.3
%{_mandir}/man3/IM_RECT_HCENTRE.3
%{_mandir}/man3/IM_RECT_RIGHT.3
%{_mandir}/man3/IM_RECT_VCENTRE.3
%{_mandir}/man3/im_cache.3
%{_mandir}/man3/im_copy_swap.3
%{_mandir}/man3/im_diag.3
%{_mandir}/man3/im_error.3
%{_mandir}/man3/im_error_buffer.3
%{_mandir}/man3/im_error_clear.3
%{_mandir}/man3/im_extract_bands.3
%{_mandir}/man3/im_free.3
%{_mandir}/man3/im_lintra_vec.3
%{_mandir}/man3/im_make_xy.3
%{_mandir}/man3/im_rank_image.3
%{_mandir}/man3/im_render.3
%{_mandir}/man3/im_replicate.3
%{_mandir}/man3/im_rint.3
%{_mandir}/man3/im_text.3
%{_mandir}/man3/im_verror.3
%{_mandir}/man3/im_warn.3
#%{_datadir}/aclocal/vips.m4
%{_datadir}/doc/vips
%{_datadir}/vips/vdump.pro
%{_datadir}/vips/vips2dj/cmyk/head1
%{_datadir}/vips/vips2dj/cmyk/head2
%{_datadir}/vips/vips2dj/cmyk/head3
%{_datadir}/vips/vips2dj/cmyk/head4
%{_datadir}/vips/vips2dj/cmyk/head5
%{_datadir}/vips/vips2dj/cmyk/head6
%{_datadir}/vips/vips2dj/lab/head1
%{_datadir}/vips/vips2dj/lab/head2
%{_datadir}/vips/vips2dj/lab/head3
%{_datadir}/vips/vips2dj/lab/head4
%{_datadir}/vips/vips2dj/lab/head5
%{_datadir}/vips/vips2dj/lab/head6
%{_datadir}/vips/vips2dj/mono/head1
%{_datadir}/vips/vips2dj/mono/head2
%{_datadir}/vips/vips2dj/mono/head3
%{_datadir}/vips/vips2dj/mono/head4
%{_datadir}/vips/vips2dj/mono/head5
%{_datadir}/vips/vips2dj/mono/head6
%{_datadir}/locale/en_GB/LC_MESSAGES/vips7.mo
%{_datadir}/locale/malkovich/LC_MESSAGES/vips7.mo

%changelog
* Tue Oct 19 2004 William Emmanuel S. Yu <wyu@ateneo.edu> 7.10.4
- updated for 7.10.4
- commented out mkdirs since they are not necessary
- used generic library names instead of actual libraries
- updated %files

* Wed Jul 16 2003 John Cupitt <john.cupitt@ng-london.org.uk> 7.8.10
- updated for 7.8.10
- updated %files
- copies formatted docs to install area

* Wed Mar 12 2003 John Cupitt <john.cupitt@ng-london.org.uk> 7.8.8
- updated for 7.8.8, adding libdrfftw

* Mon Feb 3 2003 John Cupitt <john.cupitt@ng-london.org.uk> 7.8.7-2
- hack to change default install prefix to /usr/local

* Thu Jan 30 2003 John Cupitt <john.cupitt@ng-london.org.uk> 7.8.7-1
- first stab at an rpm package for vips
