// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#include "ViewPDF.h"
#include "AppController.h"


/*
 * Function protoypes. Wy is this still necessary?
 */
void createMenu();


/*
 * Basic-Initialization and Application startup.
 */
int main(int argc, const char *argv[])
{
   id NSApp;

   NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

   [AppController sharedController];

   NSApp = [NSApplication sharedApplication];

   createMenu();

   [NSApp setDelegate: [AppController sharedController]];
   
   [NSApp run];

   [[AppController sharedController] release];
   [NSApp release];
   [pool release];

   return EXIT_SUCCESS;
}


/*
 * Create the Applications Menu.
 */
void createMenu()
{
   NSMenu* menu;
   NSMenu* info;
   NSMenu* document;
   NSMenu* edit;
   NSMenu* format;
   NSMenu* pageLayout;
   NSMenu* display;
   NSMenu* find;
   NSMenu* windows;
   NSMenu* services;

   SEL action = @selector(method:);

   // Application Menu
   menu = [[NSMenu alloc] initWithTitle: APP_NAME];

   [menu addItemWithTitle: @"Info" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Document" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Edit" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Display" action: action keyEquivalent: @""];
   //[menu addItemWithTitle: @"Format" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Find" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Windows" action:action keyEquivalent:@""];
   [menu addItemWithTitle: @"Services" action: action keyEquivalent:@""];
   [menu addItemWithTitle: @"Hide" action: @selector(hide:) keyEquivalent: @"h"];
   [menu addItemWithTitle: @"Quit" action: @selector(terminate:) keyEquivalent: @"q"];

   // Info Menu
   info = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: info forItem: [menu itemWithTitle: @"Info"]];

   [info addItemWithTitle:_(@"Info Panel...") action: @selector(showInfoPanel:)
        keyEquivalent:@""];
   [[info itemWithTitle: @"Info Panel..."] setTarget: [AppController sharedController]];

   //[info addItemWithTitle: @"Preferences" action: @selector(showPrefs:)
   //      keyEquivalent: @""];
   //[[info itemWithTitle: @"Preferences"] setTarget: [AppController sharedController]];

   // Document Menu
   document = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: document forItem: [menu itemWithTitle: @"Document"]];
   
   [document addItemWithTitle: @"Open... " action: @selector(openDocument:)
             keyEquivalent: @"o"];
   [document addItemWithTitle: @"Close" action: @selector(performClose:)
             keyEquivalent: @""];

   // Edit Menu
   edit = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: edit forItem: [menu itemWithTitle: @"Edit"]];

   [edit addItemWithTitle:_(@"Copy") action:@selector(copy:) keyEquivalent:@"c"];

   // Display Menu
   display = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: display forItem: [menu itemWithTitle: @"Display"]];
   
   [display addItemWithTitle: @"Previous Page" action: @selector(previousPage:)
            keyEquivalent: @"b"];
   [display addItemWithTitle: @"Next Page" action: @selector(nextPage:)
            keyEquivalent: @"d"];
   [display addItemWithTitle: @"Zoom in" action: @selector(zoomIn:)
            keyEquivalent: @"+"];
   [display addItemWithTitle: @"Zoom out" action: @selector(zoomOut:)
            keyEquivalent: @"-"];
   [display addItemWithTitle: @"Original Size" action: @selector(zoomToRealSize:)
            keyEquivalent: @"."];
   [display addItemWithTitle: @"Fit in Window" action: @selector(sizePageToFit:)
            keyEquivalent: @"i"];
   [display addItemWithTitle: @"Fit width" action: @selector(sizePageToFitWidth:)
            keyEquivalent: @"I"];
   [display addItemWithTitle: @"Set Bookmark" action: @selector(setBookmark:)
            keyEquivalent: @"B"];
   [display addItemWithTitle: @"Go to last Bookmark" action: @selector(gotoLastBookmark:)
            keyEquivalent: @"j"];
   [display addItemWithTitle: @"Document Outline" action: @selector(showOutlinePanel:)
            keyEquivalent: @""];
   [display addItemWithTitle: @"Toggle Toolbar Visibility"
            action: @selector(toggleToolbarVisible:) keyEquivalent: @"t"];

   // Format Menu
   format = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: format forItem: [menu itemWithTitle: @"Format"]];

   [format addItemWithTitle: @"Page Layout" action: @selector(showPageLayoutPanel:)
           keyEquivalent: @""];

   // Find Menu
   find = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: find forItem: [menu itemWithTitle: @"Find"]];
   
   [find addItemWithTitle: @"Find Panel" action: @selector(showFindPanel:)
         keyEquivalent: @"f"];
   [find addItemWithTitle: @"Next" action: @selector(findNext:)
         keyEquivalent: @"g"];
   [find addItemWithTitle: @"Previous" action: @selector(findPrevious:)
         keyEquivalent: @"G"];

   // Windows Menu
   windows = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: windows forItem: [menu itemWithTitle: @"Windows"]];

   [windows addItemWithTitle: @"Arrange"  action:@selector(arrangeInFront:)
            keyEquivalent:@""];
   [windows addItemWithTitle: @"Miniaturize" action:@selector(performMiniaturize:)
            keyEquivalent:@"m"];
   [windows addItemWithTitle: @"Close" action:@selector(performClose:)
            keyEquivalent:@"w"];

   // Services Menu
   services = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: services forItem: [menu itemWithTitle: @"Services"]];


   [[NSApplication sharedApplication] setMainMenu: menu];
   [[NSApplication sharedApplication] setServicesMenu: services];
   [[NSApplication sharedApplication] setWindowsMenu: windows];
}
