
// created 11.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_MATCH_POSITION
#define _H_MATCH_POSITION

#include "DocumentPosition.h"

#include <Foundation/NSObject.h>


@interface Match : NSObject
{
   DocumentPosition* position;
   NSString*         context;
   NSString*         searchText;
}

- (id) initWithPosition: (DocumentPosition*)_position
                context: (NSString*)_context
             searchText: (NSString*)_searchText;
- (id) init;
- (void) dealloc;

+ (Match*) matchAt: (DocumentPosition*)_position
           context: (NSString*)_context
        searchText: (NSString*)_searchText;

- (DocumentPosition*) position;
- (void) setPosition: (DocumentPosition*)_position;

- (NSString*) context;
- (void) setContext: (NSString*)_context;

- (NSString*) searchText;
- (void) setSearchText: (NSString*)_searchText;

@end

#endif
