
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_IMAGE_WINDOW
#define _H_IMAGE_WINDOW

#include <AppKit/NSApplication.h>
#include <AppKit/NSWindow.h>

#include "PDFContentView.h"


@class DocumentWindowController;
@class NSView;
@class NSButton;
@class NSMutableArray;
@class NSProgressIndicator;
@class NSEvent;

@interface DocumentWindow : NSWindow
{
   PDFContentView*           documentView;
   DocumentWindowController* myController;
   NSView*                   toolbar;
   BOOL                      toolbarVisible;
   NSMutableArray*           tbElements;
   NSButton*                 tbNextPage;
   NSButton*                 tbPrevPage;
   NSButton*                 tbZoomIn;
   NSButton*                 tbZoomOut;
   NSButton*                 tbZoomToRealSize;
   NSButton*                 tbSizeToFit;
   NSButton*                 tbSizeToFitWidth;
   NSProgressIndicator*      tbProgressBar;
}

- (id) init;
- (void) dealloc;

- (void) setController: (DocumentWindowController*)controller;
- (void) windowInitializedWithController;

- (PDFContentView*) documentView;
- (NSProgressIndicator*) toolbarProgressBar;

- (void) setDisplayPageNavigation: (BOOL)displayPageNav;

- (void) setToolbarVisible: (BOOL)visible;
- (BOOL) toolbarIsVisible;

- (void) keyDown: (NSEvent*)theEvent;

@end

#define TOOLBAR_HEIGHT 68.0

#endif
