
// created 11.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include "DocumentPosition.h"


/*
 * Non-Public methods.
 */
@interface DocumentPosition(Private)
@end


/*
 * Specifies a position somewhere in the document. The position
 * is indentified by the page and a rectangular area on this
 * page.
 */
@implementation DocumentPosition

- (id) initWithPage: (int)aPage boundingRect: (NSRect)rect
{
   if ((self = [super init]))
   {
      [self setPage: aPage];
      [self setBoundingRect: rect];
   }

   return self;
}


+ (DocumentPosition*) positionAtPage: (int)aPage boundingRect: (NSRect)rect
{
   DocumentPosition* pos =
      [[DocumentPosition alloc] initWithPage: aPage boundingRect: rect];

   return [pos autorelease];
}


- (int) page
{
   return page;
}


- (void) setPage: (int)aPage
{
   page = aPage;
}


- (NSRect) boundingRect
{
   return boundingRect;
}


- (void) setBoundingRect: (NSRect)rect
{
   boundingRect = rect;
}

@end
