//	Vamos Automotive Simulator
//  Copyright (C) 2001--2003 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <vamos/geometry/Texture_Image.h>

//#include <stdio.h> // libpng uses FILE.
//#include <png.h>

Vamos_Geometry::Texture_Image::
Texture_Image (std::string file_name, double width, double height) : 
  m_width (width),
  m_height (height)
{
  // See if the file is a PNG file.
/*  FILE *fp = fopen (file_name.c_str (), "rb");
  if (!fp)
    {
	  throw Missing_Texture_File (file_name);
    }

  png_byte header [8];
  fread (header, 1, 8, fp);
  bool is_png = !png_sig_cmp (header, 0, 8);
  if (!is_png)
    {
	  throw Missing_Texture_File (file_name);
    }
  
  // Initialize the structures.
  png_structp png_ptr = 
	png_create_read_struct (PNG_LIBPNG_VER_STRING, 0, 0, 0);
  if (png_ptr == 0)
	{
	  throw Missing_Texture_File (file_name);
	}

  png_infop info_ptr = png_create_info_struct (png_ptr);
  if (info_ptr == 0)
	{
	  png_destroy_read_struct (&png_ptr, 0, 0);
	  throw Missing_Texture_File (file_name);
	}

  png_infop end_info = png_create_info_struct (png_ptr);
  if (end_info == 0)
	{
	  png_destroy_read_struct(&png_ptr, &info_ptr, 0);
	  throw Missing_Texture_File (file_name);
	}
  
  png_init_io (png_ptr, fp);
  png_set_sig_bytes (png_ptr, 8);
  png_read_png (png_ptr, info_ptr, PNG_TRANSFORM_IDENTITY, 0);

  fclose (fp);

  png_bytep* row_pointers = png_get_rows (png_ptr, info_ptr);

  m_width_pixels = info_ptr->width;
  m_height_pixels = info_ptr->height;
  m_channels = info_ptr->channels;
  size_t row_size = info_ptr->width * info_ptr->channels;

  m_data_size = row_size * m_height_pixels;
  m_data = new unsigned char [m_data_size];

  for (size_t i = 0; i < info_ptr->height; i++)
	{
	  for (size_t j = 0; j < row_size; j++)
		{
		  m_data [i * row_size + j] = row_pointers [i][j];
		}
	}

  png_destroy_read_struct (&png_ptr, &info_ptr, &end_info);*/
  
  m_width_pixels = 256;
  m_height_pixels = 256;
  m_data_size = 0;
//  m_data = NULL;
  m_channels = 3;
}

Vamos_Geometry::Texture_Image::
Texture_Image (const Texture_Image& image)
{
  m_height_pixels = image.m_height_pixels;
  m_width_pixels = image.m_width_pixels;
  m_channels = image.m_channels;
  m_data_size = image.m_data_size;

}

const Vamos_Geometry::Texture_Image& Vamos_Geometry::Texture_Image::
operator = (const Texture_Image& image)
{
  if (&image != this)
	{
	  m_height_pixels = image.m_height_pixels;
	  m_width_pixels = image.m_width_pixels;
	  m_channels = image.m_channels;
	  m_data_size = image.m_data_size;
	}
  return *this;
}
