// Linear_Interpolator.h - a piecewise-linear interpolator.
//
//	Vamos Automotive Simulator
//  Copyright (C) 2003 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _LINEAR_INTERPOLATOR_H_
#define _LINEAR_INTERPOLATOR_H_

#include <vamos/geometry/Interpolator.h>
#include <vamos/geometry/Two_Point.h>
#include <vector>

namespace Vamos_Geometry
{
  class Linear_Interpolator : public Interpolator
  {
	std::vector <Two_Point> m_points;

	mutable double m_delta_x;
	mutable double m_delta_y;

  public:
	// Construct an empty curve.
	Linear_Interpolator ();

	// Construct a cuvre from an array of points.
	Linear_Interpolator (const std::vector <Two_Point>& points);

	// Add a point to the curve.
	void load (const Two_Point& point);

	// Add multiple points to the curve.
	void load (const std::vector <Two_Point>& points);
  
	// Remove all points from the curve.
	void clear ();

	// Remove points with x > LIMIT.
	void remove_greater (double limit);

	// Scale all of the x values by FACTOR.
	void scale (double factor);

	// Return the y value at the x value DIST
	double interpolate (double dist) const;

	// Return the normal to the tanget at DIST.
	Two_Point normal (double dist) const;
  };
}

#endif
