#ifndef _VGUI_PAGE_H
#define _VGUI_PAGE_H

/* page.h */
#include <map>
#include <string>
#include <GL/gl.h>
#include <SDL/SDL.h>
#include "multiplay.h"
#include "textures.h"
#include "font.h"
#include "gamestate.h"
#include "settings.h"
#include "configfile.h"
#include "globals.h"
#include "widget.h"

namespace VGUI
{
	class Page
	{
	private:
		void Init();
		void DeInit();
		void ReleaseWidgets();

		vector<Widget*> page_objects;
		vector<Page*> tabs;
		CONFIGFILE menu_file;
		TEXTURE_HANDLE background, tab_active, tab_inactive, tab_page_background;
		string path;
		string name, tab_text;
		unsigned int cur_obj, cancel_obj, default_obj, cur_tab;
		unsigned int num_widgets, num_tabs;
		unsigned int clicked_obj;
		bool is_dialog, l_pressed, r_pressed;
		bool has_changes;

	public:
		Page();
		Page( string filename );
		~Page();
		void Draw();
		void Draw( float opacity );
		void UpWidget();
		void DownWidget();
		void RightWidgetPress();
		void LeftWidgetPress();
		void RightWidgetRelease();
		void LeftWidgetRelease();
		void BackspacePress();
		void DeletePress();
		void BackspaceRelease();
		void DeleteRelease();
		void KeyPress();
		string KeyRelease();
		void Type( SDLKey key );
		void CancelPress();
		string CancelRelease();
		string ExecWidget();
		void SaveSettings();
		void ClearSettings();
		void SelectDefault() { page_objects[cur_obj]->SetSelected( false ); cur_obj = default_obj; page_objects[cur_obj]->SetSelected( true ); }
		void MouseSelect( float x, float y );
		bool MouseOver( float x, float y );
		string MousePressWidget( float x, float y );
		string MouseReleaseWidget( float x, float y );
		void StartGame();
		void ControlGrabKey( SDLKey key );
		void ControlGrabMouseMove( string direction );
		void ControlGrabMouseButton( int button_idx );
		void ControlGrabJoyButton( Uint8 joy_idx, Uint8 joy_btn );
		void ControlGrabJoyMove( Uint8 joy_idx, Uint8 joy_axis, bool joy_positive, float joy_value );
		bool HasChanges() { return has_changes; }

		Widget* GetWidget( int idx ) { return page_objects[idx]; }
		bool GetDialog() { return is_dialog; }
		int GetNumWidgets() { return num_widgets; }
		string GetName() { return name; }
		string GetTabText() { return tab_text; }
		void SetDialog( bool new_dialog ) { is_dialog = new_dialog; }
		void SetName( string new_name ) { name = new_name; }
	};
}

#endif // _VGUI_PAGE_H
