#ifndef _VGUI_CONTROLGRAB_H
#define _VGUI_CONTROLGRAB_H

/* controlgrab.h */
#include "controls.h"
#include "gui/gui.h"

namespace VGUI
{
	class ControlSet
	{
	private:
		string name;
		CONTROL ctrl;
		TEXTURE_HANDLE * tex, * tex_x;

	public:
		ControlSet() { name = ""; tex = tex_x = NULL; }
		~ControlSet() { }
		string GetName() { return name; }
		void SetName( string new_name ) { name = new_name; }
		CONTROL& GetControl() { return ctrl; }
		void SetControl( CONTROL &new_ctrl ) { ctrl = new_ctrl; }
		TEXTURE_HANDLE * GetTex() { return tex; }
		void SetTex( TEXTURE_HANDLE * new_tex ) { tex = new_tex; }
		TEXTURE_HANDLE * GetTexX() { return tex_x; }
		void SetTexX( TEXTURE_HANDLE * new_tex_x ) { tex_x = new_tex_x; }
	};


	class ControlGrab : public Widget
	{
	private:
		void BuildControlVectors();

		TEXTURE_HANDLE add_tex, add_tex_sel;
		TEXTURE_HANDLE key_tex, joy_axis_tex, joy_btn_tex, mouse_btn_tex, mouse_move_tex;
		TEXTURE_HANDLE key_tex_x, joy_axis_tex_x, joy_btn_tex_x, mouse_btn_tex_x, mouse_move_tex_x;
		bool l_down, r_down, mbtn_down, adding, pressed;
		bool analog;
		string setting;
		float spacing;
		vector<ControlSet> local_controls;
		unsigned int selected_icon, pressed_icon, clicked_icon;
		Uint32 add_start;

	public:
		ControlGrab();
		ControlGrab( Widget *w );
		~ControlGrab();

		void Draw();
		void Draw( float opacity );
		void Save();
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void ResetValue();
		void IncValuePress();
		void DecValuePress();
		void IncValueRelease();
		void DecValueRelease();
		void Press();
		void Release();
		void GrabKey( SDLKey key );
		void GrabMouseMovement( string direction );
		void GrabMouseButton( int button_idx );
		void GrabJoyButton( Uint8 joy_idx, Uint8 joy_btn );
		void GrabJoyMove( Uint8 joy_idx, Uint8 joy_axis, bool joy_positive, float joy_value );
		void SelectIcon( unsigned int new_selected_icon ) { selected_icon = new_selected_icon; }

		string GetSetting() { return setting; }
		float GetSpacing() { return spacing; }
		bool GetAdding() { return adding; }
		bool GetAnalog() { return analog; }
		void SetSetting( string new_setting ) { setting = new_setting; BuildControlVectors(); }
		void SetSpacing( float new_spacing );
		void SetAnalog( bool new_analog ) { analog = new_analog; }
	};
}

#endif // _VGUI_CONTROLGRAB_H
