#ifndef __EPGSEARCHRES_H
#define __EPGSEARCHRES_H

#include <vdr/menuitems.h>
#include <vdr/recording.h>
#include "templatefile.h"
#include "epgsearchext.h"
#include "menu_event.h"

typedef enum
{
    showTitleEpisode,
    showEpisode
} ModeYellowSR;

typedef enum
{
    showAll,
    showNoPayTV,
    showTimerPreview
} ModeBlueSR;

// --- cMenuSearchResultsItem ------------------------------------------------------
class cMenuSearchResultsItem : public cOsdItem {
    char *fileName; // for search in recordings
    bool previewTimer;
    bool episodeOnly;
    cMenuTemplate* menuTemplate;
 public: 
    int timerMatch;
    const cEvent *event;
    const cSearchExt* search;
    const char *FileName(void) { return fileName; }
    cMenuSearchResultsItem(const cEvent *EventInfo, bool EpisodeOnly = false, 
                           bool PreviewTimer = false, cMenuTemplate* MenuTemplate = NULL, 
                           const cSearchExt* Search = NULL);
    cMenuSearchResultsItem(cRecording *Recording);
    bool Update(bool Force = false);
};

// --- cMenuSearchResults ------------------------------------------------------
class cMenuSearchResults : public cOsdMenu {
    friend class cMenuFavorites;
 protected:
    cMenuTemplate* menuTemplate;
    bool ignoreRunning;
    cEventObjects eventObjects;

    virtual bool BuildList()=0;
    virtual eOSState ProcessKey(eKeys Key);
    eOSState ShowSummary(void);
    virtual eOSState OnRed(cSearchExt* searchExt = NULL);
    virtual eOSState OnGreen();
    virtual eOSState OnYellow();
    eOSState Record(void);
    eOSState Switch(void);
    eOSState Commands(eKeys Key, cSearchExt* SearchExt = NULL);
    int GetTab(int Tab);
    virtual void SetHelpKeys(void)=0;
    bool Update(void);
    void UpdateCurrent();
    
    static const cEvent *scheduleEventInfo;
    ModeYellowSR modeYellow;
    ModeBlueSR modeBlue;
 public:
    bool m_bSort;
    
    cMenuSearchResults(cMenuTemplate* MenuTemplate);
};

// --- cMenuSearchResultsForSearch ------------------------------------------------------
class cMenuSearchResultsForSearch : public cMenuSearchResults {
  protected:
    cSearchExt* searchExt;
    virtual bool BuildList();
    virtual void SetHelpKeys(void);
    eOSState ProcessKey(eKeys Key);
  public:
    cMenuSearchResultsForSearch(cSearchExt*, cMenuTemplate* MenuTemplate);
};

class cBlacklist;
// --- cMenuSearchResultsForBlacklist ------------------------------------------------------
class cMenuSearchResultsForBlacklist : public cMenuSearchResults {
    cBlacklist* blacklist;
    virtual bool BuildList();
    virtual void SetHelpKeys(void);
    eOSState ProcessKey(eKeys Key);
  public:
    cMenuSearchResultsForBlacklist(cBlacklist*);
};

// --- cMenuSearchResultsForQuery ------------------------------------------------------
class cMenuSearchResultsForQuery : public cMenuSearchResultsForSearch {
  public:
   cMenuSearchResultsForQuery(const char *query, bool IgnoreRunning = false);
   ~cMenuSearchResultsForQuery();
   virtual bool BuildList();
};

// --- cMenuSearchResultsForRecs ------------------------------------------------------
class cMenuSearchResultsForRecs : public cMenuSearchResultsForQuery {
    virtual bool BuildList();
    eOSState ProcessKey(eKeys Key);
    eOSState Play(void);
    cRecording *GetRecording(cMenuSearchResultsItem *Item);
  public:
   cMenuSearchResultsForRecs(const char *query);
};

// --- cMenuSearchResultsForList ------------------------------------------------------
class cMenuSearchResultsForList : public cMenuSearchResults {
  protected:
    cSearchResults* searchResults;
    virtual bool BuildList();
    virtual void SetHelpKeys(void);
    virtual eOSState ProcessKey(eKeys Key);
  public:
    cMenuSearchResultsForList(cSearchResults& SearchResults, const char* Title, bool IgnoreRunning = false);
};

#endif
