/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdkxdb/vdkxdb.h>
#include <vdkxdb/vdkxtable.h>
#include <vdkxdb/vdkxctrl.h>


/*
 */
VDKXTable::VDKXTable(VDKXDatabase* owner, char* s): 
  xbDbf(owner),
  Size("Size",this,0L,&xbDbf::NoOfRecords,NULL),
  Order("Order",this, -1, &VDKXTable::SetOrder),
  ShowDeleted("ShowDeleted",this,false),
  // internal use only, user don't care.
  Active("Active",this,false)

{
  if(s)
    name = s;
  owner->TList()->add(this);
  SetVersion(4);
  open = false;
  activeIndex = NULL;
}

/*
 */
VDKXTable::~VDKXTable()
{
  if(IsOpen())
    Close();
  IndexListIterator li(iList);
  for(;li;li++)
    {
      VDKXTableIndex *index = li.current();
      delete index;
    }
}

/*
 */
xbShort
VDKXTable::Create(VDKXRecordTemplate* tpl, 
		  bool overwrite)
{
  xbShort rc =  CreateDatabase((char*) name, 
			tpl, 
			overwrite ? 
			XB_OVERLAY : XB_DONTOVERLAY);
#if VDKXDBDEBUG
  printf("\nCreating table:%s - %s",(char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  return rc;
}
/*
 */
xbShort
VDKXTable::Open(void)
{
  xbShort rc = OpenDatabase(name);
  if(rc == XB_NO_ERROR)
    open = true;
#if VDKXDBDEBUG
  printf("\nOpening table:%s - %s", (char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  return rc;
}
/*
 */
xbShort
VDKXTable::Close(void)
{
  xbShort rc = CloseDatabase();
  if(rc == XB_NO_ERROR)
    open = false;
#if VDKXDBDEBUG
  printf("\nClosing table:%s - %s", (char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  return rc;
}
/*
 */
bool 
VDKXTable::RemoveIndex(char* name)
{
  int result = 0;
  VDKXTableIndex* index = Index(name);
  if(index)
    {
      if(index->IsOpen())
	index->Close();
      result = iList.remove(index);
      if(index == activeIndex)
	activeIndex = NULL;
      if(result)
	delete index;
    }
  return result;
}
/*
 */
VDKXTableIndex* 
VDKXTable::Index(char* s)
{
  VDKXTableIndex* index = (VDKXTableIndex*) NULL;
  VDKString iname = s;
  if(iList.size() <= 0)
    return index;
  IndexListIterator li(iList);
  for(;li;li++)
    if( !strcmp(iname,li.current()->Name()) )
      {
	index = li.current();
	break;
      }
  return index;
}
/*
 */
VDKXTableIndex* 
VDKXTable::Index(xbShort order)
{

  return (order >= 0) && (order < iList.size()) ? 
    iList[order] : 
    (VDKXTableIndex*) NULL;
}
/*
 */
void 
VDKXTable::SetOrder(xbShort ndx)
{
  Order( (ndx >= 0) && (ndx < iList.size()) ? ndx : -1);
  if(Order >= 0)
    activeIndex = iList[ndx];
  else
    activeIndex = NULL;
}
/*
 */
void 
VDKXTable::SetOrder(char* name)
{
  if(name)
    {
      VDKXTableIndex* index = Index(name);
      int ndx = iList.at(index);
      if(ndx >= 0)
	SetOrder(ndx);
    }
  else
    {
      activeIndex = NULL;
      Order(-1);
    }
}

/*
 */
xbShort 
VDKXTable::First()
{
  xbShort rc;
  if(ShowDeleted)
	rc =  activeIndex ? activeIndex->GetFirstKey() : GetFirstRecord();
  else
    {
      rc = activeIndex ? activeIndex->GetFirstKey() : GetFirstRecord();
      if(RecordDeleted())
	rc = Next();
    }
  return rc;
}
/*
 */
xbShort 
VDKXTable::Last()
{
  xbShort rc;
  if(ShowDeleted)
	return activeIndex ? activeIndex->GetLastKey() : GetLastRecord();
  else
    {
      rc = activeIndex ? activeIndex->GetLastKey() : GetLastRecord();
      if(RecordDeleted())
	rc = Prev();
    }
  return rc;
}
/*
 */
xbShort 
VDKXTable::Next()
{
  xbShort rc = XB_NO_ERROR;
  if(ShowDeleted)
	rc = activeIndex ? activeIndex->GetNextKey() : GetNextRecord();
  else
    {
      bool stop = false;
      do
	{
	  rc = activeIndex ? activeIndex->GetNextKey() : GetNextRecord();
	  stop = (rc != XB_NO_ERROR) || ! RecordDeleted();
	}
      while(!stop);
    }
  return rc;
}
/*
 */
xbShort 
VDKXTable::Prev()
{
  xbShort rc = XB_NO_ERROR;
  if(ShowDeleted)
	rc = activeIndex ? activeIndex->GetPrevKey() : GetPrevRecord();
  else
    {
      bool stop = false;
      do
	{
	  rc = activeIndex ? activeIndex->GetPrevKey() : GetPrevRecord();
	  stop = (rc != XB_NO_ERROR) || ! RecordDeleted();
	}
      while(!stop);
    }
  return rc;
}

/*
---------------------
VDKXTableIndex class
---------------------
*/
VDKXTableIndex::VDKXTableIndex(VDKXTable* owner,
			       char* s
			       ):
  xbNdx(owner),table(owner)
{
  if(s)
    name = s;
  owner->NdxList()->add(this);
  open = false;
}
/*
 */
VDKXTableIndex::~VDKXTableIndex()
{
}
/*
 */
xbShort
VDKXTableIndex::Create(char* k,
		       bool unique,
		       bool overwrite)
{
  key = k;
  xbShort rc =  CreateIndex((char*) name, 
		     key, 
		     unique ? XB_UNIQUE : XB_NOT_UNIQUE, 
		     overwrite ? 
		     XB_OVERLAY : XB_DONTOVERLAY);
#if VDKXDBDEBUG
  printf("\nCreating index:%s - %s", (char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  return rc;
}
/*
 */
xbShort
VDKXTableIndex::Open(void)
{
  xbShort rc =  OpenIndex(name);
  if(rc == XB_NO_ERROR)
    open = true;
#if VDKXDBDEBUG
  printf("\nOpening index:%s - %s", (char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  if(rc == XB_NO_ERROR)
    {
      char *buff = new char[XB_NDX_NODE_SIZE];
      GetExpression(buff,XB_NDX_NODE_SIZE-1);
#if VDKXDBDEBUG
  printf("\nIndex:%s - got key:%s",(char*) name,buff);
  fflush(stdout);
#endif      
      key = buff;
    }
  return rc;
}
/*
 */
xbShort
VDKXTableIndex::Close(void)
{
  xbShort rc =  CloseIndex();
  if(rc == XB_NO_ERROR)
    open = false;
#if VDKXDBDEBUG
  printf("\nClosing index:%s - %s",(char*) name,VDKXError(rc));
  fflush(stdout);
#endif
  return rc;
}




